/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import perffmwk.PerformanceStatistics;

public class StatSpecId
implements Serializable {
    private String systemName;
    private String typeName;
    private String instanceName;
    private String statName;
    private Pattern systemNamePattern;
    private Pattern instanceNamePattern;

    public StatSpecId() {
    }

    public StatSpecId(PerformanceStatistics statInst, StatisticDescriptor statDesc) {
        this.systemName = "*";
        this.typeName = statInst.statistics().getType().getName();
        this.instanceName = "*";
        this.statName = statDesc.getName();
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getStatName() {
        return this.statName;
    }

    public void setStatName(String statName) {
        this.statName = statName;
    }

    public String toString() {
        return this.systemName + " " + this.typeName + " " + this.instanceName + " " + this.statName;
    }

    protected Pattern getSystemPattern() {
        if (this.systemNamePattern == null) {
            this.systemNamePattern = this.patternFor(this.systemName);
        }
        return this.systemNamePattern;
    }

    protected Pattern getInstancePattern() {
        if (this.instanceNamePattern == null) {
            this.instanceNamePattern = this.patternFor(this.instanceName);
        }
        return this.instanceNamePattern;
    }

    private Pattern patternFor(String s) {
        String result = new String();
        StringTokenizer tokenizer = new StringTokenizer(s, "*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("*")) {
                result = result + ".";
            }
            result = result + token;
        }
        return Pattern.compile(result);
    }
}

