/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.internal.StatArchiveReader;
import hydra.Log;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import perffmwk.PerfReporter;
import perffmwk.PerfStatException;
import perffmwk.PerformanceStatistics;
import perffmwk.StatConfig;
import perffmwk.StatConfigException;
import perffmwk.StatSpecId;

public class StatSpec
implements StatArchiveReader.StatSpec,
Serializable {
    protected String name;
    private StatSpecId id;
    private String trimspecName;
    protected StatConfig statconfig;
    protected boolean exactMatch = false;
    private String description = "No description";
    private int filter = 1;
    private int combine = 0;
    private boolean min = false;
    private boolean max = false;
    private boolean maxminusmin = false;
    private boolean mean = false;
    private boolean stddev = false;
    private boolean minExpr = false;
    private boolean maxExpr = false;
    private boolean maxminusminExpr = false;
    private boolean meanExpr = false;
    private boolean stddevExpr = false;
    private boolean minCompare = false;
    private boolean maxCompare = false;
    private boolean maxminusminCompare = false;
    private boolean meanCompare = false;
    private boolean stddevCompare = false;

    protected StatSpec(String name) {
        this.name = name;
    }

    protected StatSpec(PerformanceStatistics statInst, StatisticDescriptor statDesc) {
        this.name = null;
        this.id = new StatSpecId(statInst, statDesc);
        this.trimspecName = statInst.getTrimSpecName();
        this.filter = statDesc.isCounter() ? 1 : 0;
        this.combine = 2;
        if (this.filter == 1) {
            this.min = true;
            this.max = true;
            this.mean = true;
            this.stddev = true;
            this.meanCompare = true;
        } else if (statDesc.isCounter()) {
            this.maxminusmin = true;
            this.maxminusminCompare = true;
        } else {
            this.min = true;
            this.max = true;
            this.maxCompare = true;
            this.mean = true;
        }
    }

    public int getCombineType() {
        return this.combine;
    }

    public boolean archiveMatches(File archive) {
        if (this.statconfig != null && this.statconfig.isNativeClient()) {
            return true;
        }
        return this.getMatchingArchives().contains(archive);
    }

    public boolean typeMatches(String typeName) {
        if (this.exactMatch) {
            return typeName.toLowerCase().equals(this.getTypeName().toLowerCase());
        }
        return typeName.toLowerCase().endsWith(this.getTypeName().toLowerCase());
    }

    public boolean statMatches(String statName) {
        return this.getStatName().equalsIgnoreCase(statName);
    }

    public boolean instanceMatches(String textId, long numericId) {
        Matcher m = this.getInstancePattern().matcher(textId);
        if (m.matches()) {
            return true;
        }
        m = this.getInstancePattern().matcher(String.valueOf(numericId));
        return m.matches();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.id.getTypeName();
    }

    public Pattern getInstancePattern() {
        return this.id.getInstancePattern();
    }

    public String getStatName() {
        return this.id.getStatName();
    }

    protected List getMatchingArchives() {
        List archives = this.statconfig.getMatchingArchiveCache(this.name);
        if (archives == null) {
            SortedMap allArchives = this.statconfig.getStatisticArchives();
            archives = this.findMatchingArchives(allArchives, this.getId());
            this.statconfig.setMatchingArchiveCache(this.name, archives);
        }
        return archives;
    }

    protected List findMatchingArchives(SortedMap allArchives, StatSpecId id) {
        ArrayList matchingArchives = new ArrayList();
        Pattern pattern = id.getSystemPattern();
        for (String logicalSystemName : allArchives.keySet()) {
            List archives;
            if (!pattern.matcher(logicalSystemName).matches() || (archives = (List)allArchives.get(logicalSystemName)) == null) continue;
            matchingArchives.addAll(archives);
            if (!Log.getLogWriter().finestEnabled()) continue;
            Log.getLogWriter().finest("Matched " + id.getSystemName() + " ==> " + archives);
        }
        return matchingArchives;
    }

    public void setExactMatch(boolean boolArg) {
        this.exactMatch = boolArg;
    }

    public void setStatConfig(StatConfig statconfig) {
        this.statconfig = statconfig;
    }

    public StatSpecId getId() {
        return this.id;
    }

    public void setId(StatSpecId id) {
        this.id = id;
    }

    public int getFilter() {
        return this.filter;
    }

    public void setFilter(String filterType) {
        this.filter = this.getFilterFromString(filterType);
    }

    public void setFilter(int filter) {
        this.filter = filter;
    }

    public void setCombineType(String combineType) {
        this.combine = this.getCombineFromString(combineType);
    }

    public void setCombineType(int combine) {
        this.combine = combine;
    }

    public boolean getMin() {
        return this.min;
    }

    public void setMin(boolean b) {
        this.min = b;
    }

    public boolean getMax() {
        return this.max;
    }

    public void setMax(boolean b) {
        this.max = b;
    }

    public boolean getMaxMinusMin() {
        return this.maxminusmin;
    }

    public void setMaxMinusMin(boolean b) {
        this.maxminusmin = b;
    }

    public boolean getMean() {
        return this.mean;
    }

    public void setMean(boolean b) {
        this.mean = b;
    }

    public boolean getStddev() {
        return this.stddev;
    }

    public void setStddev(boolean b) {
        this.stddev = b;
    }

    public boolean getMinExpr() {
        return this.minExpr;
    }

    public void setMinExpr(boolean b) {
        this.minExpr = b;
    }

    public boolean getMaxExpr() {
        return this.maxExpr;
    }

    public void setMaxExpr(boolean b) {
        this.maxExpr = b;
    }

    public boolean getMaxMinusMinExpr() {
        return this.maxminusminExpr;
    }

    public void setMaxMinusMinExpr(boolean b) {
        this.maxminusminExpr = b;
    }

    public boolean getMeanExpr() {
        return this.meanExpr;
    }

    public void setMeanExpr(boolean b) {
        this.meanExpr = b;
    }

    public boolean getStddevExpr() {
        return this.stddevExpr;
    }

    public void setStddevExpr(boolean b) {
        this.stddevExpr = b;
    }

    public boolean getMinCompare() {
        return this.minCompare;
    }

    public void setMinCompare(boolean b) {
        this.minCompare = b;
    }

    public boolean getMaxCompare() {
        return this.maxCompare;
    }

    public void setMaxCompare(boolean b) {
        this.maxCompare = b;
    }

    public boolean getMaxMinusMinCompare() {
        return this.maxminusminCompare;
    }

    public void setMaxMinusMinCompare(boolean b) {
        this.maxminusminCompare = b;
    }

    public boolean getMeanCompare() {
        return this.meanCompare;
    }

    public void setMeanCompare(boolean b) {
        this.meanCompare = b;
    }

    public boolean getStddevCompare() {
        return this.stddevCompare;
    }

    public void setStddevCompare(boolean b) {
        this.stddevCompare = b;
    }

    public String getTrimSpecName() {
        return this.trimspecName;
    }

    public void setTrimSpecName(String trimspecName) {
        this.trimspecName = trimspecName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected StatSpec distill() {
        if (!this.getMinCompare() && !this.getMinExpr()) {
            this.setMin(false);
        }
        if (!this.getMaxCompare() && !this.getMaxExpr()) {
            this.setMax(false);
        }
        if (!this.getMeanCompare() && !this.getMeanExpr()) {
            this.setMean(false);
        }
        if (!this.getMaxMinusMinCompare() && !this.getMaxMinusMinExpr()) {
            this.setMaxMinusMin(false);
        }
        if (!this.getStddevCompare() && !this.getStddevExpr()) {
            this.setStddev(false);
        }
        if (!(this.getMinCompare() || this.getMaxCompare() || this.getMeanCompare() || this.getMaxMinusMinCompare() || this.getStddevCompare() || this.getMinExpr() || this.getMaxExpr() || this.getMeanExpr() || this.getMaxMinusMinExpr() || this.getStddevExpr())) {
            return null;
        }
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name + " ");
        if (PerfReporter.brief) {
            buf.append("\n  " + this.getDescription());
        } else {
            buf.append(this.id + "\n");
            buf.append("filter=" + this.getFilterAsString() + " ");
            buf.append("combine=" + this.getCombineAsString() + " ");
            String o = this.getOpsAsString();
            if (o != null) {
                buf.append("ops=" + o + " ");
            }
            buf.append("trimspec=" + this.trimspecName);
        }
        return buf.toString();
    }

    public String toSpecString() {
        return "statspec " + this.toString() + "\n;";
    }

    private int getFilterFromString(String filterType) {
        if (filterType.equalsIgnoreCase("perSecond")) {
            return 1;
        }
        if (filterType.equalsIgnoreCase("none")) {
            return 0;
        }
        throw new PerfStatException("Illegal filter type: " + filterType);
    }

    private String getFilterAsString() {
        switch (this.filter) {
            case 1: {
                return "perSecond";
            }
            case 0: {
                return "none";
            }
        }
        throw new StatConfigException("Should not happen");
    }

    private int getCombineFromString(String combineType) {
        if (combineType.equalsIgnoreCase("raw")) {
            return 0;
        }
        if (combineType.equalsIgnoreCase("combine")) {
            return 1;
        }
        if (combineType.equalsIgnoreCase("combineAcrossArchives")) {
            return 2;
        }
        throw new PerfStatException("Illegal combine type: " + combineType);
    }

    private String getCombineAsString() {
        switch (this.combine) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "combine";
            }
            case 2: {
                return "combineAcrossArchives";
            }
        }
        throw new StatConfigException("Should not happen");
    }

    String getOpsAsString() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.getMin()) {
            if (this.getMinCompare()) {
                l.add("min?");
            } else if (this.getMinExpr()) {
                l.add("min!");
            } else {
                l.add("min");
            }
        }
        if (this.getMax()) {
            if (this.getMaxCompare()) {
                l.add("max?");
            } else if (this.getMaxExpr()) {
                l.add("max!");
            } else {
                l.add("max");
            }
        }
        if (this.getMaxMinusMin()) {
            if (this.getMaxMinusMinCompare()) {
                l.add("max-min?");
            } else if (this.getMaxMinusMinExpr()) {
                l.add("max-min!");
            } else {
                l.add("max-min");
            }
        }
        if (this.getMean()) {
            if (this.getMeanCompare()) {
                l.add("mean?");
            } else if (this.getMeanExpr()) {
                l.add("mean!");
            } else {
                l.add("mean");
            }
        }
        if (this.getStddev()) {
            if (this.getStddevCompare()) {
                l.add("stddev?");
            } else if (this.getStddevExpr()) {
                l.add("stddev!");
            } else {
                l.add("stddev");
            }
        }
        StringBuffer buf = new StringBuffer();
        if (l.size() > 0) {
            int count = -1;
            for (String op : l) {
                if (++count > 0) {
                    buf.append(",");
                }
                buf.append(op);
            }
            return buf.toString();
        }
        return null;
    }
}

