/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import java.util.List;
import java.util.SortedMap;
import perffmwk.BaseComparison;
import perffmwk.ComparisonConstants;
import perffmwk.PerfStatValue;
import perffmwk.ValueComparator;

public class RatioComparison
extends BaseComparison
implements ComparisonConstants {
    double ratioThreshold;

    RatioComparison(List comparators, double ratioThreshold, boolean markFailedTests) {
        super(comparators, markFailedTests);
        this.ratioThreshold = ratioThreshold;
        this.fillInRows();
    }

    @Override
    protected void fillInRow(String op, String statSpecName) {
        if (this.log.finerEnabled()) {
            this.log.finer("Filling in row for " + statSpecName + " " + op);
        }
        this.statspecColumn.add(statSpecName);
        this.opColumn.add(op);
        double baseVal = -1.0;
        for (int i = 0; i < this.comparators.size(); ++i) {
            Object val;
            ValueComparator comparator = (ValueComparator)this.comparators.get(i);
            if (comparator == null) {
                val = "";
            } else if (this.markFailedTests && (comparator.getTest().getTestResult().equals("H") || comparator.getTest().getTestResult().equals("F"))) {
                val = "xxx";
            } else {
                SortedMap statValues = comparator.getStatValues();
                if (statValues == null) {
                    val = this.markFailedTests ? "xxx" : "";
                } else {
                    List psvs = (List)statValues.get(statSpecName);
                    if (psvs == null) {
                        val = "";
                    } else if (psvs.size() == 0) {
                        val = "";
                    } else if (psvs.size() == 1) {
                        PerfStatValue psv = (PerfStatValue)psvs.get(0);
                        double compareVal = this.getOpValue(op, psv);
                        double ratioVal = this.getRatioValue(baseVal, compareVal, psv.isLargerBetter());
                        val = ratioVal == Double.MAX_VALUE ? "+inf" : (ratioVal == Double.MIN_VALUE ? "-inf" : (Math.abs(ratioVal) < this.ratioThreshold ? "---" : (Math.abs(ratioVal) < 1.01 ? "---" : new Double(ratioVal))));
                        if (baseVal == -1.0) {
                            baseVal = compareVal;
                        }
                    } else {
                        val = "err";
                    }
                }
            }
            this.valColumns[i].add(val);
            if (!this.log.finerEnabled()) continue;
            if (comparator == null) {
                this.log.finer(i + ": has " + statSpecName + " " + op + " " + val);
                continue;
            }
            this.log.finer(i + ": value comparator " + comparator.getIndex() + " at " + comparator.getTest().getTestDir() + " for " + comparator.getTest().getTestId() + " has " + statSpecName + " " + op + " " + val);
        }
    }

    protected double getRatioValue(double baseVal, double compareVal, boolean largerIsBetter) {
        double ratio;
        if (baseVal == -1.0 || baseVal == compareVal) {
            ratio = 1.0;
        } else if (baseVal == 0.0 || compareVal == 0.0) {
            ratio = baseVal == 0.0 && largerIsBetter || compareVal == 0.0 && !largerIsBetter ? Double.MAX_VALUE : Double.MIN_VALUE;
        } else {
            double max = Math.max(baseVal, compareVal);
            double min = Math.min(baseVal, compareVal);
            ratio = max / min;
            double d = ratio = baseVal < compareVal && largerIsBetter || baseVal > compareVal && !largerIsBetter ? ratio : 0.0 - ratio;
        }
        if (this.log.finerEnabled()) {
            this.log.finer("Ratio for base=" + baseVal + " compare=" + compareVal + " " + largerIsBetter + " ==> " + ratio);
        }
        return ratio;
    }
}

