/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import perffmwk.PerfStatException;
import perffmwk.PerfStatMgr;
import perffmwk.TrimSpec;

public class PerformanceStatistics {
    public static final int THREAD_SCOPE = 0;
    public static final int VM_SCOPE = 1;
    private static StatisticsFactory Factory;
    private static Map AllTypes;
    private static Map AllInstances;
    protected Statistics statistics;
    String statisticsInstanceName;
    private Class cls;
    int scope;
    String trimspecName;

    public static synchronized StatisticsFactory factory() {
        if (Factory == null && (Factory = DistributedSystemHelper.getDistributedSystem()) == null) {
            Factory = DistributedSystemHelper.connect();
        }
        return Factory;
    }

    public static PerformanceStatistics getInstance(Class cls, int scope) {
        return PerformanceStatistics.getInstance(cls, scope, null, null);
    }

    public static PerformanceStatistics getInstance(Class cls, int scope, String name) {
        return PerformanceStatistics.getInstance(cls, scope, name, null);
    }

    public static PerformanceStatistics getInstance(Class cls, int scope, String name, String trimspecName) {
        StatisticsType type = PerformanceStatistics.getStatisticsType(cls, scope);
        String instanceName = PerformanceStatistics.instanceNameFor(scope, name);
        return PerformanceStatistics.getInstance(cls, type, scope, instanceName, trimspecName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatisticsType getStatisticsType(Class cls, int scope) {
        Map map = AllTypes;
        synchronized (map) {
            StatisticsType type = (StatisticsType)AllTypes.get(cls.getName());
            if (type == null) {
                Log.getLogWriter().info("Creating statistics type " + cls.getName());
                MethExecutorResult res = MethExecutor.execute(cls.getName(), "getStatisticDescriptors");
                if (res.exceptionOccurred()) {
                    String msg = "Unable to get statistic descriptors for " + cls;
                    throw new PerfStatException(msg, res.getException());
                }
                type = PerformanceStatistics.factory().createType(cls.getName(), "Application statistics with " + PerformanceStatistics.scopeNameFor(scope) + " scope", (StatisticDescriptor[])res.getResult());
                AllTypes.put(cls.getName(), type);
                AllInstances.put(cls.getName(), new HashMap());
                Log.getLogWriter().info("Created statistics type " + cls.getName());
            }
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PerformanceStatistics getInstance(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        HashMap instanceMap;
        HashMap hashMap = instanceMap = (HashMap)AllInstances.get(cls.getName());
        synchronized (hashMap) {
            PerformanceStatistics instance = (PerformanceStatistics)instanceMap.get(instanceName);
            if (instance == null) {
                try {
                    Log.getLogWriter().info("Creating statistics instance named " + instanceName + " of type " + cls.getName());
                    Constructor c = cls.getConstructor(Class.class, StatisticsType.class, Integer.TYPE, String.class, String.class);
                    instance = (PerformanceStatistics)c.newInstance(cls, type, new Integer(scope), instanceName, trimspecName);
                    instanceMap.put(instanceName, instance);
                    Log.getLogWriter().info("Created statistics instance named " + instanceName + " of type " + cls.getName());
                }
                catch (Exception e) {
                    String s = "Unable to create instance of " + cls;
                    throw new PerfStatException(s, e);
                }
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MasterController.sleepForMs(1000);
        HashMap instanceMap = (HashMap)AllInstances.get(this.getClass().getName());
        if (instanceMap != null) {
            HashMap hashMap = instanceMap;
            synchronized (hashMap) {
                PerformanceStatistics instance = (PerformanceStatistics)instanceMap.get(this.statisticsInstanceName);
                if (instance != null) {
                    Log.getLogWriter().info("Closing statistics instance named " + this.statisticsInstanceName + " of type " + this.getClass().getName());
                    instanceMap.remove(this.statisticsInstanceName);
                    instance.statistics().close();
                    Log.getLogWriter().info("Closed statistics instance named " + this.statisticsInstanceName + " of type " + this.getClass().getName());
                }
            }
        }
    }

    public PerformanceStatistics(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        long t;
        this.statisticsInstanceName = instanceName;
        this.cls = cls;
        this.scope = scope;
        this.trimspecName = trimspecName;
        if (this.trimspecName == null) {
            this.trimspecName = TrimSpec.DEFAULT_TRIM_SPEC_NAME;
        }
        long start = System.currentTimeMillis();
        switch (scope) {
            case 0: {
                this.statistics = PerformanceStatistics.factory().createStatistics(type, this.statisticsInstanceName, (long)ProcessMgr.getProcessId());
                break;
            }
            case 1: {
                this.statistics = PerformanceStatistics.factory().createAtomicStatistics(type, this.statisticsInstanceName, (long)ProcessMgr.getProcessId(), 0L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized scope: " + scope);
            }
        }
        if (Log.getLogWriter().fineEnabled()) {
            t = System.currentTimeMillis() - start;
            Log.getLogWriter().fine("Time to create stats " + this.statisticsInstanceName + ", in ms: " + t);
        }
        start = System.currentTimeMillis();
        PerfStatMgr.getInstance().registerStatistics(this);
        if (Log.getLogWriter().fineEnabled()) {
            t = System.currentTimeMillis() - start;
            Log.getLogWriter().fine("Time to register stats " + this.statisticsInstanceName + ", in ms: " + t);
        }
    }

    public String getName() {
        return this.statisticsInstanceName;
    }

    public Statistics statistics() {
        return this.statistics;
    }

    public StatisticDescriptor getStatisticDescriptor(String statName) {
        StatisticDescriptor[] sds = this.statistics.getType().getStatistics();
        for (int i = 0; i < sds.length; ++i) {
            String name = sds[i].getName();
            if (!name.equals(statName)) continue;
            return sds[i];
        }
        throw new PerfStatException("No statistic with name " + statName);
    }

    public String getTrimSpecName() {
        return this.trimspecName;
    }

    private static String instanceNameFor(int scope, String name) {
        switch (scope) {
            case 0: {
                int tid = RemoteTestModule.getCurrentThread().getThreadId();
                return name == null ? "Thread-" + tid : name + "-" + tid;
            }
            case 1: {
                int pid = ProcessMgr.getProcessId();
                return name == null ? "VM-" + pid : name + "-" + pid;
            }
        }
        throw new IllegalArgumentException("Unrecognized scope: " + scope);
    }

    private static String scopeNameFor(int scope) {
        switch (scope) {
            case 0: {
                return "thread";
            }
            case 1: {
                return "VM";
            }
        }
        throw new IllegalArgumentException("Unrecognized scope: " + scope);
    }

    static {
        AllTypes = new HashMap();
        AllInstances = new HashMap();
    }
}

