/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.Log;
import hydra.ProcessMgr;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import perffmwk.ComparisonConstants;
import perffmwk.PerfComparisonException;
import util.TestHelper;

public class PerfFilter
implements ComparisonConstants {
    protected static final String DIVIDER = "================================================================================";
    private static String InputFile;
    private static final String FILTER_REPORT_FILE_PROP = "filterReportFile";
    private static String FilterReportFile;
    private static final String LOG_LEVEL_PROP = "logLevel";
    private static LogWriter log;
    private static final String BASE_COLS_PROP = "baseCols";
    protected static int BaseCols;
    private static final String COMP_COLS_PROP = "compCols";
    protected static int CompCols;
    private static final String RATIO_THRESHOLD_PROP = "ratio.threshold";
    protected static double RatioThreshold;

    private static boolean readParameters(String[] args) {
        StringBuffer configuration = new StringBuffer();
        if (args.length == 0) {
            PerfFilter.usage("No input file specified.");
            return false;
        }
        if (args.length > 1) {
            PerfFilter.usage("Too many input files specified, provide only one.");
            return false;
        }
        InputFile = args[0];
        configuration.append("\nInputFile = " + InputFile);
        String fileName = System.getProperty(FILTER_REPORT_FILE_PROP, InputFile + ".filter");
        FilterReportFile = fileName.equals("none") ? null : FileUtil.absoluteFilenameFor(fileName);
        configuration.append("\nfilterReportFile = " + FilterReportFile);
        BaseCols = Integer.getInteger(BASE_COLS_PROP, (Integer)1);
        configuration.append("\nbaseCols = " + BaseCols);
        CompCols = Integer.getInteger(COMP_COLS_PROP, (Integer)1);
        configuration.append("\ncompCols = " + CompCols);
        String logLevel = System.getProperty(LOG_LEVEL_PROP, "info");
        configuration.append("\nlogLevel = " + logLevel);
        log = FilterReportFile == null ? Log.createLogWriter("perffilter", logLevel) : Log.createLogWriter("perffilter", "perffilter", logLevel, true);
        log.info("PerfFilter PID is " + ProcessMgr.getProcessId());
        try {
            String ratioThreshold = System.getProperty(RATIO_THRESHOLD_PROP, ".05");
            RatioThreshold = Double.parseDouble(ratioThreshold);
            if (RatioThreshold < 0.0) {
                PerfFilter.usage("Illegal ratio.threshold: " + RatioThreshold);
                return false;
            }
        }
        catch (NumberFormatException e) {
            PerfFilter.usage("Illegal ratio.threshold: " + RatioThreshold);
            return false;
        }
        configuration.append("\nratio.threshold = " + RatioThreshold);
        log.info(configuration.toString());
        return true;
    }

    private static void usage(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n** " + s);
        buf.append("\nUsage: java");
        buf.append(" [optional_properties]");
        buf.append(" perffmwk.PerfFilter <file>");
        buf.append("\nwhere optional properties include:");
        buf.append("\n-DbaseCols=<number_of_base_columns(default:1)>");
        buf.append("\n-DcompCols=<number_of_comparison_columnss(default:1)>");
        buf.append("\n-DfilterReportFile=<filter_filename(default:<file>.filter)>");
        buf.append("\n-DlogLevel=<log_level(default:info)>");
        buf.append("\n-Dratio.threshold=<ratio_threshold(default:0.05)>");
        System.out.println(buf.toString());
    }

    private static void filterFile(String infn, String outfn, int basecols, int compcols, double threshold) throws FileNotFoundException, IOException {
        log.info("Filtering ratio comparison file " + infn + " to " + outfn + "...");
        StringWriter headersw = new StringWriter();
        StringWriter resultsw = new StringWriter();
        StringWriter footersw = new StringWriter();
        PrintWriter header = new PrintWriter((Writer)headersw, true);
        PrintWriter result = new PrintWriter((Writer)resultsw, true);
        PrintWriter footer = new PrintWriter((Writer)footersw, true);
        boolean intoTests = false;
        boolean doneTests = false;
        String testName = null;
        List<String> lines = FileUtil.getTextAsList(infn);
        for (String line : lines) {
            if (doneTests) {
                footer.println(line);
                continue;
            }
            if (intoTests) {
                Double val;
                int i;
                if (line.trim().startsWith("AVG ") || line.startsWith("NOTE: ") || line.startsWith(DIVIDER)) {
                    doneTests = true;
                    footer.println(line);
                    continue;
                }
                String[] tokens = line.split(" +");
                ArrayList<Double> vals = new ArrayList<Double>();
                boolean hitbaseline = false;
                for (int i2 = 0; i2 < tokens.length; ++i2) {
                    String token = tokens[i2];
                    if (hitbaseline) {
                        if (token.equals("---")) {
                            vals.add(1.0);
                            continue;
                        }
                        vals.add(Double.valueOf(token));
                        continue;
                    }
                    if (!token.equals("---")) continue;
                    vals.add(1.0);
                    hitbaseline = true;
                }
                if (vals.size() < basecols + compcols) {
                    String s = "basecols(" + basecols + ") + compcols(" + compcols + ") < " + tokens.length + " in \"" + vals + "\"";
                    throw new PerfComparisonException(s);
                }
                if (tokens.length - vals.size() == 3) {
                    testName = tokens[0];
                }
                Double worstbasecol = null;
                Double bestcompcol = null;
                for (i = 0; i < basecols; ++i) {
                    val = (Double)vals.get(i);
                    if (worstbasecol != null && !(val < worstbasecol)) continue;
                    worstbasecol = val;
                }
                for (i = vals.size() - compcols; i < vals.size(); ++i) {
                    val = (Double)vals.get(i);
                    if (bestcompcol != null && !(val > bestcompcol)) continue;
                    bestcompcol = val;
                }
                double delta = Math.abs(Math.abs(bestcompcol) - Math.abs(worstbasecol));
                Log.getLogWriter().info("worstbasecol=" + worstbasecol + " bestcompcol=" + bestcompcol + " delta=" + delta + " threshold=" + threshold);
                if (bestcompcol < worstbasecol && delta > threshold) {
                    result.println(line + " <=== down at least " + (int)(100.0 * delta) + "%");
                    Log.getLogWriter().info(line + " <=== down at least " + (int)delta + "%");
                    continue;
                }
                result.println(line);
                Log.getLogWriter().info(line);
                continue;
            }
            if (line.startsWith("TEST ")) {
                intoTests = true;
                header.println(line);
                continue;
            }
            header.println(line);
        }
        header.flush();
        result.flush();
        footer.flush();
        headersw.flush();
        resultsw.flush();
        footersw.flush();
        FileUtil.writeToFile(outfn, headersw.toString() + resultsw.toString() + footersw.toString());
        log.info("Filtered ratio comparison file " + infn + " to " + outfn);
    }

    public static void main(String[] args) {
        try {
            if (PerfFilter.readParameters(args)) {
                PerfFilter.filterFile(InputFile, FilterReportFile, BaseCols, CompCols, RatioThreshold);
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Throwable t) {
            PerfFilter.logError(TestHelper.getStackTrace(t));
            System.exit(1);
        }
    }

    private static void logError(String msg) {
        if (log == null) {
            System.err.println(msg);
        } else {
            log.severe(msg);
        }
    }
}

