/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.HydraRuntimeException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Vector;

public class Formatter {
    protected static final int WIDTH = 80;
    protected static final String DIVIDER = "================================================================================";
    protected static final String SUBDIVIDER = "--------------------------------------------------------------------------------";

    public static void center(String s, PrintWriter pw) {
        int indent = 40 - s.length() / 2;
        for (int i = 0; i < indent; ++i) {
            pw.print(" ");
        }
        pw.println(s);
    }

    public static Vector formatDecimal(Collection c, String pattern) {
        DecimalFormat f = new DecimalFormat(pattern);
        Vector<String> v = new Vector<String>();
        for (Object o : c) {
            if (o instanceof Double) {
                v.add(f.format(o));
                continue;
            }
            v.add((String)o);
        }
        return v;
    }

    public static Vector padLeft(Collection doubles, String pattern) {
        return Formatter.padLeft(Formatter.formatDecimal(doubles, pattern));
    }

    public static Vector padRight(Collection doubles, String pattern) {
        return Formatter.padRight(Formatter.formatDecimal(doubles, pattern));
    }

    public static Vector padLeft(Collection strings) {
        Vector<String> v = new Vector<String>();
        int length = Formatter.maxLength(strings);
        for (String string : strings) {
            v.add(Formatter.padLeft(string, length));
        }
        return v;
    }

    public static Vector padRight(Collection strings) {
        Vector<String> v = new Vector<String>();
        int length = Formatter.maxLength(strings);
        for (String string : strings) {
            v.add(Formatter.padRight(string, length));
        }
        return v;
    }

    public static String padLeft(String s, int length) {
        if (s.length() > length) {
            throw new HydraRuntimeException(s + " cannot be padded to length " + length + ", it is too long");
        }
        String t = "";
        for (int i = 0; i < length - s.length(); ++i) {
            t = t + " ";
        }
        return t + s;
    }

    public static String padRight(String s, int length) {
        if (s.length() > length) {
            throw new HydraRuntimeException(s + " cannot be padded to length " + length + ", it is too long");
        }
        String t = new String(s);
        for (int i = 0; i < length - s.length(); ++i) {
            t = t + " ";
        }
        return t;
    }

    public static int maxLength(Collection strings) {
        int max = 0;
        for (String string : strings) {
            max = Math.max(max, string.length());
        }
        return max;
    }
}

