/*
 * Decompiled with CFR 0.152.
 */
package pdx.compat;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import diskRecovery.RecoveryPrms;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientVmInfo;
import hydra.DiskStoreHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import parReg.ParRegUtil;
import pdx.PdxBB;
import pdx.PdxPrms;
import pdx.PdxTest;
import util.AdminHelper;
import util.BaseValueHolder;
import util.CacheUtil;
import util.DeclarativeGenerator;
import util.NameFactory;
import util.OperationsClientPrms;
import util.RandomValues;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.VHDataSerializable;
import util.ValueHolder;

public class PdxCompatTest {
    public static PdxCompatTest testInstance = null;
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    private boolean useShutDownAll;
    private static RandomValues randomValues = new RandomValues();
    private List<ClientVmInfo> upVMs = new ArrayList<ClientVmInfo>();
    private List<ClientVmInfo> downVMs = new ArrayList<ClientVmInfo>();
    private int currentControllerStep = 1;
    private static final int controllerStep1 = 1;
    private static final int controllerStep2 = 2;
    private static final int controllerStep3 = 3;
    private static final String xmlFileNameKeyPrefix = "xmlForVmId_";

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new PdxCompatTest();
            testInstance.initializeInstance();
            if (PdxCompatTest.testInstance.isBridgeConfiguration) {
                PdxCompatTest.testInstance.isBridgeClient = true;
                boolean registerInterest = RecoveryPrms.getRegisterInterest();
                if (registerInterest) {
                    PdxCompatTest.registerInterest();
                }
            }
        }
    }

    public static synchronized void HydraTask_initialize() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        if (testInstance == null) {
            testInstance = new PdxCompatTest();
            CacheHelper.createCache("cache1");
            PdxCompatTest.createRegions();
            testInstance.initializeInstance();
            if (PdxCompatTest.testInstance.isBridgeConfiguration) {
                PdxCompatTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initializeWithXml() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        if (testInstance == null) {
            testInstance = new PdxCompatTest();
            PdxCompatTest.createRegionsWithXml();
            testInstance.initializeInstance();
            if (PdxCompatTest.testInstance.isBridgeConfiguration) {
                PdxCompatTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initController() {
        testInstance = new PdxCompatTest();
        PdxCompatTest.testInstance.useShutDownAll = PdxPrms.getShutDownAll();
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        HydraVector regionConfigNames = TestConfig.tab().vecAt(RegionPrms.names);
        this.useShutDownAll = PdxPrms.getShutDownAll();
        this.initPdxDiskStore();
        Log.getLogWriter().info("isBridgeConfiguration is " + this.isBridgeConfiguration);
        Log.getLogWriter().info("useShutDownAll is " + this.useShutDownAll);
    }

    private static void createRegions() {
        boolean createProxyRegions = PdxPrms.getCreateProxyRegions();
        HydraVector regionConfigNamesList = TestConfig.tab().vecAt(RegionPrms.names);
        for (String regionConfigName : regionConfigNamesList) {
            String configNameLC = regionConfigName.toLowerCase();
            boolean isProxyRegion = configNameLC.indexOf("empty") >= 0 || configNameLC.indexOf("accessor") >= 0;
            if (isProxyRegion != createProxyRegions) continue;
            Log.getLogWriter().info("Creating region with config name " + regionConfigName);
            Region aRegion = RegionHelper.createRegion(regionConfigName);
            Log.getLogWriter().info("Done creating region with config name " + regionConfigName + ", region name is " + aRegion.getFullPath());
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    private static void createRegionsWithXml() {
        String bbKey = xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid();
        String xmlFilePath = (String)PdxBB.getBB().getSharedMap().get(bbKey);
        CacheHelper.createCacheFromXml(xmlFilePath);
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static void HydraTask_loadRegions() {
        PdxTest.initClassLoader();
        Set rootRegions = CacheHelper.getCache().rootRegions();
        RandomValues rv = new RandomValues();
        long numToLoadPerRegion = PdxPrms.getNumToLoadPerRegion();
        HashMap<String, BaseValueHolder> putAllMap = new HashMap<String, BaseValueHolder>();
        int putAllMapMaximum = 2000;
        int logIntervalMS = 10000;
        Log.getLogWriter().info("Creating " + numToLoadPerRegion + " entries in each of " + rootRegions.size() + " regions...");
        long loadCoordinator = PdxBB.getBB().getSharedCounters().incrementAndRead(PdxBB.loadCoordinator);
        while (loadCoordinator <= numToLoadPerRegion) {
            String key = NameFactory.getNextPositiveObjectName();
            BaseValueHolder value = PdxCompatTest.getValueForKey(key);
            putAllMap.put(key, value);
            if (putAllMap.size() >= 2000) {
                for (Region aRegion : rootRegions) {
                    Log.getLogWriter().info("Putting(1) " + putAllMap.size() + " entries into " + aRegion.getFullPath());
                    aRegion.putAll(putAllMap);
                }
                putAllMap = new HashMap();
            }
            loadCoordinator = PdxBB.getBB().getSharedCounters().incrementAndRead(PdxBB.loadCoordinator);
        }
        if (putAllMap.size() > 0) {
            for (Region aRegion : rootRegions) {
                Log.getLogWriter().info("Putting(2) " + putAllMap.size() + " entries into " + aRegion.getFullPath());
                aRegion.putAll(putAllMap);
            }
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static void HydraTask_compatWithEnumsController() {
        testInstance.compatWithEnumsController();
    }

    public static void HydraTask_compatController() {
        testInstance.compatController();
    }

    public static synchronized void HydraTask_createXmlFile() {
        String fileName = PdxCompatTest.getXmlFileName(RemoteTestModule.getMyVmid());
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        DeclarativeGenerator.createDeclarativeXml(fileName, CacheHelper.getCache(), false, true);
        PdxBB.getBB().getSharedMap().put(xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid(), aFile.getAbsolutePath());
    }

    public static void HydraTask_printBBMap() {
        PdxBB.getBB().printSharedMap();
    }

    public static void HydraTask_verifyPRs() {
        testInstance.verifyPRs();
    }

    private void compatWithEnumsController() {
        Log.getLogWriter().info("In compatWithEnumsController with controller step " + this.currentControllerStep);
        int secToSleep = 10;
        boolean numToStop = true;
        if (this.currentControllerStep == 1) {
            List allVMs = StopStartVMs.getAllVMs();
            List withFlagVMs = StopStartVMs.getMatchVMs(allVMs, "newVersionWithFlag");
            List withoutFlagVMs = StopStartVMs.getMatchVMs(allVMs, "newVersionWithoutFlag");
            List oldVersionVMs = StopStartVMs.getMatchVMs(allVMs, "oldVersion");
            if (oldVersionVMs.size() != withFlagVMs.size() || oldVersionVMs.size() != withoutFlagVMs.size()) {
                throw new TestException("Test problem; expect the number of oldVersion jvms " + oldVersionVMs.size() + " to be equal to the number of newVersionWithFlag jvms " + withFlagVMs.size() + " and to be equal to the number of newVersionWithoutFlag jvms " + withoutFlagVMs.size());
            }
            List newVersionVMs = StopStartVMs.getMatchVMs(allVMs, "newVersion");
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 0; i < newVersionVMs.size(); ++i) {
                stopModeList.add("nice_exit");
            }
            StopStartVMs.stopVMs(newVersionVMs, stopModeList);
            Log.getLogWriter().info("Sleeping for 10 seconds to allow ops to run...");
            MasterController.sleepForMs(10000);
            ++this.currentControllerStep;
            this.upVMs = oldVersionVMs;
            this.downVMs = withFlagVMs;
        } else if (this.currentControllerStep == 2 || this.currentControllerStep == 3) {
            int numToStopThisTime = Math.min(this.upVMs.size(), 1);
            ArrayList<String> stopModeList = new ArrayList<String>();
            ArrayList<ClientVmInfo> vmsToStop = new ArrayList<ClientVmInfo>();
            ArrayList<ClientVmInfo> vmsToStart = new ArrayList<ClientVmInfo>();
            SharedMap bbMap = PdxBB.getBB().getSharedMap();
            for (int i = 1; i <= numToStopThisTime; ++i) {
                ClientVmInfo stopVmInfo = this.upVMs.remove(0);
                vmsToStop.add(stopVmInfo);
                stopModeList.add("nice_exit");
                ClientVmInfo startVmInfo = this.downVMs.remove(0);
                vmsToStart.add(startVmInfo);
                bbMap.put(xmlFileNameKeyPrefix + startVmInfo.getVmid(), bbMap.get(xmlFileNameKeyPrefix + stopVmInfo.getVmid()));
            }
            PdxBB.getBB().printSharedMap();
            StopStartVMs.stopVMs(vmsToStop, stopModeList);
            StopStartVMs.startVMs(vmsToStart);
            Log.getLogWriter().info("Sleeping for 10 seconds to allow ops to run...");
            MasterController.sleepForMs(10000);
            if (this.useShutDownAll) {
                AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
                PdxBB.getBB().getSharedCounters().increment(PdxBB.shutDownAllInProgress);
                Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS);
                PdxBB.getBB().getSharedCounters().decrement(PdxBB.shutDownAllInProgress);
                List shutDownAllVMs = (List)tmp[0];
                Set shutDownAllResults = (Set)tmp[1];
                List allVMs = StopStartVMs.getAllVMs();
                int expectedNumVMs = StopStartVMs.getMatchVMs(allVMs, "newVersionWithFlag").size();
                if (shutDownAllResults.size() != expectedNumVMs) {
                    throw new TestException("Expected shutDownAllMembers to return " + expectedNumVMs + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
                }
                PdxBB.getBB().getSharedCounters().increment(PdxBB.restartingAfterShutDownAll);
                StopStartVMs.startVMs(shutDownAllVMs);
                PdxBB.getBB().getSharedCounters().decrement(PdxBB.restartingAfterShutDownAll);
            }
            if (this.upVMs.size() == 0) {
                if (this.upVMs.size() != this.downVMs.size()) {
                    throw new TestException("Test problem; expected number of upVMs and number of downVMs to both be 0, num upVMs is " + this.upVMs.size() + ", num downVMs is " + this.downVMs.size());
                }
                ++this.currentControllerStep;
                if (this.currentControllerStep == 3) {
                    List allVMs = StopStartVMs.getAllVMs();
                    this.upVMs = StopStartVMs.getMatchVMs(allVMs, "newVersionWithFlag");
                    this.downVMs = StopStartVMs.getMatchVMs(allVMs, "newVersionWithoutFlag");
                } else if (this.currentControllerStep > 3) {
                    Log.getLogWriter().info("Sleeping for 10 seconds to allow final ops to run...");
                    MasterController.sleepForMs(10000);
                    throw new StopSchedulingOrder("Rolling upgrade has completed");
                }
            }
        }
    }

    private void compatController() {
        Log.getLogWriter().info("In compatController");
        int secToSleep = 10;
        boolean numToStop = true;
        if (this.upVMs.size() == 0) {
            List allVMs = StopStartVMs.getAllVMs();
            List newVersionVMs = StopStartVMs.getMatchVMs(allVMs, "newVersion");
            List oldVersionVMs = StopStartVMs.getMatchVMs(allVMs, "oldVersion");
            if (oldVersionVMs.size() != newVersionVMs.size()) {
                throw new TestException("Test problem; expect the number of oldVersion jvms " + oldVersionVMs.size() + " to be equal to the number of newVersion jvms " + newVersionVMs.size());
            }
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 0; i < newVersionVMs.size(); ++i) {
                stopModeList.add("nice_exit");
            }
            StopStartVMs.stopVMs(newVersionVMs, stopModeList);
            this.upVMs = oldVersionVMs;
            this.downVMs = newVersionVMs;
        }
        Log.getLogWriter().info("Sleeping for 10 seconds to allow ops to run...");
        MasterController.sleepForMs(10000);
        int numToStopThisTime = Math.min(this.upVMs.size(), 1);
        ArrayList<String> stopModeList = new ArrayList<String>();
        ArrayList<ClientVmInfo> vmsToStop = new ArrayList<ClientVmInfo>();
        ArrayList<ClientVmInfo> vmsToStart = new ArrayList<ClientVmInfo>();
        SharedMap bbMap = PdxBB.getBB().getSharedMap();
        for (int i = 1; i <= numToStopThisTime; ++i) {
            ClientVmInfo stopVmInfo = this.upVMs.remove(0);
            vmsToStop.add(stopVmInfo);
            stopModeList.add("nice_exit");
            ClientVmInfo startVmInfo = this.downVMs.remove(0);
            vmsToStart.add(startVmInfo);
            bbMap.put(xmlFileNameKeyPrefix + startVmInfo.getVmid(), bbMap.get(xmlFileNameKeyPrefix + stopVmInfo.getVmid()));
        }
        PdxBB.getBB().printSharedMap();
        StopStartVMs.stopVMs(vmsToStop, stopModeList);
        StopStartVMs.startVMs(vmsToStart);
        Log.getLogWriter().info("Sleeping for 10 seconds to allow ops to run...");
        MasterController.sleepForMs(10000);
        if (this.useShutDownAll) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            PdxBB.getBB().getSharedCounters().increment(PdxBB.shutDownAllInProgress);
            Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS);
            PdxBB.getBB().getSharedCounters().decrement(PdxBB.shutDownAllInProgress);
            List shutDownAllVMs = (List)tmp[0];
            Set shutDownAllResults = (Set)tmp[1];
            List allVMs = StopStartVMs.getAllVMs();
            int expectedNumVMs = StopStartVMs.getMatchVMs(allVMs, "newVersion").size();
            if (shutDownAllResults.size() != expectedNumVMs) {
                throw new TestException("Expected shutDownAllMembers to return " + expectedNumVMs + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
            }
            PdxBB.getBB().getSharedCounters().increment(PdxBB.restartingAfterShutDownAll);
            StopStartVMs.startVMs(shutDownAllVMs);
            PdxBB.getBB().getSharedCounters().decrement(PdxBB.restartingAfterShutDownAll);
        }
        if (this.upVMs.size() == 0) {
            if (this.upVMs.size() != this.downVMs.size()) {
                throw new TestException("Test problem; expected number of upVMs and number of downVMs to both be 0, num upVMs is " + this.upVMs.size() + ", num downVMs is " + this.downVMs.size());
            }
            Log.getLogWriter().info("Sleeping for 10 seconds to allow final ops to run...");
            MasterController.sleepForMs(10000);
            throw new StopSchedulingOrder("Rolling upgrade has completed");
        }
    }

    protected static void registerInterest() {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }

    protected static String getXmlFileName(int vmId) {
        String xmlFileNamePrefix = "vmId_";
        String fileName = "vmId_" + vmId + ".xml";
        return fileName;
    }

    public static BaseValueHolder getValueForKey(Object key) {
        List objectTypes = OperationsClientPrms.getObjectTypes();
        String objType = (String)objectTypes.get(TestConfig.tab().getRandGen().nextInt(0, objectTypes.size() - 1));
        if (objType.equals("util.PdxVersionedValueHolder") || objType.equals("util.VersionedValueHolder")) {
            BaseValueHolder vh = PdxTest.getVersionedValueHolder(objType, (String)key, randomValues);
            return vh;
        }
        if (objType.equals("util.VHDataSerializable")) {
            return new VHDataSerializable((String)key, randomValues);
        }
        if (objType.equals("util.ValueHolder")) {
            return new ValueHolder((String)key, randomValues);
        }
        throw new TestException("Don't know how to handle " + objType);
    }

    private void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    private void verifyPRs() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet regionSet = new HashSet(rootRegions);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        for (Region aRegion : regionSet) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            this.verifyPR(aRegion);
        }
    }

    private void verifyPR(Region aRegion) {
        StringBuffer aStr = new StringBuffer();
        try {
            ParRegUtil.verifyPRMetaData(aRegion);
        }
        catch (Exception e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        catch (TestException e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        int redundantCopies = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
        try {
            ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
        }
        catch (Exception e) {
            aStr.append(e.toString() + "\n");
        }
        try {
            ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
        }
        catch (Exception e) {
            aStr.append(TestHelper.getStackTrace(e) + "\n");
        }
        catch (TestException e) {
            aStr.append(e.toString() + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying PR internal consistency");
    }
}

