/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import parReg.tx.ModResult;
import parReg.tx.ModRoutingObject;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class VerifyCustomPartitioningFunction
extends FunctionAdapter
implements Declarable {
    public void execute(FunctionContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isRegionContext = context instanceof RegionFunctionContext;
        boolean isPartitionedRegionContext = false;
        RegionFunctionContext regionContext = null;
        if (!(context instanceof RegionFunctionContext)) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        regionContext = (RegionFunctionContext)context;
        isPartitionedRegionContext = PartitionRegionHelper.isPartitionedRegion((Region)regionContext.getDataSet());
        if (!isPartitionedRegionContext) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        Log.getLogWriter().info("executing " + ((Object)((Object)this)).getClass().getName() + " in member " + dm + ", invoked from " + context.getArguments().toString() + " with filter " + regionContext.getFilter());
        Region aRegion = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionContext);
        Set keySet = aRegion.keySet();
        int numKeys = keySet.size();
        Log.getLogWriter().info("Region " + aRegion.getName() + " has " + numKeys + " entries");
        int numVms = TestConfig.getInstance().getTotalVMs() - 1;
        for (Object key : keySet) {
            int hash;
            if (key instanceof ModRoutingObject) {
                key = ((ModRoutingObject)key).getKey();
            }
            if (list.contains(hash = (int)NameFactory.getCounterForName(key) % numVms)) continue;
            list.add(hash);
        }
        if (list.size() > 1) {
            String err = "All keys for " + dm + " did not hash to same hashCode.  HashCodes = " + list + "\n" + TestHelper.getStackTrace();
            Log.getLogWriter().info(err);
            throw new TestException(err);
        }
        context.getResultSender().lastResult((Object)new ModResult(dm, numKeys, list));
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public void init(Properties props) {
    }
}

