/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionListener;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import util.OperationsClient;
import util.OperationsClientPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class TxTest
extends OperationsClient {
    protected static TxTest testInstance;
    private ArrayList errorMsgs = new ArrayList();
    private ArrayList errorException = new ArrayList();

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new TxTest();
            testInstance.initializeOperationsClient();
            try {
                testInstance.initializePrms();
                testInstance.initialize();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    protected void initialize() {
        if (CacheHelper.getCache() == null) {
            Cache myCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            TransactionListener listener = PrTxPrms.getTxListener();
            if (listener != null) {
                myCache.getCacheTransactionManager().setListener(listener);
            }
            List regionConfigNames = PrTxPrms.getRegionConfigNames();
            Iterator it = regionConfigNames.iterator();
            while (it.hasNext()) {
                this.createRegion((String)it.next());
            }
        }
    }

    protected void createRegion(String regionConfig) {
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
        String regionName = rd.getRegionName();
        Region aRegion = RegionHelper.createRegion(regionName, factory);
        Log.getLogWriter().info("Created region " + aRegion.getName());
        for (int i = 0; i < 10; ++i) {
            this.addEntry(aRegion);
        }
    }

    protected void initializePrms() {
    }

    public static void HydraTask_doOpsAcrossAllRegions() {
        try {
            testInstance.doOpsAcrossAllRegions();
        }
        catch (Exception e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + e);
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOpsAcrossAllRegions() {
        StringBuffer regionNames = new StringBuffer();
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        if (this.useTransactions) {
            TxHelper.begin();
        }
        Set regions = CacheHelper.getCache().rootRegions();
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            block26: {
                TestHelper.checkForEventError(PrTxBB.getBB());
                Region aRegion = (Region)it.next();
                regionNames.append(aRegion.getName() + " ");
                Log.getLogWriter().info("Executing operation in " + aRegion.getName());
                int whichOp = this.getOperation(OperationsClientPrms.entryOperations);
                int size = aRegion.size();
                if (size >= this.upperThreshold) {
                    whichOp = this.getOperation(OperationsClientPrms.upperThresholdOperations);
                } else if (size <= this.lowerThreshold) {
                    whichOp = this.getOperation(OperationsClientPrms.lowerThresholdOperations);
                }
                String lockName = null;
                boolean gotTheLock = false;
                if (this.lockOperations) {
                    lockName = LOCK_NAME + TestConfig.tab().getRandGen().nextInt(1, 20);
                    Log.getLogWriter().info("Trying to get distributed lock " + lockName + "...");
                    gotTheLock = this.distLockService.lock((Object)lockName, -1L, -1L);
                    if (!gotTheLock) {
                        throw new TestException("Did not get lock " + lockName);
                    }
                    Log.getLogWriter().info("Got distributed lock " + lockName + ": " + gotTheLock);
                }
                try {
                    switch (whichOp) {
                        case 1: {
                            this.addEntry(aRegion);
                            break;
                        }
                        case 3: {
                            this.invalidateEntry(aRegion, false);
                            break;
                        }
                        case 2: {
                            this.destroyEntry(aRegion, false);
                            break;
                        }
                        case 6: {
                            this.updateEntry(aRegion);
                            break;
                        }
                        case 7: {
                            this.getKey(aRegion);
                            break;
                        }
                        case 8: {
                            this.getNewKey(aRegion);
                            break;
                        }
                        case 5: {
                            this.invalidateEntry(aRegion, true);
                            break;
                        }
                        case 4: {
                            this.destroyEntry(aRegion, true);
                            break;
                        }
                        case 12: {
                            this.putAll(aRegion);
                            break;
                        }
                        default: {
                            throw new TestException("Unknown operation " + whichOp);
                        }
                    }
                    if (!gotTheLock) break block26;
                    gotTheLock = false;
                }
                catch (Throwable throwable) {
                    if (gotTheLock) {
                        gotTheLock = false;
                        this.distLockService.unlock(lockName);
                        Log.getLogWriter().info("Released distributed lock " + lockName);
                    }
                    throw throwable;
                }
                this.distLockService.unlock((Object)lockName);
                Log.getLogWriter().info("Released distributed lock " + lockName);
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
        }
        if (this.useTransactions) {
            int n = 0;
            int commitPercentage = OperationsClientPrms.getCommitPercentage();
            n = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
        }
        Log.getLogWriter().info("Done in doEntryOperations with regions " + regionNames.toString());
    }
}

