/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import parReg.tx.KeySetResult;
import util.TestException;

public class GetKeySet
extends FunctionAdapter
implements Declarable {
    public void execute(FunctionContext context) {
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isRegionContext = context instanceof RegionFunctionContext;
        boolean isPartitionedRegionContext = false;
        RegionFunctionContext regionContext = null;
        if (!(context instanceof RegionFunctionContext)) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        regionContext = (RegionFunctionContext)context;
        isPartitionedRegionContext = PartitionRegionHelper.isPartitionedRegion((Region)regionContext.getDataSet());
        if (!isPartitionedRegionContext) {
            throw new TestException("Function requires PartitionedRegionContext!");
        }
        Log.getLogWriter().info("executing " + ((Object)((Object)this)).getClass().getName() + " in member " + dm + ", invoked from " + context.getArguments().toString() + " with filter " + regionContext.getFilter());
        Region aRegion = regionContext.getDataSet();
        Set keySet = aRegion.keySet();
        int numKeys = keySet.size();
        HashSet primaryKeySet = new HashSet();
        for (Object key : keySet) {
            DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, key);
            if (!primary.equals(dm)) continue;
            primaryKeySet.add(key);
        }
        Log.getLogWriter().info("Region " + aRegion.getName() + " has " + numKeys + " entries and " + primaryKeySet.size() + " entries for which it is the primary");
        context.getResultSender().lastResult((Object)new KeySetResult(dm, primaryKeySet));
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }
}

