/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.PartitionDescription;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import parReg.ParRegPrms;
import parReg.tx.GetAllMembersInDS;
import parReg.tx.GetKeySet;
import parReg.tx.KeySetResult;
import parReg.tx.PrTxBB;
import parReg.tx.PrTxPrms;
import parReg.tx.SerializableDistributedMember;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClient;
import util.OperationsClientPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class ColocatedTxTest
extends OperationsClient {
    protected static ColocatedTxTest testInstance;
    static Region baseRegion;
    private ArrayList errorMsgs = new ArrayList();
    private ArrayList errorException = new ArrayList();

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new ColocatedTxTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeServer();
            testInstance.registerFunctions();
        }
    }

    protected void initializeBridgeServer() {
        if (CacheHelper.getCache() == null) {
            this.initialize();
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        }
    }

    public static synchronized void HydraTask_initializeBridgeClient() {
        if (testInstance == null) {
            testInstance = new ColocatedTxTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeClient();
            testInstance.registerFunctions();
        }
    }

    protected void initializeBridgeClient() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                Region aRegion = RegionHelper.createRegion(regionName, aFactory);
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info(aRegion.getName() + ": Registered interest in ALL_KEYS");
            }
        }
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ColocatedTxTest();
            testInstance.initializeOperationsClient();
            try {
                testInstance.initialize();
                testInstance.registerFunctions();
            }
            catch (Exception e) {
                Log.getLogWriter().info("initialize caught Exception " + e + ":" + e.getMessage());
                throw new TestException("initialize caught Exception " + TestHelper.getStackTrace(e));
            }
        }
    }

    protected void initialize() {
        if (CacheHelper.getCache() == null) {
            Cache aCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = PrTxPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region region = RegionHelper.createRegion(regionName, aFactory);
            }
        }
    }

    public static void HydraTask_populateRegions() {
        testInstance.populateRegions();
    }

    protected void populateRegions() {
        Set regions = CacheHelper.getCache().rootRegions();
        Region sampleRegion = (Region)regions.iterator().next();
        int numBuckets = sampleRegion.getAttributes().getPartitionAttributes().getTotalNumBuckets() * TestHelper.getNumVMs() - 1;
        for (int i = 0; i < numBuckets; ++i) {
            String key = NameFactory.getNextPositiveObjectName();
            Set rootRegions = CacheHelper.getCache().rootRegions();
            for (Region aRegion : rootRegions) {
                BaseValueHolder anObj = this.getValueForKey(key);
                Log.getLogWriter().info("populateRegion: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create((Object)key, (Object)anObj);
                Log.getLogWriter().info("populateRegion: done creating key " + key);
            }
        }
    }

    protected void registerFunctions() {
        FunctionAdapter f = new GetAllMembersInDS();
        FunctionService.registerFunction((Function)f);
        f = new GetKeySet();
        FunctionService.registerFunction((Function)f);
        Log.getLogWriter().info("Registered functions: " + FunctionService.getRegisteredFunctions());
    }

    public static void HydraTask_doEntryOperations() {
        try {
            testInstance.doEntryOperations();
        }
        catch (Exception e) {
            Log.getLogWriter().info("doEntryOperations threw Exception " + e);
            throw new TestException("doEntryOperations caught Exception " + TestHelper.getStackTrace(e));
        }
    }

    protected void doEntryOperations() {
        TestHelper.checkForEventError(PrTxBB.getBB());
        Object[] rootRegions = CacheHelper.getCache().rootRegions().toArray();
        int index = TestConfig.tab().getRandGen().nextInt(0, rootRegions.length - 1);
        Region aRegion = (Region)rootRegions[index];
        KeySetResult keySetResult = this.getKeySet(aRegion);
        String mapKey = "keySet_" + RemoteTestModule.getCurrentThread().getThreadId();
        PrTxBB.getBB().getSharedMap().put(mapKey, keySetResult);
        DistributedMember keySetDM = keySetResult.getDistributedMember();
        List keyList = keySetResult.getKeySet();
        Object[] keySet = keyList.toArray();
        Log.getLogWriter().info("KeySet for " + keySetDM + "  = " + keyList);
        if (PrTxPrms.sameKeyColocatedRegions()) {
            Log.getLogWriter().info("Executing ops with single key across colocatedRegions");
            this.doEntryOperations(keySet);
        } else {
            Log.getLogWriter().info("Executing ops with keySet on Region");
            this.doEntryOperations(aRegion);
        }
    }

    protected KeySetResult getKeySet(Region aRegion) {
        KeySetResult ksResult2 = null;
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        boolean useLocalKeySet = PrTxPrms.useLocalKeySet();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetKeySet");
        Execution e = FunctionService.onRegion((Region)aRegion).withArgs((Object)dm.toString());
        Log.getLogWriter().info("executing " + f.getId() + " on region " + aRegion.getName());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        DistributedMember remoteDM = null;
        boolean keySetAvailable = false;
        for (KeySetResult ksResult2 : results) {
            remoteDM = ksResult2.getDistributedMember();
            if (useLocalKeySet) {
                if (!dm.equals(remoteDM)) continue;
                keySetAvailable = true;
                Log.getLogWriter().info("Returning keySet for local dataStore");
                break;
            }
            if (dm.equals(remoteDM)) continue;
            keySetAvailable = true;
            Log.getLogWriter().info("Returning keySet for remote dataStore");
            break;
        }
        if (!keySetAvailable) {
            ksResult2 = null;
            throw new TestException("Test issue with getNewKey -- no keySet found");
        }
        Log.getLogWriter().info("Returning keySet from member " + remoteDM);
        return ksResult2;
    }

    protected List executeGetAllMembersInDS() {
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        DistributedMember dm = ds.getDistributedMember();
        Function f = FunctionService.getFunction((String)"parReg.tx.GetAllMembersInDS");
        Execution e = FunctionService.onMembers((DistributedSystem)ds).withArgs((Object)dm.toString());
        Log.getLogWriter().info("executing " + f.getId());
        ResultCollector rc = e.execute(f);
        Log.getLogWriter().info("executed " + f.getId());
        List results = (List)rc.getResult();
        Log.getLogWriter().info("ResultCollector.getResult() = " + results);
        StringBuffer s = new StringBuffer();
        s.append("ResultCollector : \n");
        ArrayList<DistributedMember> dmList = new ArrayList<DistributedMember>();
        for (SerializableDistributedMember sdm : results) {
            s.append("   " + sdm.toString() + "\n");
            dmList.add(sdm.getDistributedMember());
        }
        Log.getLogWriter().info(s.toString());
        return dmList;
    }

    @Override
    protected void addEntry(Region aRegion) {
        Object key = this.getNewKeyForRegion(aRegion);
        BaseValueHolder anObj = this.getValueForKey(key);
        Object callback = this.getCallback(key, "Create event originated in pid ", ProcessMgr.getProcessId());
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.create(key, (Object)anObj, callback);
            Log.getLogWriter().info("addEntry: done creating key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
    }

    protected void putIfAbsent(Region aRegion) {
        this.putIfAbsent(aRegion, true);
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Object key = this.getNewKeyForRegion(aRegion);
        BaseValueHolder anObj = this.getValueForKey(key);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
        }
        aRegion.putIfAbsent(key, (Object)anObj);
        Log.getLogWriter().info("putIfAbsent: done creating key " + key);
    }

    @Override
    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Object callback = this.getCallback(key, "Invalidate event originated in pid ", ProcessMgr.getProcessId());
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                aRegion.localInvalidate(key, callback);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Object callback = this.getCallback(key, "Destroy event originated in pid ", ProcessMgr.getProcessId());
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                aRegion.localDestroy(key, callback);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void remove(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            Log.getLogWriter().info("remove: removing key " + key);
            aRegion.remove(key, aRegion.get(key));
            Log.getLogWriter().info("remove: done removing key " + key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        BaseValueHolder anObj = null;
        anObj = this.getUpdateObject(aRegion, (String)key);
        Object callback = this.getCallback(key, "Update event originated in pid ", ProcessMgr.getProcessId());
        Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
        aRegion.put(key, (Object)anObj, callback);
        Log.getLogWriter().info("Done with call to put (update)");
    }

    @Override
    protected void replace(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        BaseValueHolder anObj = null;
        anObj = this.getUpdateObject(aRegion, (String)key);
        BaseValueHolder oldValue = (BaseValueHolder)aRegion.get(key);
        Log.getLogWriter().info("replace: replacing key " + key + " value " + TestHelper.toString(oldValue) + " with " + TestHelper.toString(anObj));
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            aRegion.replace(key, (Object)oldValue, (Object)anObj);
        } else {
            aRegion.replace(key, (Object)anObj);
        }
        Log.getLogWriter().info("Done with call to replace");
    }

    @Override
    protected void getKey(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        Object callback = this.getCallback(key, "Get originated in pid ", ProcessMgr.getProcessId());
        Object anObj = null;
        Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
        anObj = aRegion.get(key, callback);
        Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
    }

    @Override
    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKeyForRegion(aRegion);
        Object callback = this.getCallback(key, "Get originated in pid ", ProcessMgr.getProcessId());
        Object anObj = null;
        Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
        anObj = aRegion.get(key, callback);
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    private Object getCallback(Object key, String prefix, int pid) {
        String sCallback = prefix + pid;
        return sCallback;
    }

    @Override
    protected List getExistingKeys(Region aRegion, int numKeysToGet) {
        Log.getLogWriter().info("Trying to get " + numKeysToGet + " existing keys...");
        String mapKey = "keySet_" + RemoteTestModule.getCurrentThread().getThreadId();
        KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
        DistributedMember keySetDM = keySetResult.getDistributedMember();
        List aList = keySetResult.getKeySet();
        Object[] keySet = aList.toArray();
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = 0; i < keySet.length; ++i) {
            keyList.add(keySet[i]);
            if (keyList.size() >= numKeysToGet) break;
        }
        return keyList;
    }

    @Override
    protected Object getExistingKey(Region aRegion) {
        Object key = null;
        String mapKey = "keySet_" + RemoteTestModule.getCurrentThread().getThreadId();
        KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
        DistributedMember keySetDM = keySetResult.getDistributedMember();
        List keyList = keySetResult.getKeySet();
        Object[] keySet = keyList.toArray();
        int index = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
        key = keySet[index];
        return key;
    }

    protected Object getNewKeyForRegion(Region aRegion) {
        String key = null;
        String mapKey = "keySet_" + RemoteTestModule.getCurrentThread().getThreadId();
        KeySetResult keySetResult = (KeySetResult)PrTxBB.getBB().getSharedMap().get(mapKey);
        DistributedMember keySetDM = keySetResult.getDistributedMember();
        DistributedMember dm = null;
        do {
            key = NameFactory.getNextPositiveObjectName();
            dm = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)key);
            while (dm == null) {
                key = NameFactory.getNextPositiveObjectName();
                dm = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)key);
            }
            Log.getLogWriter().info("Looking for a new key from " + keySetDM + ".  Found " + key + " from " + dm);
        } while (!dm.equals(keySetDM));
        Log.getLogWriter().info("getNewKey() returning key " + key + " for member " + keySetDM);
        return key;
    }

    @Override
    protected void putAll(Region r) {
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = this.upperThreshold - beforeSize;
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKeyForRegion(r);
            BaseValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        List keyList = this.getExistingKeys(r, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                BaseValueHolder anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected void putAll(Region r, Object[] keySet) {
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = this.upperThreshold - beforeSize;
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKeyForRegion(r);
            BaseValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        List keyList = this.getExistingKeys(r, keySet, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                BaseValueHolder anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected List getExistingKeys(Region aRegion, Object[] keySet, int numKeysToGet) {
        ArrayList<Object> keyList = new ArrayList<Object>();
        for (int i = 0; i < keySet.length; ++i) {
            keyList.add(keySet[i]);
            if (keyList.size() < numKeysToGet) continue;
            return keyList;
        }
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEntryOperations(Object[] keySet) {
        int index = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
        Object key = keySet[index];
        Log.getLogWriter().info("doEntryOperations on single key = " + key);
        if (this.useTransactions) {
            TxHelper.begin();
        }
        Set regions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : regions) {
            Log.getLogWriter().info("Executing operation on " + aRegion.getName() + " with key = " + key);
            int whichOp = this.getOperation(OperationsClientPrms.entryOperations);
            int size = keySet.length;
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(OperationsClientPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(OperationsClientPrms.lowerThresholdOperations);
            }
            String lockName = null;
            boolean gotTheLock = false;
            if (this.lockOperations) {
                lockName = LOCK_NAME + TestConfig.tab().getRandGen().nextInt(1, 20);
                Log.getLogWriter().info("Trying to get distributed lock " + lockName + "...");
                gotTheLock = this.distLockService.lock((Object)lockName, -1L, -1L);
                if (!gotTheLock) {
                    throw new TestException("Did not get lock " + lockName);
                }
                Log.getLogWriter().info("Got distributed lock " + lockName + ": " + gotTheLock);
            }
            try {
                switch (whichOp) {
                    case 1: {
                        this.addEntry(aRegion);
                        break;
                    }
                    case 9: {
                        this.putIfAbsent(aRegion);
                        break;
                    }
                    case 3: {
                        this.invalidateEntry(aRegion, key, false);
                        break;
                    }
                    case 2: {
                        this.destroyEntry(aRegion, key, false);
                        break;
                    }
                    case 10: {
                        this.removeEntry(aRegion, key);
                        break;
                    }
                    case 6: {
                        this.updateEntry(aRegion, key);
                        break;
                    }
                    case 11: {
                        this.replaceEntry(aRegion, key);
                        break;
                    }
                    case 7: {
                        this.getKey(aRegion, key);
                        break;
                    }
                    case 8: {
                        this.getNewKey(aRegion);
                        break;
                    }
                    case 5: {
                        this.invalidateEntry(aRegion, key, true);
                        break;
                    }
                    case 4: {
                        this.destroyEntry(aRegion, key, true);
                        break;
                    }
                    case 12: {
                        this.putAll(aRegion, keySet);
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
                if (!gotTheLock) continue;
                gotTheLock = false;
            }
            catch (Throwable throwable) {
                if (gotTheLock) {
                    gotTheLock = false;
                    this.distLockService.unlock(lockName);
                    Log.getLogWriter().info("Released distributed lock " + lockName);
                }
                throw throwable;
            }
            this.distLockService.unlock((Object)lockName);
            Log.getLogWriter().info("Released distributed lock " + lockName);
        }
        if (this.useTransactions) {
            int n = 0;
            int commitPercentage = OperationsClientPrms.getCommitPercentage();
            n = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
        }
        Log.getLogWriter().info("Done in doEntryOperations with key " + key);
    }

    protected void invalidateEntry(Region aRegion, Object key, boolean isLocalInvalidate) {
        try {
            String callback = "Invalidate event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion, Object key, boolean isLocalDestroy) {
        try {
            String callback = "Destroy event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void removeEntry(Region aRegion, Object key) {
        try {
            Object oldValue = aRegion.get(key);
            Log.getLogWriter().info("removeEntry: removing key " + key + " with previous value " + oldValue);
            aRegion.remove(key, oldValue);
            Log.getLogWriter().info("removeEntry: done removing key " + key);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aRegion, Object key) {
        BaseValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("Done with call to put (update)");
        }
    }

    protected void replaceEntry(Region aRegion, Object key) {
        BaseValueHolder anObj = this.getUpdateObject(aRegion, (String)key);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            BaseValueHolder oldValue = (BaseValueHolder)aRegion.get(key);
            Log.getLogWriter().info("replaceEntry: replacing key " + key + " value " + TestHelper.toString(oldValue) + " with " + TestHelper.toString(anObj));
            aRegion.replace(key, (Object)oldValue, (Object)anObj);
        } else {
            Log.getLogWriter().info("replaceEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.replace(key, (Object)anObj);
        }
        Log.getLogWriter().info("Done with call to replace");
    }

    protected void getKey(Region aRegion, Object key) {
        String callback = "Get originated in pid " + ProcessMgr.getProcessId();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        } else {
            Log.getLogWriter().info("getKey: getting key " + key);
            anObj = aRegion.get(key);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        }
    }
}

