/*
 * Decompiled with CFR 0.152.
 */
package parReg.query;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxInstance;
import event.EventBB;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import parReg.query.NewPortfolio;
import parReg.query.ParRegQueryBB;
import parReg.query.Position;
import parReg.query.index.IndexTest;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import query.QueryBB;
import query.QueryPrms;
import query.QueryTest;
import query.QueryValidator;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.NameFactory;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class SerialQueryAndEntryOpsTest
extends QueryTest {
    protected int numOfInitObjects = 30;
    protected int maxId = 100;
    protected int numOfQueryStrings = 9;
    protected static int totalNumOfVmsToStop;
    protected static boolean serialExecution;

    public static synchronized void HydraTask_initialize() {
        PRObserver.installObserverHook();
        PRObserver.initialize(RemoteTestModule.getMyVmid());
        if (queryTest == null) {
            queryTest = new SerialQueryAndEntryOpsTest();
            queryTest.initialize();
        }
        ParRegQueryBB.getBB().getSharedCounters().zero(ParRegQueryBB.operationCount);
        ParRegQueryBB.getBB().getSharedCounters().zero(ParRegQueryBB.stopStartVmsCounter);
        ParRegQueryBB.getBB().getSharedCounters().zero(ParRegQueryBB.stopStartSignal);
        ParRegQueryBB.getBB().getSharedCounters().zero(ParRegQueryBB.queryCount);
        totalNumOfVmsToStop = TestConfig.tab().intAt(QueryPrms.totalNumOfVmsToStop, 0);
        serialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, true);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public static void HydraTask_logRegions() {
        PdxTest.initClassLoader();
        Cache aCache = CacheFactory.getAnyInstance();
        Set regions = aCache.rootRegions();
        for (Region aRegion : regions) {
            Log.getLogWriter().info(aRegion.getFullPath() + " is size " + aRegion.size());
            int activeCount = 0;
            int inactiveCount = 0;
            int neitherCount = 0;
            Log.getLogWriter().info("Looking for status");
            for (Object key : aRegion.keySet()) {
                Object value = aRegion.get(key);
                if (value instanceof PdxInstance) {
                    value = PdxTestVersionHelper.toBaseObject(value);
                }
                NewPortfolio pf = (NewPortfolio)value;
                if (pf.status.equals("active")) {
                    ++activeCount;
                    continue;
                }
                if (pf.status.equals("inactive")) {
                    ++inactiveCount;
                    continue;
                }
                Log.getLogWriter().info("neither: " + pf);
                ++neitherCount;
            }
            Log.getLogWriter().info("For region" + aRegion.getFullPath() + " activeCount is " + activeCount + ", inactiveCount is " + inactiveCount + ", neitherCount is " + neitherCount);
        }
    }

    public static synchronized void HydraTask_reInitialize() {
        if (queryTest == null) {
            queryTest = new SerialQueryAndEntryOpsTest();
            queryTest.initialize();
        }
    }

    public static void HydraTask_populateRegion() {
        PdxTest.initClassLoader();
        ((SerialQueryAndEntryOpsTest)queryTest).populateRegion();
    }

    public static synchronized void HydraTask_doStopStartVmAndQueryOperation() {
        PdxTest.initClassLoader();
        ((SerialQueryAndEntryOpsTest)queryTest).doStopStartVmAndQueryOperation();
    }

    public static void HydraTask_validateCountStar() throws Throwable {
        new QueryTest().verifyCountQueryResults();
    }

    protected void populateRegion() {
        int i;
        for (i = 0; i < this.numOfRegions; ++i) {
            Region aRegion = CacheHelper.getCache().getRegion("QueryRegion" + "" + i);
            this.populateRegion(aRegion);
        }
        if (i == this.numOfRegions) {
            Log.getLogWriter().info("finishing populating region, sleep for 30 sec");
            MasterController.sleepForMs(30000);
        }
    }

    protected void populateRegion(Region aRegion) {
        for (int i = 1; i <= this.numOfInitObjects; ++i) {
            this.addObject(aRegion, true, false);
        }
    }

    public static synchronized void HydraTask_createIndex() {
        if (queryTest == null) {
            queryTest = new SerialQueryAndEntryOpsTest();
        }
        ((SerialQueryAndEntryOpsTest)queryTest).createAllIndex();
    }

    @Override
    protected void doEntryAndQueryOperations() {
        block3: {
            SharedCounters counters = ParRegQueryBB.getBB().getSharedCounters();
            counters.increment(ParRegQueryBB.operationCount);
            try {
                super.doEntryAndQueryOperations();
            }
            catch (CancelException e) {
                if (counters.incrementAndRead(ParRegQueryBB.stopStartSignal) != 1L) break block3;
                if (StopStartVMs.niceKillInProgress()) {
                    Log.getLogWriter().info("Caught CancelException -- expected in concurrent tests with stop start vm, continuing ... " + (Object)((Object)e));
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    protected void doStopStartVmAndQueryOperation() {
        SharedCounters counters = ParRegQueryBB.getBB().getSharedCounters();
        if (serialExecution && counters.read(ParRegQueryBB.stopStartVmsCounter) < (long)totalNumOfVmsToStop) {
            if (counters.read(ParRegQueryBB.operationCount) < 7L) {
                return;
            }
            StopStartVMs.stopStartOtherVMs(2);
            counters.increment(ParRegQueryBB.stopStartVmsCounter);
            counters.zero(ParRegQueryBB.operationCount);
            Log.getLogWriter().info("Successfully recycled vm");
            this.doEntryAndQueryOperations();
        } else if (!serialExecution && counters.read(ParRegQueryBB.queryCount) > 7L && counters.incrementAndRead(ParRegQueryBB.stopStartSignal) == 1L) {
            List<ClientVmInfo> vms = this.stopStartVMs(1);
            PRObserver.waitForRebalRecov(vms, 1, this.numOfRegions, null, null, false);
            counters.zero(ParRegQueryBB.queryCount);
            counters.zero(ParRegQueryBB.stopStartSignal);
            this.doQuery(false);
        }
    }

    private List<ClientVmInfo> stopStartVMs(int numToTarget) {
        Object[] tmpArr = StopStartVMs.getOtherVMsWithExclude(numToTarget, "locator");
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(vmList, stopModeList);
        return vmList;
    }

    protected void createAllIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        if (!objectType.equals("parReg.query.NewPortfolio")) {
            return;
        }
        IndexTest indexTest = new IndexTest();
        for (int i = 0; i < this.numOfRegions; ++i) {
            indexTest.createIndex("QueryRegion" + "" + i);
        }
    }

    @Override
    protected void createIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        if (!objectType.equals("parReg.query.NewPortfolio")) {
            return;
        }
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.createIndex("QueryRegion" + "" + regionNumber);
    }

    @Override
    protected void removeIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        if (!objectType.equals("parReg.query.NewPortfolio")) {
            return;
        }
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.removeIndex("QueryRegion" + "" + regionNumber);
    }

    @Override
    protected int getNumVMsWithListeners() {
        return TestHelper.getNumVMs();
    }

    @Override
    protected void addObject(Region aRegion, boolean logAddition) {
        this.addObject(aRegion, logAddition, true);
    }

    protected void addObject(Region aRegion, boolean logAddition, boolean verifyQuery) {
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        String callback = "Create event originated in pid " + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
            Log.getLogWriter().info("Object " + ((NewPortfolio)anObj).getName() + " in " + aRegion.getFullPath() + " is " + ((NewPortfolio)anObj).getStatus());
            String key = aRegion.getName() + name;
            ParRegQueryBB.putToSharedMap(key, anObj);
            QueryBB.putQueryValidator(new QueryValidator("add", name, true, true, anObj));
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
        if (verifyQuery) {
            this.validateQuery(aRegion);
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object name = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get name from region");
            return;
        }
        name = it.next();
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = "Invalidate event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    EventBB.incrementCounter("EventBB.NUM_LOCAL_INVALIDATE", EventBB.NUM_LOCAL_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("localInvalidate", name, true, false, null));
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                String key = aRegion.getName() + name;
                ParRegQueryBB.getBB().getSharedMap().put(key, null);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    EventBB.incrementCounter("EventBB.NUM_INVALIDATE", EventBB.NUM_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("invalidate", name, true, false, null));
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        this.validateQuery(aRegion);
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keySet();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        this.validateQuery(aRegion);
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        try {
            String callback = "Destroy event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                EventBB.incrementCounter("EventBB.NUM_LOCAL_DESTROY", EventBB.NUM_LOCAL_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("localDestroy", name, false, false, null));
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                String key = aRegion.getName() + name;
                ParRegQueryBB.getBB().getSharedMap().remove(key);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("destroy", name, false, false, null));
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keySet();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = iter.next();
        this.updateObject(aRegion, name);
        this.validateQuery(aRegion);
    }

    @Override
    protected void updateObject(Region aRegion, Object name) {
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            String key = aRegion.getName() + name;
            ParRegQueryBB.putToSharedMap(key, newObj);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        QueryBB.putQueryValidator(new QueryValidator("update", name, true, true, newObj));
        EventBB.incrementCounter("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE);
    }

    @Override
    protected void readObject(Region aRegion) {
        super.updateObject(aRegion);
        this.validateQuery(aRegion);
    }

    @Override
    protected Object getObjectToAdd(String name) {
        boolean useRandomValues = false;
        useRandomValues = TestConfig.tab().booleanAt(QueryPrms.useRandomValues, false);
        if (useRandomValues) {
            ValueHolder anObj = new ValueHolder(name, this.randomValues);
            return anObj;
        }
        long i = NameFactory.getPositiveNameCounter();
        int index = (int)(i % (long)this.maxId);
        String className = TestConfig.tab().stringAt(QueryPrms.objectType);
        NewPortfolio val = null;
        if (className.equals(NewPortfolio.class.getName())) {
            val = new NewPortfolio(name, index);
        } else if (className.equals("parReg.query.PdxVersionedNewPortfolio") || className.equals("parReg.query.VersionedNewPortfolio")) {
            val = PdxTest.getVersionedNewPortfolio(className, name, index);
        } else {
            throw new TestException("Unknown objectType " + className);
        }
        Log.getLogWriter().info("set portfolio done");
        return val;
    }

    @Override
    protected Object getUpdateObject(String name) {
        return this.getObjectToAdd(name);
    }

    protected void validateQuery(Region aRegion) {
        for (int i = 0; i < this.numOfQueryStrings; ++i) {
            this.validateQuery(aRegion, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateQuery(Region aRegion, int i) {
        NewPortfolio aPF;
        String key;
        Object result;
        Log.getLogWriter().info("Performing the query validation check");
        String regionName = aRegion.getName();
        Log.getLogWriter().info("Region name is : " + regionName);
        String region1 = this.randRgn();
        try {
            Cache aCache;
            String[] queries = new String[]{"select distinct * from " + aRegion.getFullPath() + " where status = 'active'", "select distinct * from " + aRegion.getFullPath() + " where NOT (id <= 5 AND status <> 'active')", "select distinct * from " + aRegion.getFullPath() + " p where p.id IN (select distinct np.id from " + region1 + " np where np.status = 'active')", "import parReg.\"query\".Position; select distinct r from " + aRegion.getFullPath() + " r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "select distinct status from " + aRegion.getFullPath() + " where id > 5 AND status = 'active'", "select distinct status, name from " + aRegion.getFullPath() + " where \"type\" = 'type1'", "import parReg.\"query\".Position; select distinct r.name, pVal, r.status from " + aRegion.getFullPath() + " r , r.positions.values pVal TYPE Position where r.\"type\" = 'type1' AND pVal.mktValue >= 25.00 AND pVal.qty > 500", "import parReg.\"query\".Position; select distinct r.name, pVal, r.status from " + aRegion.getFullPath() + " r , r.positions.values pVal TYPE Position ", "import parReg.\"query\".Position; select distinct r.name, pVal, r.\"type\" from " + aRegion.getFullPath() + " r , r.positions.values pVal TYPE Position where pVal.mktValue >=1.00 AND (r.name='Object_11' OR r.name='Object_12')"};
            if (this.queryLimit != -1) {
                int q = 0;
                while (q < queries.length) {
                    int n = q++;
                    queries[n] = queries[n] + " limit " + this.queryLimit;
                }
            }
            if ((aCache = CacheHelper.getCache()) == null) {
                return;
            }
            Query query = aCache.getQueryService().newQuery(queries[i]);
            Log.getLogWriter().info("query with index " + i + " " + query.toString());
            ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
            if (pdxReadSerialized) {
                Log.getLogWriter().info("Setting class loader to remove domain classes in preparation of a query execute: " + origClassLoader.get());
                Thread.currentThread().setContextClassLoader((ClassLoader)origClassLoader.get());
            }
            try {
                Cache theCache = CacheHelper.getCache();
                if (theCache != null) {
                    Log.getLogWriter().info("Clearing the pdx registry with a test hook");
                    ((GemFireCacheImpl)theCache).getPdxRegistry().flushCache();
                }
                Log.getLogWriter().info("Executing query " + queries[i]);
                result = query.execute();
                Log.getLogWriter().info("Done executing query " + queries[i]);
            }
            finally {
                if (pdxReadSerialized) {
                    Log.getLogWriter().info("Setting class loader back to one that refers to domain classes: " + previousCL);
                    Thread.currentThread().setContextClassLoader(previousCL);
                }
            }
            this.validateQueryLimit(result);
        }
        catch (QueryInvocationTargetException ite) {
            if (ite.toString().indexOf("Unable to retrieve") >= 0) {
                throw new TestException(TestHelper.getStackTrace(ite));
            }
            if (QueryPrms.allowQueryInvocationTargetException()) {
                Log.getLogWriter().warning("Caught " + (Object)((Object)ite) + " (expected with concurrent execution); continuing with test", ite.getRootCause());
                return;
            }
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(ite));
        }
        catch (UnsupportedOperationException e) {
            Log.getLogWriter().info("Multiple region reference is not supported, continuing test");
            return;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query validation. " + TestHelper.getStackTrace(e));
        }
        Set dataFromBB = ParRegQueryBB.getBB().getSharedMap().getMap().entrySet();
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator itr = dataFromBB.iterator();
        if (i == 0) {
            while (itr.hasNext()) {
                Map.Entry m = itr.next();
                key = (String)m.getKey();
                Object val = ParRegQueryBB.getFromSharedMap(key);
                aPF = (NewPortfolio)val;
                if (!key.startsWith(regionName + "Object") || !aPF.getStatus().equals("active")) continue;
                key = aPF.getName();
                data.put(key, aPF);
            }
        } else if (i == 1) {
            while (itr.hasNext()) {
                Map.Entry m = itr.next();
                key = (String)m.getKey();
                Object val = ParRegQueryBB.getFromSharedMap(key);
                aPF = (NewPortfolio)val;
                if (!key.startsWith(regionName + "Object") || aPF.getId() <= 5 && !aPF.getStatus().equals("active")) continue;
                key = aPF.getName();
                data.put(key, aPF);
            }
        } else {
            if (i == 2) {
                return;
            }
            if (i == 3) {
                block11: while (itr.hasNext()) {
                    Map.Entry m = itr.next();
                    key = (String)m.getKey();
                    Object val = ParRegQueryBB.getFromSharedMap(key);
                    aPF = (NewPortfolio)val;
                    if (!key.startsWith(regionName + "Object") || !aPF.getStatus().equals("active")) continue;
                    Map aMap = aPF.getPositions();
                    Set aSet = aMap.entrySet();
                    for (Map.Entry posEntry : aSet) {
                        Position aPos = (Position)posEntry.getValue();
                        if (!(aPos.getMktValue() >= 25.0)) continue;
                        key = aPF.getName();
                        data.put(key, aPF);
                        continue block11;
                    }
                }
            } else {
                if (i == 4) {
                    if (((SelectResults)result).size() > 1) {
                        Log.getLogWriter().severe("result isa " + result.getClass());
                        itr = ((SelectResults)result).iterator();
                        int counter = 0;
                        while (itr.hasNext()) {
                            ++counter;
                            String status = (String)itr.next();
                            Log.getLogWriter().info("query number 5, from result, status is " + status);
                        }
                        Log.getLogWriter().info("query number 5, total from query results is " + counter);
                        throw new TestException("query number 5: distinct value should eliminate duplicates");
                    }
                    return;
                }
                if (i == 5) {
                    ObjectTypeImpl oType = new ObjectTypeImpl(String.class);
                    ObjectType[] oTypes = new ObjectType[]{oType, oType};
                    String[] fieldNames = new String[]{"status", "name"};
                    StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
                    while (itr.hasNext()) {
                        Map.Entry m = (Map.Entry)itr.next();
                        key = (String)m.getKey();
                        Object val = ParRegQueryBB.getFromSharedMap(key);
                        aPF = (NewPortfolio)val;
                        if (!key.startsWith(regionName + "Object") || !aPF.getType().equals("type1")) continue;
                        key = aPF.getName();
                        Object[] objects = new Object[]{aPF.getStatus(), aPF.getName()};
                        StructImpl aStruct = new StructImpl(sType, objects);
                        data.put(key, aStruct);
                    }
                    this.verifyStruct(data, result, i);
                    return;
                }
                if (i == 6) {
                    ObjectTypeImpl oType = new ObjectTypeImpl(String.class);
                    ObjectTypeImpl oType1 = new ObjectTypeImpl(Position.class);
                    ObjectType[] oTypes = new ObjectType[]{oType, oType1, oType};
                    String[] fieldNames = new String[]{"name", "pVal", "status"};
                    StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
                    while (itr.hasNext()) {
                        Map.Entry m = (Map.Entry)itr.next();
                        key = (String)m.getKey();
                        Object val = ParRegQueryBB.getFromSharedMap(key);
                        aPF = (NewPortfolio)val;
                        if (!key.startsWith(regionName + "Object") || !aPF.getType().equals("type1")) continue;
                        Map aMap = aPF.getPositions();
                        Set aSet = aMap.entrySet();
                        for (Map.Entry posEntry : aSet) {
                            Position aPos = (Position)posEntry.getValue();
                            if (!(aPos.getMktValue() >= 25.0) || !(aPos.getQty() > 500.0)) continue;
                            key = NameFactory.getNextPositiveObjectName();
                            Object[] objects = new Object[]{aPF.getName(), aPos, aPF.getStatus()};
                            StructImpl aStruct = new StructImpl(sType, objects);
                            data.put(key, aStruct);
                        }
                    }
                    this.verifyStruct(data, result, i);
                    return;
                }
                if (i == 7) {
                    ObjectTypeImpl oType = new ObjectTypeImpl(String.class);
                    ObjectTypeImpl oType1 = new ObjectTypeImpl(Position.class);
                    ObjectType[] oTypes = new ObjectType[]{oType, oType1, oType};
                    String[] fieldNames = new String[]{"name", "pVal", "status"};
                    StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
                    while (itr.hasNext()) {
                        Map.Entry m = (Map.Entry)itr.next();
                        key = (String)m.getKey();
                        Object val = ParRegQueryBB.getFromSharedMap(key);
                        aPF = (NewPortfolio)val;
                        if (!key.startsWith(regionName + "Object")) continue;
                        Map aMap = aPF.getPositions();
                        Set aSet = aMap.entrySet();
                        for (Map.Entry posEntry : aSet) {
                            Position aPos = (Position)posEntry.getValue();
                            key = NameFactory.getNextPositiveObjectName();
                            Object[] objects = new Object[]{aPF.getName(), aPos, aPF.getStatus()};
                            StructImpl aStruct = new StructImpl(sType, objects);
                            data.put(key, aStruct);
                        }
                    }
                    this.verifyStruct(data, result, i);
                    return;
                }
                if (i == 8) {
                    ObjectTypeImpl oType = new ObjectTypeImpl(String.class);
                    ObjectTypeImpl oType1 = new ObjectTypeImpl(Position.class);
                    ObjectType[] oTypes = new ObjectType[]{oType, oType1, oType};
                    String[] fieldNames = new String[]{"name", "pVal", "type"};
                    StructTypeImpl sType = new StructTypeImpl(fieldNames, oTypes);
                    while (itr.hasNext()) {
                        Map.Entry m = (Map.Entry)itr.next();
                        key = (String)m.getKey();
                        Object val = ParRegQueryBB.getFromSharedMap(key);
                        aPF = (NewPortfolio)val;
                        if (!key.startsWith(regionName + "Object") || !aPF.getName().equals("Object_12") && !aPF.getName().equals("Object_11")) continue;
                        Map aMap = aPF.getPositions();
                        Set aSet = aMap.entrySet();
                        for (Map.Entry posEntry : aSet) {
                            Position aPos = (Position)posEntry.getValue();
                            if (!(aPos.getMktValue() >= 1.0)) continue;
                            key = NameFactory.getNextPositiveObjectName();
                            Object[] objects = new Object[]{aPF.getName(), aPos, aPF.getType()};
                            StructImpl aStruct = new StructImpl(sType, objects);
                            data.put(key, aStruct);
                        }
                    }
                    this.verifyStruct(data, result, i);
                    return;
                }
            }
        }
        Log.getLogWriter().info("qualified size from BB is " + data.size());
        this.verifyResult(data, result, i, aRegion);
    }

    protected void verifyResult(Map dataFromBB, Object result, int i, Region aRegion) {
        Log.getLogWriter().info("Verifying query number " + ++i);
        int dataSizeFromBB = dataFromBB.size();
        int dataSizeFromQuery = ((SelectResults)result).size();
        if (dataSizeFromBB > dataSizeFromQuery) {
            Log.getLogWriter().info("Operation Failed");
            if (i == 1) {
                this.logResults(dataFromBB, result, aRegion);
            }
            throw new TestException("Size in the BB " + dataSizeFromBB + " is more than that in the Query result size: " + dataSizeFromQuery + " while executing query number " + i);
        }
        if (dataSizeFromBB < dataSizeFromQuery) {
            Log.getLogWriter().info("Operation Failed");
            throw new TestException("Size in the BB " + dataSizeFromBB + " is fewer than that in the Query result size: " + dataSizeFromQuery + " while executing query number " + i);
        }
        for (Object currObj : (SelectResults)result) {
            NewPortfolio aPF;
            if (currObj instanceof PdxInstance) {
                currObj = PdxTestVersionHelper.toBaseObject(currObj);
            }
            if (dataFromBB.containsValue(aPF = (NewPortfolio)currObj)) continue;
            Log.getLogWriter().info("Query result contains item not found in the BB while executing query number " + i);
            if (i == 1) {
                this.logResults(dataFromBB, result, aRegion);
            }
            throw new TestException("Query result contains item not found in the BB while executing query number " + i);
        }
        Log.getLogWriter().info("Operation done : query " + i + " verified successfully");
    }

    private String resultsToString(Map dataFromBB, Object result, Region aRegion) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Data from BB has " + dataFromBB.size() + " entries\nresults has " + ((SelectResults)result).size() + " entries\n");
        aStr.append("from bb\n");
        for (Object key : dataFromBB.keySet()) {
            aStr.append("   " + key + " " + dataFromBB.get(key) + "\n");
        }
        aStr.append("results\n");
        Iterator itr = ((SelectResults)result).iterator();
        while (itr.hasNext()) {
            aStr.append("   " + itr.next() + "\n");
        }
        return aStr.toString();
    }

    protected void logResults(Map dataFromBB, Object result, Region aRegion) {
        Iterator<Object> itr = ((SelectResults)result).iterator();
        while (itr.hasNext()) {
            NewPortfolio aPF = (NewPortfolio)PdxTestVersionHelper.toBaseObject(itr.next());
            if (aPF.getStatus().compareTo("active") != 0) continue;
        }
        Collection data = dataFromBB.values();
        int counter = 0;
        itr = aRegion.values().iterator();
        while (itr.hasNext()) {
            NewPortfolio aPF = (NewPortfolio)PdxTestVersionHelper.toBaseObject(itr.next());
            if (aPF.getStatus().compareTo("active") != 0) continue;
            ++counter;
            if (!data.contains(aPF)) continue;
            data.remove(aPF);
        }
        Log.getLogWriter().info("From the region the size of qualifying results is " + counter);
        itr = data.iterator();
        while (itr.hasNext()) {
            Log.getLogWriter().info("Object in blackboard " + ((NewPortfolio)PdxTestVersionHelper.toBaseObject(itr.next())).getName());
        }
    }

    protected boolean verifyResult(Map dataFromBB, Object result, int i) {
        Log.getLogWriter().info("Verifying query number " + ++i);
        if (dataFromBB.size() > ((SelectResults)result).size()) {
            Log.getLogWriter().info("Operation Failed");
            throw new TestException("Size in the BB " + dataFromBB.size() + " is more than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
        }
        if (dataFromBB.size() < ((SelectResults)result).size()) {
            Log.getLogWriter().info("Operation Failed");
            throw new TestException("Size in the BB " + dataFromBB.size() + " is fewer than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
        }
        for (NewPortfolio aPF : (SelectResults)result) {
            if (dataFromBB.containsValue(aPF)) continue;
            Log.getLogWriter().info("Query result contains item not found in the BB while executing query number " + i);
            throw new TestException("Query result contains item not found in the BB while executing query number " + i);
        }
        Log.getLogWriter().info("Operation done : query " + i + " verified successfully");
        return true;
    }

    protected boolean verifyStruct(Map dataFromBB, Object result, int i) {
        Log.getLogWriter().info("Verifying query number " + ++i);
        Log.getLogWriter().info("qualified size from BB is " + dataFromBB.size());
        if (dataFromBB.size() > ((SelectResults)result).size()) {
            Log.getLogWriter().info("Size in the BB " + dataFromBB.size() + " is more than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
            this.logStructResults(dataFromBB, result);
            throw new TestException("Size in the BB " + dataFromBB.size() + " is more than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
        }
        if (dataFromBB.size() < ((SelectResults)result).size()) {
            Log.getLogWriter().info("Size in the BB " + dataFromBB.size() + " is fewer than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
            this.logStructResults(dataFromBB, result);
            throw new TestException("Size in the BB " + dataFromBB.size() + " is fewer than that in the Query result size: " + ((SelectResults)result).size() + " while executing query number " + i);
        }
        for (StructImpl aStruct : (SelectResults)result) {
            if (this.containsValue(dataFromBB, (Struct)aStruct)) continue;
            Log.getLogWriter().info("Query result contains item not found in the BB while executing query number " + i + ", struct not found is " + aStruct);
            this.logStructResults(dataFromBB, result);
            throw new TestException("Query result contains item not found in the BB while executing query number " + i);
        }
        Log.getLogWriter().info("Operation done : query " + i + " verified successfully");
        return true;
    }

    protected boolean containsValue(Map dataFromBB, Struct aStruct) {
        if (pdxReadSerialized) {
            for (Object bbValue : dataFromBB.values()) {
                Object[] structFieldNames;
                Struct bbStruct;
                Object[] bbFieldNames;
                if (!(bbValue instanceof Struct) || !Arrays.equals(bbFieldNames = (bbStruct = (Struct)bbValue).getStructType().getFieldNames(), structFieldNames = aStruct.getStructType().getFieldNames())) continue;
                Object[] bbFieldValues = bbStruct.getFieldValues();
                for (int i = 0; i < bbFieldValues.length; ++i) {
                    bbFieldValues[i] = PdxTestVersionHelper.toBaseObject(bbFieldValues[i]);
                }
                Object[] structFieldValues = aStruct.getFieldValues();
                for (int i = 0; i < structFieldValues.length; ++i) {
                    structFieldValues[i] = PdxTestVersionHelper.toBaseObject(structFieldValues[i]);
                }
                if (!Arrays.equals(bbFieldValues, structFieldValues)) continue;
                return true;
            }
            return false;
        }
        return dataFromBB.containsValue(aStruct);
    }

    protected void logStructResults(Map dataFromBB, Object result) {
        Iterator itr = ((SelectResults)result).iterator();
        Iterator itr1 = dataFromBB.values().iterator();
        Log.getLogWriter().info("dataFromBB class is " + dataFromBB.getClass());
        while (itr1.hasNext()) {
            StructImpl bbStruct = (StructImpl)itr1.next();
            Log.getLogWriter().info("From BB, bbStruct: " + bbStruct.toString());
            Log.getLogWriter().info("From BB, field name 1 " + bbStruct.getFieldNames()[0].toString());
            Log.getLogWriter().info("From BB, field name 2 " + bbStruct.getFieldNames()[1].toString());
            Log.getLogWriter().info("From BB, Object type 1 " + bbStruct.getFieldTypes()[0].toString());
            Log.getLogWriter().info("From BB, Object type 1 " + bbStruct.getFieldTypes()[1].toString());
            Log.getLogWriter().info("From BB, Object value 1 " + bbStruct.getFieldValues()[0].toString());
            Log.getLogWriter().info("From BB, Object value 2 " + bbStruct.getFieldValues()[1].toString());
        }
        while (itr.hasNext()) {
            StructImpl aStruct = (StructImpl)itr.next();
            Log.getLogWriter().info("From result set, a Struct: " + aStruct.toString());
            Log.getLogWriter().info("From result set, field name 1 " + aStruct.getFieldNames()[0].toString());
            Log.getLogWriter().info("From result set, field name 2 " + aStruct.getFieldNames()[1].toString());
            Log.getLogWriter().info("From result set, field type 1 " + aStruct.getFieldTypes()[0].toString());
            Log.getLogWriter().info("From result set, field type 2 " + aStruct.getFieldTypes()[1].toString());
            Log.getLogWriter().info("From result set, field value 1 " + aStruct.getFieldValues()[0].toString());
            Log.getLogWriter().info("From result set, field value 2 " + aStruct.getFieldValues()[1].toString());
        }
    }

    @Override
    protected void checkEventCounters() {
        this.checkEventCounters(true);
    }

    protected void checkEventCounters(boolean numCloseIsExact) {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long numClose = counters.read(EventBB.NUM_CLOSE);
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs/C clients with listener installed: " + numVmsWithList);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", numCreate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", numDestroy * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", numInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotRemote", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", numUpdate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", numRegionInval * (long)numVmsWithList + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", numRegionInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", numRegionInval + numLocalRegionInval));
        al.add(new ExpCounterValue("numClose", numClose, numCloseIsExact));
        EventCountersBB.getBB().checkEventCounters(al);
    }
}

