/*
 * Decompiled with CFR 0.152.
 */
package parReg.partitionMan;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.partition.PartitionManager;
import hydra.CacheHelper;
import hydra.Log;
import java.util.HashSet;
import java.util.Set;
import util.TestException;

public class PRListener
implements PartitionListener {
    private static Region colocatedWithRegion;

    public void afterPrimary(int bucketId) {
        Log.getLogWriter().info("In PRListener.afterPrimary for bucketId " + bucketId);
        Set rootRegions = CacheHelper.getCache().rootRegions();
        HashSet allRegions = new HashSet(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        for (Region aRegion : allRegions) {
            if (aRegion.getFullPath().equals(colocatedWithRegion.getFullPath())) continue;
            Log.getLogWriter().info("Calling PartitionManager.createPrimaryBucket(" + aRegion.getFullPath() + ", " + bucketId + "<bucketId>, true, true)");
            long startTime = System.currentTimeMillis();
            PartitionManager.createPrimaryBucket((Region)aRegion, (int)bucketId, (boolean)true, (boolean)true);
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("Done calling PartitionManager.createPrimaryBucket(" + aRegion.getFullPath() + ", " + bucketId + "<bucketId>, true, true), duration is " + duration + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRegionCreate(Region<?, ?> aRegion) {
        Log.getLogWriter().info("In PRListener.afterRegionCreate for " + aRegion.getFullPath());
        Class<PRListener> clazz = PRListener.class;
        synchronized (PRListener.class) {
            if (colocatedWithRegion != null) {
                throw new TestException("PRListener was installed in more than one region; it was already installed in " + colocatedWithRegion.getFullPath() + " and now is being installed in " + aRegion.getFullPath());
            }
            colocatedWithRegion = aRegion;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void afterBucketRemoved(int bucketId, Iterable<?> keys) {
    }

    public void afterBucketCreated(int bucketId, Iterable<?> keys) {
    }
}

