/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import parReg.ParRegBB;
import parReg.colocation.KeyResolver;
import parReg.colocation.Month;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.ExecuteExceptionBB;
import parReg.execute.HAExceptionHandlingFunction;
import parReg.execute.NonReExecutingFunction;
import parReg.execute.ReExecutingFunction;
import util.TestException;
import util.TestHelper;

public class HAExceptionHandlingTest {
    protected static HAExceptionHandlingTest testInstance;
    public GsRandom random = new GsRandom();
    protected static Cache theCache;
    protected static Region aRegion;
    public static final int NUM_KEYS = 200;
    public static final String BUCKETS_ON_NODE = "Buckets on node";
    public static final String ALL_BUCKET_IDS = "All Bucket Ids";
    public static final String KEY_SET = "Key Set";
    public static final String BUCKET_KEYS = "Bucket Keys";
    public static final String CACHE_CLOSED_VM = "Cache Closed Vm";

    public static synchronized void HydraTask_initializeDataStore() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
            testInstance.initialize("dataStore");
        }
    }

    public static synchronized void HydraTask_initializeAccessor() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
            testInstance.initialize("accessor");
        }
    }

    public static synchronized void HydraTask_initializeServer() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
            testInstance.initialize("bridge");
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
            testInstance.initialize("edge");
        }
    }

    public static synchronized void HydraTask_populateRegion() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.populateRegion(aRegion);
    }

    public static synchronized void HydraTask_populateRegionWithCustomPartition() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.populateRegionWithCustomPartition(aRegion);
    }

    public static void HydraTask_registerFunction() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        FunctionService.registerFunction((Function)new HAExceptionHandlingFunction());
    }

    public static synchronized void HydraTask_updateBBWithNodes() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.updateBBWithNodes(aRegion);
    }

    public static synchronized void HydraTask_updateBB() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.updateBB(aRegion);
    }

    public static synchronized void HydraTask_clientNormalShutDown() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.clientNormalShutDown();
    }

    public static void HydraTask_doExecuteExpectingExceptions() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.doExecuteNodeCacheCloseGetResult(aRegion);
        testInstance.doExecuteWithEntryDestroys(aRegion);
        testInstance.doExecuteNodeFailOverGetResult(aRegion);
    }

    public static void HydraTask_reExecuteExceptions() {
        testInstance.doReExecuteExceptionAllBuckets(aRegion);
        testInstance.doReExecuteExceptionMultipleBuckets(aRegion);
        testInstance.doReExecuteExceptionSingleBucket(aRegion);
    }

    public static void HydraTask_doRandomFunctionExecutions() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.doRandomFunctionExecutions(aRegion);
    }

    public static synchronized void HydraTask_recycleOrCloseCache() {
        if (testInstance == null) {
            testInstance = new HAExceptionHandlingTest();
        }
        testInstance.recycleOrCloseCache(aRegion);
    }

    protected void recycleOrCloseCache(Region aRegion) {
        int n = this.random.nextInt(1, 100);
        if (n < 51) {
            this.recycleVM();
        } else {
            this.doCacheClose();
        }
    }

    protected void doCacheClose() {
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            Log.getLogWriter().info("Closing cache");
            theCache.close();
        }
        MasterController.sleepForMs(10000);
        this.initialize("bridge");
        BridgeHelper.startBridgeServer("bridge");
        FunctionService.registerFunction((Function)new HAExceptionHandlingFunction());
        MasterController.sleepForMs(20000);
    }

    protected void recycleVM() {
        try {
            MasterController.sleepForMs(30000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -32);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    protected void doRandomFunctionExecutions(Region region) {
        Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            ResultCollector rc = dataSet.withArgs((Object)"ExecuteForSomeTime").execute((Function)new HAExceptionHandlingFunction());
            rc.getResult();
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got expected FunctionInvocationTargetException");
            }
            if (e instanceof FunctionException && e.getMessage().contains("Server unreachable")) {
                Log.getLogWriter().info("Got expected exception " + e);
            }
            throw new TestException("Caught exception " + e + e.getMessage() + " Cause " + e.getMessage(), e);
        }
    }

    protected void doExecuteWithEntryDestroys(Region region) {
        ResultCollector rc;
        Set filterSet;
        Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            filterSet = ((PartitionedRegion)region).getSomeKeys(new Random(20L));
        }
        catch (Exception e1) {
            throw new TestException("Test issue :", e1);
        }
        try {
            rc = dataSet.withFilter(filterSet).withArgs((Object)"waitForKeyDestroys").execute((Function)new HAExceptionHandlingFunction());
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        for (String key : filterSet) {
            region.destroy((Object)key);
        }
        ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.keyDestroyCompleted);
        try {
            rc.getResult();
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof EntryNotFoundException) {
                Log.getLogWriter().info("Got the expected EntryNotFoundException");
            }
            throw new TestException("Caught the exception ", e);
        }
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.keyDestroyCompleted);
    }

    protected void doExecuteNodeCacheCloseGetResult(Region region) {
        ResultCollector rc;
        Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            rc = dataSet.withArgs((Object)"executeForCacheClose").execute((Function)new HAExceptionHandlingFunction());
        }
        catch (Exception e) {
            throw new TestException("Function execution failed with exception ", e);
        }
        Log.getLogWriter().info("Signalling the cache close for another node.");
        ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.signalCacheClose);
        try {
            Log.getLogWriter().info("Going to getResult()");
            rc.getResult();
        }
        catch (Exception e) {
            if (e instanceof FunctionException && e.getCause() instanceof FunctionInvocationTargetException) {
                Log.getLogWriter().info("Got the expected FunctionInvocationTargetException : going to re-execute");
                dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
                try {
                    rc = dataSet.withArgs((Object)"ExecuteForSomeTime").execute((Function)new HAExceptionHandlingFunction());
                    rc.getResult();
                }
                catch (Exception e1) {
                    throw new TestException("Function execution failed with exception ", e1);
                }
            }
            throw new TestException("Caught the exception ", e);
        }
        ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.signalCacheCreate);
        TestHelper.waitForCounter(ExecuteExceptionBB.getBB(), "ExecuteExceptionBB.cacheCreateCompleted", ExecuteExceptionBB.cacheCreateCompleted, 1L, true, 60000L);
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.signalCacheClose);
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.cacheCloseCompleted);
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.signalCacheCreate);
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.cacheCreateCompleted);
    }

    protected void doExecuteNodeFailOverGetResult(Region region) {
        ClientVmInfo targetNode;
        block8: {
            ResultCollector rc;
            Execution dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
            try {
                rc = dataSet.withArgs((Object)"executeForVMDown").execute((Function)new HAExceptionHandlingFunction());
            }
            catch (Exception e) {
                throw new TestException("Function execution failed with exception ", e);
            }
            targetNode = this.getTargetNodeToKill(region);
            Log.getLogWriter().info("Killing the vm " + targetNode);
            try {
                ClientVmMgr.stop("Killing vm", -21, -31, targetNode);
                ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.vmCrashComplete);
                Log.getLogWriter().info("Going to getResult()");
                rc.getResult();
            }
            catch (Exception e) {
                if (!(e instanceof FunctionException) || !(e.getCause() instanceof FunctionInvocationTargetException)) break block8;
                Log.getLogWriter().info("Got the expected FunctionInvocationTargetException: going to re-execute");
                dataSet = FunctionService.onRegion((Region)region).withCollector((ResultCollector)new ArrayListResultCollector());
                try {
                    rc = dataSet.withArgs((Object)"ExecuteForSomeTime").execute((Function)new HAExceptionHandlingFunction());
                    rc.getResult();
                }
                catch (Exception e1) {
                    throw new TestException("Function execution failed with exception ", e1);
                }
            }
        }
        try {
            ClientVmMgr.start("Bringing back the target node", targetNode);
            ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.crashedVMUp);
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException("Caught unexpected exception ", e);
        }
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.vmCrashComplete);
        ExecuteExceptionBB.getBB().getSharedCounters().zero(ExecuteExceptionBB.crashedVMUp);
    }

    protected ClientVmInfo getTargetNodeToKill(Region region) {
        if (region instanceof PartitionedRegion) {
            ArrayList otherVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
            if (ExecuteExceptionBB.getBB().getSharedMap().get(CACHE_CLOSED_VM) != null) {
                Integer cacheClosedVmId = (Integer)ExecuteExceptionBB.getBB().getSharedMap().get(CACHE_CLOSED_VM);
                otherVMs.remove(cacheClosedVmId);
            }
            return new ClientVmInfo((Integer)otherVMs.get(0));
        }
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        Random rand = new Random();
        int index = rand.nextInt(endpoints.size() - 1);
        BridgeHelper.Endpoint endpoint = endpoints.get(index);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        return target;
    }

    protected void initialize(String regionDescriptName) {
        theCache = CacheHelper.createCache("cache1");
        String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
        Log.getLogWriter().info("Creating region " + regionName);
        RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
        String poolName = attributes.getPoolName();
        if (poolName != null) {
            PoolHelper.createPool(poolName);
        }
        aRegion = theCache.createRegion(regionName, attributes);
        Log.getLogWriter().info("Completed creating region " + aRegion.getName());
    }

    public void clientNormalShutDown() {
        TestHelper.waitForCounter(ExecuteExceptionBB.getBB(), "ExecuteExceptionBB.signalCacheClose", ExecuteExceptionBB.signalCacheClose, 1L, true, 60000L);
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            int myVmid = RemoteTestModule.getMyVmid();
            ExecuteExceptionBB.getBB().getSharedMap().put(CACHE_CLOSED_VM, myVmid);
            Log.getLogWriter().info("Closing cache");
            theCache.close();
        }
        ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.cacheCloseCompleted);
        TestHelper.waitForCounter(ExecuteExceptionBB.getBB(), "ExecuteExceptionBB.signalCacheCreate", ExecuteExceptionBB.signalCacheCreate, 1L, true, 60000L);
        this.initialize("dataStore");
        this.populateRegion(aRegion);
        ExecuteExceptionBB.getBB().getSharedCounters().increment(ExecuteExceptionBB.cacheCreateCompleted);
    }

    protected void populateRegion(Region region) {
        for (int i = 0; i < 200; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Integer value = new Integer(i);
            region.put((Object)keyName, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 200 keys and region size is " + region.size());
    }

    protected void populateRegionWithCustomPartition(Region region) {
        for (int i = 0; i < 200; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Month routingObjectHolder = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            KeyResolver key = new KeyResolver(keyName, routingObjectHolder);
            Integer value = new Integer(i);
            region.put((Object)key, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 200 keys and region size is " + region.size());
    }

    protected void updateBBWithNodes(Region region) {
        HashSet allBucketIds;
        if (!(region instanceof PartitionedRegion)) {
            throw new TestException("This test should be using partitioned region");
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        String localVM = ds.getDistributedMember().getId();
        List bucketListOnNode = ((PartitionedRegion)region).getLocalBucketsListTestOnly();
        ParRegBB.getBB().getSharedMap().put(localVM, bucketListOnNode);
        if (ParRegBB.getBB().getSharedMap().get(ALL_BUCKET_IDS) == null) {
            allBucketIds = new HashSet();
            allBucketIds.addAll(bucketListOnNode);
        } else {
            allBucketIds = (HashSet)ParRegBB.getBB().getSharedMap().get(ALL_BUCKET_IDS);
            allBucketIds.addAll(bucketListOnNode);
        }
        ParRegBB.getBB().getSharedMap().put(ALL_BUCKET_IDS, allBucketIds);
    }

    protected void updateBB(Region region) {
        if (!(region instanceof PartitionedRegion)) {
            throw new TestException("This test should be using partitioned region");
        }
        if (ParRegBB.getBB().getSharedMap().get(KEY_SET) == null) {
            HashSet keySet = new HashSet(((PartitionedRegion)region).keySet());
            ParRegBB.getBB().getSharedMap().put(KEY_SET, keySet);
            try {
                HashSet singleBucketKeySet;
                while ((singleBucketKeySet = new HashSet(((PartitionedRegion)region).getSomeKeys(new Random(20L)))) == null || singleBucketKeySet.size() == 0) {
                }
                ParRegBB.getBB().getSharedMap().put(BUCKET_KEYS, singleBucketKeySet);
            }
            catch (Exception e) {
                throw new TestException("Test issue - got the exception during partitionedRegion.getSomeKeys(rand)");
            }
        }
    }

    protected void doReExecuteExceptionAllBuckets(Region region) {
        ArrayList list;
        Execution execution = FunctionService.onRegion((Region)region);
        try {
            list = (ArrayList)execution.execute((Function)new ReExecutingFunction()).getResult();
        }
        catch (Exception exception) {
            throw new TestException("Caught the exception during the execution of the function ReExecutionFunction ", exception);
        }
        if (list.size() == 0) {
            throw new TestException("Re-executed function should have returned results. But the result list is empty");
        }
        try {
            list = (ArrayList)execution.execute((Function)new NonReExecutingFunction()).getResult();
            throw new TestException("NonReExecutingFunction should have thrown exception as isHA() is set false");
        }
        catch (Exception exception) {
            if (!(exception.getCause() instanceof FunctionInvocationTargetException) || !(exception.getCause().getCause() instanceof IllegalStateException)) {
                throw new TestException("Got the exception ", exception);
            }
            Log.getLogWriter().info("Got the expected exception " + exception.getMessage());
            return;
        }
    }

    protected void doReExecuteExceptionMultipleBuckets(Region region) {
        ArrayList list;
        Set keySet = region.keySet();
        Execution execution = FunctionService.onRegion((Region)region).withFilter(keySet);
        try {
            list = (ArrayList)execution.execute((Function)new ReExecutingFunction()).getResult(100L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            throw new TestException("Caught the exception during the execution of the function ReExecutionFunction " + exception);
        }
        if (list.size() == 0) {
            throw new TestException("Re-executed function should have returned results. But the result list is empty");
        }
        try {
            list = (ArrayList)execution.execute((Function)new NonReExecutingFunction()).getResult(100L, TimeUnit.SECONDS);
            throw new TestException("NonReExecutingFunction should have thrown exception as isHA() is set false");
        }
        catch (Exception exception) {
            if (!(exception.getCause() instanceof FunctionInvocationTargetException) || !(exception.getCause().getCause() instanceof IllegalStateException)) {
                throw new TestException("Got the exception ", exception);
            }
            Log.getLogWriter().info("Got the expected exception " + exception.getMessage());
            return;
        }
    }

    protected void doReExecuteExceptionSingleBucket(Region region) {
        ArrayList list;
        Set keySet;
        if (region.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            keySet = (Set)ParRegBB.getBB().getSharedMap().get(BUCKET_KEYS);
        } else {
            try {
                while ((keySet = ((PartitionedRegion)region).getSomeKeys(new Random(20L))) == null || keySet.size() == 0) {
                }
            }
            catch (Exception e) {
                throw new TestException("Test issue - Caught exception ", e);
            }
        }
        Execution execution = FunctionService.onRegion((Region)region).withFilter(keySet);
        try {
            list = (ArrayList)execution.execute((Function)new ReExecutingFunction()).getResult();
        }
        catch (Exception exception) {
            throw new TestException("Caught the exception during the execution of the function ReExecutionFunction " + exception);
        }
        if (list.size() != 1) {
            throw new TestException("Re-executed function should have executed on one node. But gave results for " + list.size() + " nodes");
        }
        try {
            list = (ArrayList)execution.execute((Function)new NonReExecutingFunction()).getResult(100L, TimeUnit.SECONDS);
            throw new TestException("NonReExecutingFunction should have thrown exception as isHA() is set false");
        }
        catch (Exception exception) {
            if (!(exception.getCause() instanceof FunctionInvocationTargetException) || !(exception.getCause().getCause() instanceof IllegalStateException)) {
                throw new TestException("Got the exception ", exception);
            }
            Log.getLogWriter().info("Got the expected exception " + exception.getMessage());
            return;
        }
    }
}

