/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.CacheHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import parReg.eviction.EvictionBB;
import parReg.eviction.EvictionPrms;
import util.TestException;

public class MultiPRHeapEvictionBehaviorTest {
    protected static MultiPRHeapEvictionBehaviorTest testInstance;
    protected static Cache theCache;
    public static final int MAX_KEYS_TO_BE_POPULATED;
    public static final int ENTRY_SIZE_IN_BYTES = 0x140000;
    public static final int START_OF_LAST_BUCKETS_ID = 101;
    protected static int totalEvictedEntries;
    protected static int evictionThresholdKeys;
    protected static int extraKeysToBePopulatedInRegionBLastBucket;
    protected static PartitionedRegion regionA;
    protected static PartitionedRegion regionB;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new MultiPRHeapEvictionBehaviorTest();
            testInstance.initialize("regionA");
            testInstance.initialize("regionB");
        }
    }

    protected void initialize(String regionDescriptName) {
        theCache = CacheHelper.createCache("cache1");
        String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
        RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
        if (regionDescriptName.equals("regionA")) {
            regionA = (PartitionedRegion)theCache.createRegion(regionName, attributes);
        } else if (regionDescriptName.equals("regionB")) {
            regionB = (PartitionedRegion)theCache.createRegion(regionName, attributes);
        }
    }

    public static synchronized void HydraTask_putUnEvenlyTillThreshold() {
        testInstance.populateSequentiallyAndIncrementally();
        Log.getLogWriter().info("After putting till threshold the region sizes are " + regionA.size() + " and " + regionB.size());
        testInstance.verifyNoEviction(regionA);
        testInstance.verifyNoEviction(regionB);
    }

    public static synchronized void HydraTask_putExtraKeysWithSleep() {
        MasterController.sleepForMs(20000);
        testInstance.populateSpecificBucketofRegionWithSleep(regionB, regionB.getPartitionAttributes().getTotalNumBuckets() - 1, extraKeysToBePopulatedInRegionBLastBucket);
    }

    public static synchronized void HydraTask_logRegionSize() {
        testInstance.logRegionSize(regionA);
        testInstance.logRegionSize(regionB);
    }

    public static void HydraTask_printBucketAndDiskEntries() {
        testInstance.printBucketAndDiskEntries(regionA);
        testInstance.printBucketAndDiskEntries(regionB);
    }

    public static void HydraTask_verifyProportionateEviction() {
        testInstance.verifyProportionateEviction(regionA);
        testInstance.verifyProportionateEviction(regionB);
    }

    protected void logRegionSize(PartitionedRegion aRegion) {
        Log.getLogWriter().info("Region " + aRegion.getName() + " has expected size " + aRegion.size());
    }

    protected void populateSequentiallyAndIncrementally() {
        int totalNumBuckets = regionA.getPartitionAttributes().getTotalNumBuckets() <= regionB.getPartitionAttributes().getTotalNumBuckets() ? regionA.getPartitionAttributes().getTotalNumBuckets() : regionB.getPartitionAttributes().getTotalNumBuckets();
        for (int bucketId = 0; bucketId < totalNumBuckets; ++bucketId) {
            this.populateSpecificBucketSpecificSize(bucketId, bucketId * 10 + 1, totalNumBuckets);
            if (EvictionBB.getBB().getSharedCounters().read(EvictionBB.ExecutionNumber) <= (long)evictionThresholdKeys || !TestConfig.tab().booleanAt(EvictionPrms.pauseAfterEvictionThreshold, false)) continue;
            return;
        }
    }

    protected void populateSpecificBucketSpecificSize(int bucketId, int maxEntriesPerBucket, int totalNumBuckets) {
        Log.getLogWriter().info("Populating the bucketId " + bucketId + " with " + maxEntriesPerBucket + "entries");
        int entryKey = bucketId;
        for (int numEntriesPerBucket = 0; numEntriesPerBucket < maxEntriesPerBucket; ++numEntriesPerBucket) {
            if (EvictionBB.getBB().getSharedCounters().read(EvictionBB.ExecutionNumber) > (long)evictionThresholdKeys && TestConfig.tab().booleanAt(EvictionPrms.pauseAfterEvictionThreshold, false)) {
                return;
            }
            regionA.put((Object)entryKey, (Object)new byte[0x140000]);
            regionB.put((Object)entryKey, (Object)new byte[0x140000]);
            EvictionBB.getBB().getSharedCounters().incrementAndRead(EvictionBB.ExecutionNumber);
            entryKey += totalNumBuckets;
        }
    }

    protected void populateSpecificBucketofRegionWithSleep(PartitionedRegion aRegion, int bucketId, int numEntries) {
        Log.getLogWriter().info("Populating the bucketId " + bucketId + " with " + numEntries + "entries");
        int entryKey = bucketId;
        for (int numEntriesPerBucket = 0; numEntriesPerBucket < numEntries; ++numEntriesPerBucket) {
            MasterController.sleepForMs(500);
            regionB.put((Object)entryKey, (Object)new byte[0x140000]);
            entryKey += regionB.getPartitionAttributes().getTotalNumBuckets();
        }
    }

    protected void printBucketAndDiskEntries(PartitionedRegion aRegion) {
        MasterController.sleepForMs(20000);
        int totalNumBuckets = aRegion.getPartitionAttributes().getTotalNumBuckets();
        int numEntriesPerBucket = MAX_KEYS_TO_BE_POPULATED / totalNumBuckets;
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        for (Map.Entry entry : bucketList) {
            BucketRegion bucket = (BucketRegion)entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            totalEvictedEntries = (int)((long)totalEvictedEntries + numEvictionsForBucket);
            if (aRegion.getAttributes().getEvictionAttributes().getAction() == EvictionAction.OVERFLOW_TO_DISK) {
                Log.getLogWriter().info("For the region " + aRegion.getName() + " For the bucket region with id " + bucketId + " entries left in vm is " + bucket.getNumEntriesInVM() + " and entries evicted " + bucket.getEvictions());
                continue;
            }
            if (aRegion.getAttributes().getEvictionAttributes().getAction() != EvictionAction.LOCAL_DESTROY) continue;
            Log.getLogWriter().info("For the region " + aRegion.getName() + "  For the bucket region with id " + bucketId + " entries evicted : " + bucket.getEvictions() + " and bucket size is " + bucket.getSizeForEviction());
        }
        HeapMemoryMonitor hmm = ((InternalResourceManager)theCache.getResourceManager()).getHeapMonitor();
        Log.getLogWriter().info("The tenuredHeasUsage is : " + hmm.getBytesUsed() / 0x100000L);
        Log.getLogWriter().info("Total evicted entries = " + totalEvictedEntries);
    }

    protected void verifyProportionateEviction(PartitionedRegion aRegion) {
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        Comparator<Map.Entry<Integer, BucketRegion>> comparator = new Comparator<Map.Entry<Integer, BucketRegion>>(){

            @Override
            public int compare(Map.Entry<Integer, BucketRegion> o1, Map.Entry<Integer, BucketRegion> o2) {
                if (o1.getKey() < o2.getKey()) {
                    return -1;
                }
                if (o1.getKey() > o2.getKey()) {
                    return 1;
                }
                return 0;
            }
        };
        TreeSet<Map.Entry<Integer, BucketRegion>> sortedBucketSet = new TreeSet<Map.Entry<Integer, BucketRegion>>(comparator);
        sortedBucketSet.addAll(bucketList);
        Iterator<Map.Entry<Integer, BucketRegion>> iterator = sortedBucketSet.iterator();
        StringBuffer errorString = new StringBuffer();
        int numDeviatedBuckets = 0;
        int previousBucketId = -1;
        long previousBucketEviction = 0L;
        long previousBucketSize = 0L;
        long totalEvictionsForRegion = 0L;
        while (iterator.hasNext()) {
            long bucketSize;
            Map.Entry<Integer, BucketRegion> entry = iterator.next();
            BucketRegion bucket = entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            totalEvictionsForRegion += numEvictionsForBucket;
            try {
                bucketSize = bucket.getNumEntriesInVM() + bucket.getNumOverflowOnDisk();
            }
            catch (Exception e) {
                throw new TestException("Caught ", e);
            }
            if (numEvictionsForBucket == bucketSize) {
                throw new TestException("For the region " + aRegion.getName() + " bucket region with id " + bucketId + " bucket evicted all entries");
            }
            if (numEvictionsForBucket < previousBucketEviction && bucketSize > previousBucketSize) {
                errorString.append("For the region " + aRegion.getName() + " bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " but leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted more entries " + previousBucketEviction + "\n");
                if (++numDeviatedBuckets > 1) {
                    throw new TestException(errorString);
                }
                Log.getLogWriter().info("For the region " + aRegion.getName() + " bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " but leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted more entries " + previousBucketEviction);
            } else {
                String s = "For the region " + aRegion.getName() + " bucket region with id " + bucketId + " with size " + bucketSize + " numEvicted is " + numEvictionsForBucket + " and leaner bucket with id " + previousBucketId + " with bucket size " + previousBucketSize + " evicted lesser entries " + previousBucketEviction;
                Log.getLogWriter().info(s);
            }
            previousBucketId = bucketId;
            previousBucketEviction = numEvictionsForBucket;
            previousBucketSize = bucketSize;
        }
        if (totalEvictionsForRegion <= 0L) {
            throw new TestException("Region " + aRegion.getName() + " did not evict.");
        }
    }

    protected void verifyNoEviction(PartitionedRegion aRegion) {
        Set bucketList = aRegion.getDataStore().getAllLocalBuckets();
        for (Map.Entry entry : bucketList) {
            BucketRegion bucket = (BucketRegion)entry.getValue();
            int bucketId = bucket.getId();
            long numEvictionsForBucket = bucket.getEvictions();
            totalEvictedEntries = (int)((long)totalEvictedEntries + numEvictionsForBucket);
        }
        if (totalEvictedEntries != 0) {
            throw new TestException("Test issue - Test expects no eviction to be happened when the regions are populated till eviction threshold but region " + aRegion.getName() + " evicted " + totalEvictedEntries + " entries");
        }
        Log.getLogWriter().info("As expected region " + aRegion.getName() + " did not evict");
    }

    static {
        MAX_KEYS_TO_BE_POPULATED = (int)TestConfig.tab().longAt(EvictionPrms.maxEntries, 2712L);
        totalEvictedEntries = 0;
        evictionThresholdKeys = 475;
        extraKeysToBePopulatedInRegionBLastBucket = 100;
    }
}

