/*
 * Decompiled with CFR 0.152.
 */
package objects.size;

import hydra.FileUtil;
import hydra.MethExecutor;
import hydra.TestConfig;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import objects.ObjectHelper;
import objects.size.ObjectSizerPrms;

public class ObjectSizer {
    public static void sizeTask() throws Exception {
        String objectType = TestConfig.tab().stringAt(ObjectSizerPrms.objectType, "objects.PSTObject");
        int objectIndex = TestConfig.tab().intAt(ObjectSizerPrms.objectIndex, 0);
        Object obj = ObjectHelper.createObject(objectType, objectIndex);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Class[] prms = new Class[]{DataOutput.class};
            Method m = MethExecutor.getMethod(obj.getClass(), "toData", prms);
            Object[] methodArgs = new Object[]{new DataOutputStream(baos)};
            m.invoke(obj, methodArgs);
        }
        catch (NoSuchMethodException e) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
        }
        String result = objectType + " with index " + objectIndex + " serialized to " + baos.toByteArray().length + " bytes\n";
        FileUtil.appendToFile("size.out", result);
    }
}

