/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import objects.query.BaseQueryFactory;
import objects.query.broker.BrokerPrms;
import objects.query.broker.BrokerTicket;

public class SQLBrokerTicketQueryFactory
extends BaseQueryFactory {
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("create table " + BrokerTicket.getTableName() + " (id int, brokerId int, price double, quantity int, ticker varchar(20), str01 varchar(20), str02 varchar(20), str03 varchar(20), str04 varchar(20), str05 varchar(20), str06 varchar(20), str07 varchar(20), str08 varchar(20), str09 varchar(20), str10 varchar(20), str11 varchar(20), str12 varchar(20), str13 varchar(20), str14 varchar(20), str15 varchar(20))");
        return stmts;
    }

    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("drop table if exists " + BrokerTicket.getTableName());
        return stmts;
    }

    public List getInsertStatements(int bid) {
        int numTicketsPerBroker = BrokerPrms.getNumTicketsPerBroker();
        int numTicketPrices = BrokerPrms.getNumTicketPrices();
        ArrayList<String> stmts = new ArrayList<String>();
        for (int i = 0; i < numTicketsPerBroker; ++i) {
            int id = BrokerTicket.getId(i, bid, numTicketsPerBroker);
            double price = BrokerTicket.getPrice(id, numTicketPrices);
            int quantity = BrokerTicket.getQuantity(id);
            String ticker = BrokerTicket.getTicker(id);
            String str01 = BrokerTicket.getFiller(id);
            String str02 = BrokerTicket.getFiller(id);
            String str03 = BrokerTicket.getFiller(id);
            String str04 = BrokerTicket.getFiller(id);
            String str05 = BrokerTicket.getFiller(id);
            String str06 = BrokerTicket.getFiller(id);
            String str07 = BrokerTicket.getFiller(id);
            String str08 = BrokerTicket.getFiller(id);
            String str09 = BrokerTicket.getFiller(id);
            String str10 = BrokerTicket.getFiller(id);
            String str11 = BrokerTicket.getFiller(id);
            String str12 = BrokerTicket.getFiller(id);
            String str13 = BrokerTicket.getFiller(id);
            String str14 = BrokerTicket.getFiller(id);
            String str15 = BrokerTicket.getFiller(id);
            String stmt = "insert into " + BrokerTicket.getTableName() + " (id, brokerId, price, quantity, ticker, str01, str02, str03, str04, str05, str06, str07, str08, str09, str10, str11, str12, str13, str14, str15) values (" + id + "," + bid + "," + price + "," + quantity + ",'" + ticker + "','" + str01 + "','" + str02 + "','" + str03 + "','" + str04 + "','" + str05 + "','" + str06 + "','" + str07 + "','" + str08 + "','" + str09 + "','" + str10 + "','" + str11 + "','" + str12 + "','" + str13 + "','" + str14 + "','" + str15 + "')";
            stmts.add(stmt);
        }
        return stmts;
    }

    public List getPreparedInsertStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        String stmt = "insert into " + BrokerTicket.getTableName() + "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        stmts.add(stmt);
        return stmts;
    }

    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int bid) throws SQLException {
        int results = 0;
        int numTicketsPerBroker = BrokerPrms.getNumTicketsPerBroker();
        int numTicketPrices = BrokerPrms.getNumTicketPrices();
        PreparedStatement stmt = (PreparedStatement)pstmts.get(0);
        for (int i = 0; i < numTicketsPerBroker; ++i) {
            int id = BrokerTicket.getId(i, bid, numTicketsPerBroker);
            stmt.setInt(1, id);
            stmt.setInt(2, bid);
            stmt.setDouble(3, BrokerTicket.getPrice(id, numTicketPrices));
            stmt.setInt(4, BrokerTicket.getQuantity(id));
            stmt.setString(5, BrokerTicket.getTicker(id));
            stmt.setString(6, BrokerTicket.getFiller(id));
            stmt.setString(7, BrokerTicket.getFiller(id));
            stmt.setString(8, BrokerTicket.getFiller(id));
            stmt.setString(9, BrokerTicket.getFiller(id));
            stmt.setString(10, BrokerTicket.getFiller(id));
            stmt.setString(11, BrokerTicket.getFiller(id));
            stmt.setString(12, BrokerTicket.getFiller(id));
            stmt.setString(13, BrokerTicket.getFiller(id));
            stmt.setString(14, BrokerTicket.getFiller(id));
            stmt.setString(15, BrokerTicket.getFiller(id));
            stmt.setString(16, BrokerTicket.getFiller(id));
            stmt.setString(17, BrokerTicket.getFiller(id));
            stmt.setString(18, BrokerTicket.getFiller(id));
            stmt.setString(19, BrokerTicket.getFiller(id));
            stmt.setString(20, BrokerTicket.getFiller(id));
            if (this.logUpdates) {
                Log.getLogWriter().info("Executing update: " + stmt);
            }
            results += stmt.executeUpdate();
            if (!this.logUpdates) continue;
            Log.getLogWriter().info("Executed update: " + stmt);
        }
        return results;
    }

    public void execute(String stmt, Connection conn) throws SQLException {
        String s = "Please execute on objects.query.broker.Broker instead";
        throw new UnsupportedOperationException(s);
    }
}

