/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import cacheperf.CachePerfPrms;
import com.gemstone.gemfire.cache.Region;
import hydra.BasePrms;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import objects.query.BaseSQLQueryFactory;
import objects.query.QueryObjectException;
import objects.query.SQLQueryFactory;
import objects.query.broker.Broker;
import objects.query.broker.BrokerPrms;
import objects.query.broker.BrokerTicket;
import objects.query.broker.SQLBrokerTicketQueryFactory;

public class SQLBrokerQueryFactory
extends BaseSQLQueryFactory
implements SQLQueryFactory {
    protected static final GsRandom rng = TestConfig.tab().getRandGen();
    protected SQLBrokerTicketQueryFactory brokerTicketQueryFactory = new SQLBrokerTicketQueryFactory();

    @Override
    public void init() {
        super.init();
        this.brokerTicketQueryFactory.init();
    }

    @Override
    public int getQueryType() {
        return BrokerPrms.getQueryType(1);
    }

    @Override
    public int getUpdateQueryType() {
        return BrokerPrms.getUpdateQueryType(1);
    }

    @Override
    public int getDeleteQueryType() {
        return BrokerPrms.getDeleteQueryType(1);
    }

    @Override
    public List getConstraintStatements() {
        return new ArrayList();
    }

    @Override
    public String getQuery(int queryType, int i) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getRandomEqualityOnBrokerIdQuery();
                break;
            }
            case 1: {
                query = this.getEqualityOnBrokerIdQuery(i);
                break;
            }
            case 2: {
                query = this.getTicketsFromEqualityOnBrokerIdQuery(i);
                break;
            }
            case 3: {
                query = this.getTicketsFromRandomRangeOnTicketPriceQuery();
                break;
            }
            case 4: {
                query = this.getBrokersFromRandomRangeOnTicketPriceQuery();
                break;
            }
            case 5: {
                query = this.getBrokersFromRandomSizeRangeOnTicketPriceQuery();
                break;
            }
            case 6: {
                query = this.getBrokersFromRandomPercentageRangeOnTicketPriceQuery();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    @Override
    public String getPreparedQuery(int queryType) {
        String query = "";
        int type = queryType;
        switch (type) {
            case 0: {
                query = this.getPreparedStatementForEqualityOnBrokerIdQuery();
                break;
            }
            case 1: {
                query = this.getPreparedStatementForEqualityOnBrokerIdQuery();
                break;
            }
            case 2: {
                query = this.getPreparedStatementForTicketsFromEqualityOnBrokerIdQuery();
                break;
            }
            case 3: {
                query = this.getPreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery();
                break;
            }
            case 4: {
                query = this.getPreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery();
                break;
            }
            case 5: {
                query = this.getPreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery();
                break;
            }
            case 6: {
                query = this.getPreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    @Override
    public String getCreateSchemaStatement() {
        return "create schema perfTest";
    }

    @Override
    public String getDropSchemaStatement() {
        return "drop schema perfTest";
    }

    @Override
    public List getTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("create table " + Broker.getTableName() + " (id int not null, name varchar(100))");
        stmts.addAll(this.brokerTicketQueryFactory.getTableStatements());
        return stmts;
    }

    @Override
    public List getDropTableStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add("drop table if exists " + Broker.getTableName());
        stmts.addAll(this.brokerTicketQueryFactory.getDropTableStatements());
        return stmts;
    }

    public String getPrimaryKeyIndexOnBrokerId() {
        return "alter table " + Broker.getTableName() + " add primary key(id)";
    }

    @Override
    public List getIndexStatements() {
        ArrayList<String> stmts = new ArrayList<String>();
        Vector indexTypes = BrokerPrms.getIndexTypes();
        for (String indexTypeString : indexTypes) {
            int indexType = BrokerPrms.getIndexType(indexTypeString);
            String stmt = this.getIndexStatement(indexType);
            stmts.add(stmt);
        }
        return stmts;
    }

    public String getIndexStatement(int type) {
        String query;
        switch (type) {
            case 0: {
                query = this.getPrimaryKeyIndexOnBrokerId();
                break;
            }
            case 1: {
                query = this.getUniqueIndexOnBrokerName();
                break;
            }
            case 2: {
                query = this.getUniqueKeyIndexOnBrokerTicketId();
                break;
            }
            case 3: {
                query = this.getUniqueKeyIndexOnBrokerTicketName();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Should not happen");
            }
        }
        return query;
    }

    public String getUniqueKeyIndexOnBrokerId() {
        return "create unique index id_uidx on " + Broker.getTableName() + " (id)";
    }

    public String getUniqueIndexOnBrokerName() {
        return "create unique index name_uidx on " + Broker.getTableName() + " (name)";
    }

    public String getUniqueKeyIndexOnBrokerTicketId() {
        return "create unique index id_uidx on " + Broker.getTableName() + " (id)";
    }

    public String getUniqueKeyIndexOnBrokerTicketName() {
        return "create unique index id_pkidx on " + Broker.getTableName() + " (id)";
    }

    @Override
    public List getInsertStatements(int bid) {
        int numBrokers = BrokerPrms.getNumBrokers();
        if (bid >= numBrokers) {
            String s = "Attempt to get insert statement with bid=" + bid + " when " + BasePrms.nameForKey(BrokerPrms.numBrokers) + "=" + numBrokers;
            throw new QueryObjectException(s);
        }
        ArrayList<String> stmts = new ArrayList<String>();
        String bname = Broker.getName(bid);
        String stmt = "insert into " + Broker.getTableName() + " (id, name) values (" + bid + ",'" + bname + "')";
        stmts.add(stmt);
        stmts.addAll(this.brokerTicketQueryFactory.getInsertStatements(bid));
        return stmts;
    }

    @Override
    public List getPreparedInsertStatements() {
        ArrayList<Object> stmts = new ArrayList<Object>();
        String stmt = "insert into " + Broker.getTableName() + " values (?,?)";
        stmts.add(stmt);
        stmts.add(this.brokerTicketQueryFactory.getPreparedInsertStatements());
        return stmts;
    }

    @Override
    public int fillAndExecutePreparedInsertStatements(List pstmts, List stmts, int i) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)pstmts.get(0);
        int bid = i;
        int results = 0;
        String bname = Broker.getName(i);
        stmt.setInt(1, bid);
        stmt.setString(2, bname);
        if (this.logUpdates) {
            Log.getLogWriter().info("Executing update: " + stmt);
        }
        results += this.executeUpdatePreparedStatement(stmt);
        if (this.logUpdates) {
            Log.getLogWriter().info("Executed update: " + stmt + " with result = " + results);
        }
        return results += this.brokerTicketQueryFactory.fillAndExecutePreparedInsertStatements((List)pstmts.get(1), (List)stmts.get(1), bid);
    }

    public String getTicketsFromEqualityOnBrokerIdQuery(int bid) {
        if (CachePerfPrms.getMaxKeys() == BrokerPrms.getNumBrokers()) {
            String fields = BrokerPrms.getBrokerFields();
            return "select " + fields + " from " + BrokerTicket.getTableName() + " where brokerId=" + bid;
        }
        String s = BasePrms.nameForKey(BrokerPrms.numBrokers) + " must be smaller then : " + BasePrms.nameForKey(CachePerfPrms.maxKeys);
        throw new HydraConfigException(s);
    }

    public String getPreparedStatementForTicketsFromEqualityOnBrokerIdQuery() {
        if (CachePerfPrms.getMaxKeys() == BrokerPrms.getNumBrokers()) {
            String fields = BrokerPrms.getBrokerTicketFields();
            return "select " + fields + " from " + BrokerTicket.getTableName() + " where brokerId=?";
        }
        String s = BasePrms.nameForKey(BrokerPrms.numBrokers) + " must be smaller then : " + BasePrms.nameForKey(CachePerfPrms.maxKeys);
        throw new HydraConfigException(s);
    }

    public ResultSet fillAndExecutePreparedStatementForTicketsFromEqualityOnBrokerIdQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        pstmt.setInt(1, bid);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getEqualityOnBrokerIdQuery(int bid) {
        if (CachePerfPrms.getMaxKeys() == BrokerPrms.getNumBrokers()) {
            String fields = BrokerPrms.getBrokerFields();
            return "select " + fields + " from " + Broker.getTableAndShortName() + " where " + Broker.getTableShortName() + ".id=" + bid;
        }
        String s = BasePrms.nameForKey(BrokerPrms.numBrokers) + " must be smaller then : " + BasePrms.nameForKey(CachePerfPrms.maxKeys);
        throw new HydraConfigException(s);
    }

    public String getPreparedStatementForEqualityOnBrokerIdQuery() {
        String fields = BrokerPrms.getBrokerFields();
        return "select " + fields + " from " + Broker.getTableAndShortName() + " where " + Broker.getTableShortName() + ".id=?";
    }

    public ResultSet fillAndExecutePreparedStatementForEqualityOnBrokerIdQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        pstmt.setInt(1, bid);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getRandomEqualityOnBrokerIdQuery() {
        String fields = BrokerPrms.getBrokerFields();
        int bid = rng.nextInt(0, BrokerPrms.getNumBrokers() - 1);
        return "select " + fields + " from " + Broker.getTableAndShortName() + " where " + Broker.getTableShortName() + ".id=" + bid;
    }

    public ResultSet fillAndExecutePreparedStatementForRandomEqualityOnBrokerIdQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int randomBid = rng.nextInt(0, BrokerPrms.getNumBrokers() - 1);
        pstmt.setInt(1, randomBid);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getTicketsFromRandomRangeOnTicketPriceQuery() {
        int range = BrokerPrms.getResultSetSize();
        return this.getTicketsFromRandomRangeOnTicketPriceQuery(range);
    }

    public String getTicketsFromRandomRangeOnTicketPriceQuery(int range) {
        String fields = BrokerPrms.getBrokerTicketFields();
        int min = rng.nextInt(0, BrokerPrms.getNumTicketPrices() - range);
        int max = min + range;
        return "select " + fields + " from " + BrokerTicket.getTableAndShortName() + " where " + BrokerTicket.getTableShortName() + ".price >= " + min + " and " + BrokerTicket.getTableShortName() + ".price < " + max;
    }

    public String getPreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery() {
        String fields = BrokerPrms.getBrokerTicketFields();
        return "select " + fields + " from " + BrokerTicket.getTableAndShortName() + " where " + BrokerTicket.getTableShortName() + ".price >= ? and " + BrokerTicket.getTableShortName() + ".price < ?";
    }

    public ResultSet fillAndExecutePreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int range = BrokerPrms.getResultSetSize();
        return this.fillAndExecutePreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery(pstmt, stmt, bid, range);
    }

    public ResultSet fillAndExecutePreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid, int range) throws SQLException {
        int min = rng.nextInt(0, BrokerPrms.getNumTicketPrices() - range);
        int max = min + range;
        pstmt.setInt(1, min);
        pstmt.setInt(2, max);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getBrokersFromRandomRangeOnTicketPriceQuery() {
        int range = BrokerPrms.getResultSetSize();
        return this.getBrokersFromRandomRangeOnTicketPriceQuery(range);
    }

    private String getBrokersFromRandomRangeOnTicketPriceQuery(int range) {
        String fields = BrokerPrms.getFields();
        int min = rng.nextInt(0, BrokerPrms.getNumTicketPrices() - range);
        int max = min + range;
        return "select " + fields + " from " + Broker.getTableAndShortName() + "," + BrokerTicket.getTableAndShortName() + " where " + BrokerTicket.getTableShortName() + ".brokerId = " + Broker.getTableShortName() + ".id and " + BrokerTicket.getTableShortName() + ".price >= " + min + " and " + BrokerTicket.getTableShortName() + ".price < " + max;
    }

    public String getPreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery() {
        String fields = BrokerPrms.getFields();
        return "select " + fields + " from " + Broker.getTableAndShortName() + "," + BrokerTicket.getTableAndShortName() + " where " + BrokerTicket.getTableShortName() + ".brokerId = " + Broker.getTableShortName() + ".id and " + BrokerTicket.getTableShortName() + ".price >= ? and " + BrokerTicket.getTableShortName() + ".price < ?";
    }

    public ResultSet fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int range = BrokerPrms.getResultSetSize();
        return this.fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(pstmt, stmt, bid, range);
    }

    public ResultSet fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid, int range) throws SQLException {
        int min = rng.nextInt(0, BrokerPrms.getNumTicketPrices() - range);
        int max = min + range;
        pstmt.setInt(1, min);
        pstmt.setInt(2, max);
        return this.executeQueryPreparedStatement(pstmt);
    }

    public String getBrokersFromRandomSizeRangeOnTicketPriceQuery() {
        int size = BrokerPrms.getResultSetSize();
        return this.getBrokersFromRandomSizeRangeOnTicketPriceQuery(size);
    }

    public String getBrokersFromRandomSizeRangeOnTicketPriceQuery(int size) {
        int ticketsPerPrice = BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker() / BrokerPrms.getNumTicketPrices();
        if (!BrokerPrms.useBestFit() && size % ticketsPerPrice != 0) {
            String s = "Attempted result set size (" + size + ") does not divide evenly by ticketsPerPrice(" + ticketsPerPrice + ")";
            throw new HydraConfigException(s);
        }
        int range = (int)Math.ceil(size / ticketsPerPrice);
        return this.getBrokersFromRandomRangeOnTicketPriceQuery(range);
    }

    public ResultSet fillAndExecutePreparedStatementForBrokersFromRandomSizeRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        int size = BrokerPrms.getResultSetSize();
        return this.fillAndExecutePreparedStatementForBrokersFromRandomSizeRangeOnTicketPriceQuery(pstmt, stmt, bid, size);
    }

    public ResultSet fillAndExecutePreparedStatementForBrokersFromRandomSizeRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid, int size) throws SQLException {
        int ticketsPerPrice = BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker() / BrokerPrms.getNumTicketPrices();
        if (!BrokerPrms.useBestFit() && size % ticketsPerPrice != 0) {
            String s = "Attempted result set size (" + size + ") does not divide evenly by ticketsPerPrice(" + ticketsPerPrice + ")";
            throw new HydraConfigException(s);
        }
        int range = (int)Math.ceil(size / ticketsPerPrice);
        return this.fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(pstmt, stmt, bid, range);
    }

    public String getBrokersFromRandomPercentageRangeOnTicketPriceQuery() {
        String fields = BrokerPrms.getBrokerFields();
        int percent = BrokerPrms.getResultSetPercentage();
        int tickets = BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker();
        int size = (int)Math.ceil((double)(tickets * percent) / 100.0);
        return this.getBrokersFromRandomSizeRangeOnTicketPriceQuery(size);
    }

    public ResultSet fillAndExecutePreparedStatementForBrokersFromRandomPercentageRangeOnTicketPriceQuery(PreparedStatement pstmt, String stmt, int bid) throws SQLException {
        String fields = BrokerPrms.getBrokerFields();
        int percent = BrokerPrms.getResultSetPercentage();
        int tickets = BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker();
        int size = (int)Math.ceil((double)(tickets * percent) / 100.0);
        return this.fillAndExecutePreparedStatementForBrokersFromRandomSizeRangeOnTicketPriceQuery(pstmt, stmt, bid, size);
    }

    @Override
    public ResultSet fillAndExecutePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        ResultSet rs = null;
        if (this.logQueries) {
            Log.getLogWriter().info("Executing Prepared Statement: ");
        }
        if (queryType == 1) {
            rs = this.fillAndExecutePreparedStatementForEqualityOnBrokerIdQuery(pstmt, stmt, i);
        } else if (queryType == 3) {
            rs = this.fillAndExecutePreparedStatementForTicketsFromRandomRangeOnTicketPriceQuery(pstmt, stmt, i);
        } else if (queryType == 6) {
            rs = this.fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(pstmt, stmt, i);
        } else if (queryType == 4) {
            rs = this.fillAndExecutePreparedStatementForBrokersFromRandomRangeOnTicketPriceQuery(pstmt, stmt, i);
        } else if (queryType == 5) {
            rs = this.fillAndExecutePreparedStatementForBrokersFromRandomSizeRangeOnTicketPriceQuery(pstmt, stmt, i);
        } else if (queryType == 0) {
            rs = this.fillAndExecutePreparedStatementForRandomEqualityOnBrokerIdQuery(pstmt, stmt, i);
        } else if (queryType == 2) {
            rs = this.fillAndExecutePreparedStatementForTicketsFromEqualityOnBrokerIdQuery(pstmt, stmt, i);
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed Prepared Statement: ");
        }
        return rs;
    }

    @Override
    public int fillAndExecuteUpdatePreparedQueryStatement(PreparedStatement pstmt, String stmt, int queryType, int i) throws SQLException {
        return 0;
    }

    public String resultSetToString(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numColumns = metaData.getColumnCount();
        StringBuffer sb = new StringBuffer("");
        int rowNum = 0;
        while (resultSet.next()) {
            sb.append("Row " + rowNum++ + " : ");
            for (int i = 0; i < numColumns; ++i) {
                String columnName = metaData.getColumnName(i);
                int type = metaData.getColumnType(i);
                sb.append(columnName);
                sb.append("=");
                sb.append(resultSet.getObject(i).toString());
                if (i >= numColumns - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public int readResultSet(int queryType, ResultSet rs) throws SQLException {
        return 0;
    }

    @Override
    public Region getRegionForQuery(int queryType) {
        return null;
    }

    @Override
    public Object directGet(Object key, Region region) {
        return null;
    }
}

