/*
 * Decompiled with CFR 0.152.
 */
package objects;

import hydra.BasePrms;
import objects.ObjectAccessException;
import objects.ObjectCreationException;
import objects.ObjectValidationException;
import objects.SizedStringPrms;

public class SizedString {
    private static final String STRDATA = "abcdefghij";

    public static String init(int index) {
        boolean constant = SizedStringPrms.getConstant();
        if (constant) {
            return new String(STRDATA);
        }
        int size = SizedStringPrms.getSize();
        StringBuffer buf = new StringBuffer(size);
        buf.insert(0, (double)index);
        int padding = size - buf.length();
        if (padding < 0) {
            throw new ObjectCreationException("Unable to encode index " + index + " into string of size " + size);
        }
        char[] c = new char[padding];
        for (int i = 0; i < padding; ++i) {
            c[i] = 48;
        }
        buf.append(c);
        return buf.toString();
    }

    public static int getIndex(String str) {
        int marker = str.indexOf(".");
        if (marker == -1) {
            throw new ObjectAccessException("No index is encoded when " + BasePrms.nameForKey(SizedStringPrms.constant) + " is true");
        }
        String index = str.substring(0, marker);
        try {
            return new Integer(index);
        }
        catch (NumberFormatException e) {
            throw new ObjectAccessException(str + " does not contain an encoded integer index");
        }
    }

    public static void validate(int index, String str) {
        if (SizedStringPrms.getConstant()) {
            if (!str.equals(STRDATA)) {
                throw new ObjectValidationException("Expected abcdefghij, got " + str);
            }
        } else {
            int encodedIndex = SizedString.getIndex(str);
            if (encodedIndex != index) {
                throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
            }
        }
    }
}

