/*
 * Decompiled with CFR 0.152.
 */
package newWan.serial.filters;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.EdgeHelper;
import hydra.GemFireDescription;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import newWan.WANBlackboard;
import newWan.serial.filters.MyExtraObject;
import newWan.serial.filters.WanFilterTestPrms;
import util.MethodCoordinator;
import util.TestException;
import util.ValueHolder;

public class WanFilterTest {
    private static WanFilterTest instance;
    private static LogWriter logger;
    private static GsRandom rand;
    protected static volatile MethodCoordinator eventFilterValiatorCoordinator;
    protected static volatile MethodCoordinator tranportFilterDataValidatorCoordinator;
    public static final String FILTER_KEY_PRIFIX = "FilterKey_";
    protected Map<String, Integer> distributedSystems = new HashMap<String, Integer>();

    public static synchronized WanFilterTest getInstance() {
        if (instance == null) {
            instance = new WanFilterTest();
            instance.setDistributedSystems();
            eventFilterValiatorCoordinator = new MethodCoordinator(WanFilterTest.class.getName(), "validateDoOpsForEventFilter");
            tranportFilterDataValidatorCoordinator = new MethodCoordinator(WanFilterTest.class.getName(), "validateTranportFilterData");
        }
        return instance;
    }

    public static void doOpsForEventFilterTask() {
        WanFilterTest.getInstance().doOpsForEventFilter();
    }

    public static void validateDoOpsForEventFilterTask() {
        WanFilterTest test = WanFilterTest.getInstance();
        eventFilterValiatorCoordinator.executeOnce(test, new Object[0]);
    }

    public static void validateTransportFilterDataTask() {
        WanFilterTest test = WanFilterTest.getInstance();
        tranportFilterDataValidatorCoordinator.executeOnce(test, new Object[0]);
    }

    public static void removeEventFilterKeysTask() {
        WanFilterTest.getInstance().removeEventFilterKeys();
    }

    public void doOpsForEventFilter() {
        int keysPerTask = WanFilterTestPrms.getNumKeysPerTask();
        for (int i = 0; i < keysPerTask; ++i) {
            int filterKeyCounter = this.getNextDsKeyCounter();
            String key = new String(FILTER_KEY_PRIFIX + filterKeyCounter);
            Long val = new Long(filterKeyCounter);
            Set rootRegions = CacheHelper.getCache().rootRegions();
            int x = rand.nextInt(100);
            if (x < 50) {
                for (Region aRegion : rootRegions) {
                    logger.info("doOpsForEventFilter: doing put on " + aRegion.getFullPath() + " with key " + key + " => " + val);
                    Object old = aRegion.put((Object)key, (Object)val);
                    logger.info("doOpsForEventFilter: done put on " + aRegion.getFullPath() + " with key " + key + " => " + val + ", old value=" + old);
                }
                continue;
            }
            for (Region aRegion : rootRegions) {
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put(key, val);
                logger.info("doOpsForEventFilter: doing putAll on " + aRegion.getFullPath() + " with map " + map);
                aRegion.putAll(map);
                logger.info("doOpsForEventFilter: done putAll on " + aRegion.getFullPath() + " with map " + map);
            }
        }
        MasterController.sleepForMs(keysPerTask * 1000);
    }

    public void validateDoOpsForEventFilter() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region r : rootRegions) {
            logger.info("validateDoOpsForEventFilter: validating region " + r.getFullPath());
            StringBuilder str = new StringBuilder();
            TreeSet extraFilterKeys = new TreeSet(r.keySet());
            int dsKeyCounter = this.getDsKeyCounter();
            int totalDs = this.distributedSystems.size();
            int dsId = DistributedSystemHelper.getDistributedSystemId();
            if (dsId == -1) {
                dsId = EdgeHelper.toWanSite(RemoteTestModule.getMyClientName());
            }
            while (dsKeyCounter >= dsId) {
                String key = new String(FILTER_KEY_PRIFIX + dsKeyCounter);
                Long expVal = new Long(dsKeyCounter);
                extraFilterKeys.remove(key);
                if (r.containsKey((Object)key)) {
                    Object val = r.get((Object)key);
                    if (val == null || !val.equals(expVal)) {
                        str.append("  for key " + key + ", expected " + expVal + ", found " + val + "\n");
                    }
                } else {
                    str.append("  for key " + key + ", expected " + expVal + ", but key does not exists on region \n");
                }
                dsKeyCounter -= totalDs;
            }
            Iterator i = extraFilterKeys.iterator();
            HashSet<String> temp = new HashSet<String>();
            while (i.hasNext()) {
                String k = (String)i.next();
                if (k.contains(FILTER_KEY_PRIFIX)) continue;
                temp.add(k);
            }
            extraFilterKeys.removeAll(temp);
            if (extraFilterKeys.size() > 0) {
                str.append("Found " + extraFilterKeys.size() + " unexpected filter keys in region " + r.getFullPath() + " : " + extraFilterKeys + "\n");
            }
            if (str.length() <= 0) continue;
            throw new TestException("Error found in validating region " + r.getFullPath() + "\n" + str.toString());
        }
    }

    public void validateTranportFilterData() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region r : rootRegions) {
            logger.info("validateTranportFilterData: validating transport filter data on region " + r.getFullPath());
            StringBuilder str = new StringBuilder();
            for (String key : r.keySet()) {
                Object value = r.get((Object)key);
                if (value == null) {
                    str.append(" for key " + key + ", expected value but found null");
                    continue;
                }
                if (value instanceof ValueHolder) {
                    ValueHolder v = (ValueHolder)value;
                    Object extraObj = v.getExtraObject();
                    if (!(extraObj instanceof MyExtraObject)) continue;
                    str.append("Tranport filter are not applied correctly at receivers.  for " + key + " with value " + v + ". Filters not applied are:" + ((MyExtraObject)extraObj).getTranFilterList() + "\n");
                    continue;
                }
                str.append(" Possible test issue, for key " + key + ", expected value to be instance of ValueHolder, but found instance of " + value.getClass().getName() + "\n");
            }
            if (str.length() > 0) {
                throw new TestException("In validating transport filters on region " + r.getFullPath() + " " + str.toString());
            }
            logger.info("validateTranportFilterData: done vaidating transport filter data on region " + r.getFullPath());
        }
    }

    public void removeEventFilterKeys() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region r : rootRegions) {
            logger.info("removeEventFilterKeys: removing all filter keys from region " + r.getFullPath());
            for (String k : r.keySet()) {
                if (!k.contains(FILTER_KEY_PRIFIX)) continue;
                logger.info("removeEventFilterKeys: removing filter key " + k + " from region " + r.getFullPath());
                r.remove((Object)k);
            }
        }
    }

    private int getNextDsKeyCounter() {
        WANBlackboard bb = WANBlackboard.getInstance();
        Integer dsid = DistributedSystemHelper.getDistributedSystemId();
        if (dsid.equals(new Integer(-1))) {
            dsid = new Integer(EdgeHelper.toWanSite(RemoteTestModule.getMyClientName()));
        }
        bb.getSharedLock().lock();
        String key = "DsKeyNum_" + dsid;
        Integer uniqueIndex = (Integer)bb.getSharedMap().get(key);
        uniqueIndex = uniqueIndex == null ? dsid : new Integer(uniqueIndex + this.distributedSystems.size());
        bb.getSharedMap().put(key, uniqueIndex);
        bb.getSharedLock().unlock();
        return uniqueIndex;
    }

    private int getDsKeyCounter() {
        WANBlackboard bb = WANBlackboard.getInstance();
        Integer dsid = DistributedSystemHelper.getDistributedSystemId();
        if (dsid.equals(new Integer(-1))) {
            dsid = new Integer(EdgeHelper.toWanSite(RemoteTestModule.getMyClientName()));
        }
        String key = "DsKeyNum_" + dsid;
        Integer uniqueIndex = (Integer)bb.getSharedMap().get(key);
        return uniqueIndex == null ? -1 : uniqueIndex;
    }

    private void setDistributedSystems() {
        Map<String, GemFireDescription> gdm = TestConfig.getInstance().getGemFireDescriptions();
        Iterator<String> itr = gdm.keySet().iterator();
        while (itr.hasNext()) {
            GemFireDescription gfd = gdm.get(itr.next());
            if (gfd.getDistributedSystem().contains("loner") || this.distributedSystems.containsKey(gfd.getDistributedSystem())) continue;
            this.distributedSystems.put(gfd.getDistributedSystem(), gfd.getDistributedSystemId());
        }
    }

    static {
        logger = Log.getLogWriter();
        rand = new GsRandom();
        eventFilterValiatorCoordinator = null;
        tranportFilterDataValidatorCoordinator = null;
    }
}

