/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import hydra.CacheHelper;
import hydra.GatewaySenderHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.TestTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import newWan.WANBlackboard;
import newWan.WANOperationsClientBB;
import newWan.WANOperationsClientPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationCountersBB;
import util.OperationsClient;
import util.OperationsClientPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class WANOperationsClient
extends OperationsClient {
    public static String SNAPSHOT_FOR_UNIQUE_KEY_PREFIX = "SnapshotForUniqueKey_";
    public static String SNAPSHOT_FOR_REGION_PREFIX = "SnapshotForRegion_";
    public static String SNAPSHOT_VM_FOR_REGION = "SnapshotVMForRegion_";
    protected boolean useUniqueKeyPerThread;
    protected int maxKeys;
    protected int keyAllocation;
    protected int wanSiteId;
    protected int numWanSites;
    public WANOperationsClientBB bb;
    static LogWriter logger = Log.getLogWriter();
    private Object senderLock = new Object();

    public WANOperationsClient() {
        this.initialize();
    }

    public void initialize() {
        super.initializeOperationsClient();
        this.useUniqueKeyPerThread = TestConfig.tab().booleanAt(WANOperationsClientPrms.useUniqueKeyPerThread, false);
        this.maxKeys = WANOperationsClientPrms.getMaxKeys();
        this.keyAllocation = WANOperationsClientPrms.getKeyAllocation();
        this.wanSiteId = this.getWanId();
        String sWanSites = TestConfig.getInstance().getSystemProperty("wanSites");
        this.numWanSites = sWanSites != null ? Integer.parseInt(sWanSites) : 0;
        this.bb = WANOperationsClientBB.getBB();
        logger.info("maxKeys=" + this.maxKeys + ", keyAllocation=" + WANOperationsClientPrms.keyAllocationToString(this.keyAllocation) + ", numWanSites=" + this.numWanSites + ", wanSiteId=" + this.wanSiteId + ", useUniqueKeyPerThread=" + this.useUniqueKeyPerThread);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doEntryOperations(Region aRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void finishTransaction() {
        int n = 0;
        int commitPercentage = OperationsClientPrms.getCommitPercentage();
        n = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (n <= commitPercentage) {
            try {
                TxHelper.commit();
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
            }
            catch (TransactionInDoubtException e) {
                Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
            }
            catch (CommitConflictException e) {
                Log.getLogWriter().info("CommitConflictException " + (Object)((Object)e) + " expected, continuing test");
            }
            catch (TransactionDataRebalancedException e) {
                Log.getLogWriter().info("CommitConflictException " + (Object)((Object)e) + " expected, continuing test");
            }
        } else {
            TxHelper.rollback();
        }
    }

    @Override
    protected void addEntry(Region aRegion) {
        Object key = this.getNewKey();
        BaseValueHolder anObj = this.getValueForKey(key);
        String callback = "Create event originated in pid " + ProcessMgr.getProcessId();
        Object val = aRegion.get(key);
        if (val == null) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
        if (this.useUniqueKeyPerThread) {
            this.updateBlackboardSnapshot(aRegion, key, anObj, false);
        }
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Object key = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 25) {
            key = this.getExistingKey(aRegion);
        }
        if (key == null) {
            key = this.getNewKey();
        }
        BaseValueHolder anObj = this.getValueForKey(key);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath() + ".");
        }
        Object prevVal = null;
        prevVal = aRegion.putIfAbsent(key, (Object)anObj);
        if (prevVal == null && this.useUniqueKeyPerThread) {
            this.updateBlackboardSnapshot(aRegion, key, anObj, false);
        }
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: done putIfAbsent for key " + key + " on region " + aRegion.getName() + ", success=" + (prevVal == null));
        }
    }

    @Override
    protected void putAll(Region r) {
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(WANOperationsClientPrms.numPutAllNewKeys, "1");
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = this.upperThreshold - beforeSize;
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(WANOperationsClientPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(WANOperationsClientPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKey();
            BaseValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(WANOperationsClientPrms.numPutAllExistingKeys, 1);
        List keyList = this.getExistingKeys(r, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object e = keyList.get(i);
                BaseValueHolder anObj = this.getUpdateObject(r, e);
                mapToPut.put(e, anObj);
                existingKeys.append(e + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object k : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + k + ", value " + TestHelper.toString(mapToPut.get(k)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
        if (this.useUniqueKeyPerThread) {
            for (Object object : mapToPut.entrySet()) {
                Map.Entry e = (Map.Entry)object;
                this.updateBlackboardSnapshot(r, e.getKey(), e.getValue(), false);
            }
        }
    }

    @Override
    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        try {
            String callback = "Destroy event originated in pid " + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                    aRegion.destroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done destroying key " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: destroying key " + key);
                    aRegion.destroy(key);
                    Log.getLogWriter().info("destroyEntry: done destroying key " + key);
                }
                if (this.useUniqueKeyPerThread) {
                    this.updateBlackboardSnapshot(aRegion, key, null, true);
                }
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    @Override
    protected void remove(Region aRegion) {
        boolean removed = false;
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("remove: No key in region " + aRegion.getFullPath());
            return;
        }
        try {
            Object oldVal = aRegion.get(key);
            Log.getLogWriter().info("remove: removing key " + key + " with previous value " + oldVal);
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (randInt <= 25) {
                oldVal = this.getUpdateObject(aRegion, key);
                Log.getLogWriter().info("remove: modifying the value for key " + key + " with value=" + oldVal);
            }
            removed = aRegion.remove(key, oldVal);
            Log.getLogWriter().info("remove: Done remove key " + key + ", success=" + removed + " oldValue=" + oldVal);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (removed && this.useUniqueKeyPerThread) {
            this.updateBlackboardSnapshot(aRegion, key, null, true);
        }
    }

    @Override
    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        BaseValueHolder anObj = this.getUpdateObject(aRegion, key);
        String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update) for key " + key);
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("Done with call to put (update) for key " + key);
        }
        if (this.useUniqueKeyPerThread) {
            this.updateBlackboardSnapshot(aRegion, key, anObj, false);
        }
    }

    @Override
    protected void replace(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("replace: No names in region");
            return;
        }
        this.replace(aRegion, key);
    }

    @Override
    protected void replace(Region aRegion, Object name) {
        Object anObj = null;
        Object prevVal = null;
        boolean replaced = false;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BaseValueHolder newObj = this.getUpdateObject(aRegion, name);
        boolean isOldObjectUpdated = false;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                anObj = this.getUpdateObject(aRegion, name);
                isOldObjectUpdated = true;
            }
            Log.getLogWriter().info("replace: replacing key " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", isOldObjectUpdated=" + isOldObjectUpdated);
            replaced = aRegion.replace(name, anObj, (Object)newObj);
        } else {
            boolean isNewKey = false;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                name = this.getNewKey();
                isNewKey = true;
            }
            Log.getLogWriter().info("replace: replacing key " + name + " (isNewKey=" + isNewKey + ") with " + TestHelper.toString(newObj) + ".");
            prevVal = aRegion.replace(name, (Object)newObj);
            if (prevVal != null) {
                replaced = true;
            }
        }
        if (replaced && this.useUniqueKeyPerThread) {
            this.updateBlackboardSnapshot(aRegion, name, newObj, false);
        }
        Log.getLogWriter().info("Done with call to replace for key " + name + ", success=" + replaced);
    }

    @Override
    protected Object getNewKey() {
        if (this.useUniqueKeyPerThread) {
            return NameFactory.getObjectNameForCounter(this.getNextUniqueKeyCounter(-1));
        }
        if (this.keyAllocation == 0) {
            return NameFactory.getObjectNameForCounter(this.getNextUniqueKeyCounter(-1));
        }
        if (this.keyAllocation == 1) {
            return NameFactory.getObjectNameForCounter(this.getNextUniqueKeyCounter(this.maxKeys));
        }
        if (this.keyAllocation == 2) {
            int nextKeyCounter;
            String mapKey = "WanId_" + this.wanSiteId;
            Object currentCnt = this.bb.getSharedMap().get(mapKey);
            int n = nextKeyCounter = currentCnt == null ? this.wanSiteId : (Integer)currentCnt + this.numWanSites;
            if (nextKeyCounter > this.maxKeys) {
                nextKeyCounter = this.wanSiteId;
            }
            this.bb.getSharedMap().put(mapKey, new Integer(nextKeyCounter));
            return NameFactory.getObjectNameForCounter(nextKeyCounter);
        }
        if (this.keyAllocation == 3) {
            return NameFactory.getNextPositiveObjectName();
        }
        if (this.keyAllocation == 4) {
            return NameFactory.getNextPositiveObjectNameInLimit(this.maxKeys);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    @Override
    protected Object getExistingKey(Region aRegion) {
        ArrayList keyList = new ArrayList();
        keyList.addAll(aRegion.keySet());
        if (keyList.size() == 0) {
            return null;
        }
        GsRandom rand = TestConfig.tab().getRandGen();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        while (keyList.size() != 0) {
            int randInt = rand.nextInt(0, keyList.size() - 1);
            Object key = keyList.get(randInt);
            long keyIndex = NameFactory.getCounterForName(key);
            if (this.useUniqueKeyPerThread) {
                if (keyIndex % (long)TestHelper.getNumThreads() == (long)myTid) {
                    return key;
                }
            } else if (this.keyAllocation == 0 || this.keyAllocation == 1) {
                if (keyIndex % (long)TestHelper.getNumThreads() == (long)myTid) {
                    return key;
                }
            } else if (this.keyAllocation == 2) {
                if (keyIndex % (long)this.numWanSites == (long)this.wanSiteId) {
                    return key;
                }
            } else {
                return key;
            }
            keyList.remove(randInt);
        }
        return null;
    }

    @Override
    protected List getExistingKeys(Region aRegion, int numKeysToGet) {
        Log.getLogWriter().info("Trying to get " + numKeysToGet + " existing keys from region " + aRegion.getFullPath());
        ArrayList keyListToReturn = new ArrayList();
        ArrayList keyList = new ArrayList();
        keyList.addAll(aRegion.keySet());
        if (keyList.size() == 0) {
            return keyListToReturn;
        }
        GsRandom rand = TestConfig.tab().getRandGen();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        while (keyList.size() != 0 && keyListToReturn.size() >= numKeysToGet) {
            int randInt = rand.nextInt(0, keyList.size() - 1);
            Object key = keyList.get(randInt);
            long keyIndex = NameFactory.getCounterForName(key);
            if (this.useUniqueKeyPerThread) {
                if (keyIndex % (long)TestHelper.getNumThreads() == (long)myTid) {
                    keyListToReturn.add(key);
                }
            } else if (this.keyAllocation == 0 || this.keyAllocation == 1) {
                if (keyIndex % (long)TestHelper.getNumThreads() == (long)myTid) {
                    keyListToReturn.add(key);
                }
            } else if (this.keyAllocation == 2) {
                if (keyIndex % (long)this.numWanSites == (long)this.wanSiteId) {
                    keyListToReturn.add(key);
                }
            } else {
                keyListToReturn.add(key);
            }
            keyList.remove(randInt);
        }
        return keyListToReturn;
    }

    protected int getNextUniqueKeyCounter(int limit) {
        WANOperationsClientBB bb = WANOperationsClientBB.getBB();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        String key = "UniqueKeyNum_" + tid;
        Integer uniqueIndex = (Integer)bb.getSharedMap().get(key);
        if (uniqueIndex == null) {
            uniqueIndex = new Integer(tid);
            bb.getSharedCounters().zero(WANOperationsClientBB.NumKeys);
        } else {
            uniqueIndex = new Integer(uniqueIndex + numThreads);
            long keycount = bb.getSharedCounters().read(WANOperationsClientBB.NumKeys);
            if (limit != -1 && keycount >= (long)limit) {
                uniqueIndex = new Integer(tid);
                bb.getSharedCounters().zero(WANOperationsClientBB.NumKeys);
            }
        }
        bb.getSharedMap().put(key, uniqueIndex);
        bb.getSharedCounters().increment(WANOperationsClientBB.NumKeys);
        return uniqueIndex;
    }

    public synchronized Map getBBSnapshotForUniqueKeyMap(Region aRegion) {
        String snapshotKey = SNAPSHOT_FOR_UNIQUE_KEY_PREFIX + aRegion.getFullPath();
        HashMap snapshotMap = (HashMap)OperationCountersBB.getBB().getSharedMap().get(snapshotKey);
        if (snapshotMap == null) {
            snapshotMap = new HashMap();
            OperationCountersBB.getBB().getSharedMap().put(snapshotKey, snapshotMap);
        }
        return snapshotMap;
    }

    public synchronized Map getBBSnapshot(Region aRegion) {
        String snapshotKey = SNAPSHOT_FOR_REGION_PREFIX + aRegion.getFullPath();
        HashMap snapshotMap = (HashMap)OperationCountersBB.getBB().getSharedMap().get(snapshotKey);
        if (snapshotMap == null) {
            snapshotMap = new HashMap();
            OperationCountersBB.getBB().getSharedMap().put(snapshotKey, snapshotMap);
        }
        return snapshotMap;
    }

    public synchronized void updateBlackboardSnapshot(Region aRegion, Object key, Object value, boolean isRemove) {
        OperationCountersBB.getBB().getSharedLock().lock();
        Map smap = this.getBBSnapshotForUniqueKeyMap(aRegion);
        if (isRemove) {
            smap.remove(key);
        } else {
            smap.put(key, value);
        }
        String snapshotKey = SNAPSHOT_FOR_UNIQUE_KEY_PREFIX + aRegion.getFullPath();
        OperationCountersBB.getBB().getSharedMap().put(snapshotKey, smap);
        OperationCountersBB.getBB().getSharedLock().unlock();
    }

    public void writeRegionSnapshotToBB() {
        int pid = RemoteTestModule.getMyPid();
        String clientName = RemoteTestModule.getMyClientName() + "(pid=" + RemoteTestModule.getMyPid() + ")";
        Region aRegion2 = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        String snapshotKey = null;
        for (Region aRegion2 : rootRegions) {
            snapshotKey = SNAPSHOT_FOR_REGION_PREFIX + aRegion2.getFullPath();
            String snapshotVmKey = SNAPSHOT_VM_FOR_REGION + aRegion2.getFullPath();
            HashMap smap = new HashMap();
            for (Object key : aRegion2.keySet()) {
                smap.put(key, aRegion2.get(key));
            }
            OperationCountersBB.getBB().getSharedLock().lock();
            Log.getLogWriter().info("Writing snapshot to BB : " + snapshotKey);
            OperationCountersBB.getBB().getSharedMap().put(snapshotKey, smap);
            OperationCountersBB.getBB().getSharedMap().put(snapshotVmKey, clientName);
            Log.getLogWriter().info("Finished writing region snapshot to BB.");
            OperationCountersBB.getBB().getSharedLock().unlock();
        }
    }

    public void verifyRegionContents(Region aRegion, Map expected) {
        String tmpStr;
        String snapshotVmKey = SNAPSHOT_VM_FOR_REGION + aRegion.getFullPath();
        Object snapshotvm = OperationCountersBB.getBB().getSharedMap().get(snapshotVmKey);
        String snapshotVmStr = snapshotvm != null ? "Snapshot written by " + snapshotvm + ". " : "";
        Log.getLogWriter().info("Verifying contents of " + aRegion.getFullPath() + ", size is " + aRegion.size() + ", " + snapshotVmStr);
        HashSet regionKeySet = new HashSet(aRegion.keySet());
        int regionSize = aRegion.size();
        int regionKeySetSize = regionKeySet.size();
        Log.getLogWriter().info("regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        if (regionSize != regionKeySetSize) {
            throw new TestException("Inconsistent sizes: regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        }
        HashSet snapshotKeySet = new HashSet(expected.keySet());
        HashSet unexpectedInRegion = new HashSet(regionKeySet);
        HashSet missingInRegion = new HashSet(snapshotKeySet);
        unexpectedInRegion.removeAll(snapshotKeySet);
        missingInRegion.removeAll(regionKeySet);
        Log.getLogWriter().info("Found " + unexpectedInRegion.size() + " unexpected entries and " + missingInRegion.size() + " missing entries");
        StringBuffer aStr = new StringBuffer();
        if (aRegion.size() != expected.size()) {
            aStr.append("Expected " + aRegion.getFullPath() + " to be size " + expected.size() + ", but it is size " + aRegion.size());
            Log.getLogWriter().info(aStr.toString());
        }
        if (unexpectedInRegion.size() > 0) {
            tmpStr = "Found the following " + unexpectedInRegion.size() + " unexpected keys in " + aRegion.getFullPath() + ": " + unexpectedInRegion;
            Log.getLogWriter().info(tmpStr.toString());
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        if (missingInRegion.size() > 0) {
            tmpStr = "The following " + missingInRegion.size() + " keys were missing from " + aRegion.getFullPath() + ": " + missingInRegion;
            Log.getLogWriter().info(tmpStr);
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        for (Object key : aRegion.keySet()) {
            ValueHolder objInRegion = (ValueHolder)aRegion.get(key);
            ValueHolder objInSnapshot = (ValueHolder)expected.get(key);
            if (objInRegion == null) {
                if (objInSnapshot == null) continue;
                aStr.append("For key " + key + " expected " + objInSnapshot + ", found " + objInRegion + "\n");
                continue;
            }
            if (objInRegion.equals(objInSnapshot)) continue;
            aStr.append("For key " + key + ", expected " + objInSnapshot + ", found " + objInRegion + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(snapshotVmStr + aStr.toString());
        }
        Log.getLogWriter().info("Done verifying contents of " + aRegion.getFullPath() + ", size is " + aRegion.size());
    }

    public void doHASenderOperationsAndVerify() {
        Log.getLogWriter().info("In doHASenderOperationsAndVerify");
        long cycleCounter = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.NumCycle);
        int numThreadsForTask = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long numDoingOps = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.NumStartedDoingOps);
        if (numDoingOps >= (long)(numThreadsForTask - 1)) {
            Log.getLogWriter().info("Returning from doHASenderOperationsAndVerify with noops as WANOperationsClientBB.NumStartedDoingOps reached to " + numDoingOps);
            MasterController.sleepForMs(10000);
            return;
        }
        WANOperationsClientBB.getBB().getSharedCounters().increment(WANOperationsClientBB.NumStartedDoingOps);
        logger.info("doHASenderOperationsAndVerify: started doing operations counter is " + numDoingOps + " in current cycle, cycleCounter=" + cycleCounter);
        this.doSenderOperations();
        this.verifySenderOperations();
        long numDoneOps = WANOperationsClientBB.getBB().getSharedCounters().incrementAndRead(WANOperationsClientBB.NumFinishedDoingOps);
        logger.info("doHASenderOperationsAndVerify: finished doing operation counter is " + numDoneOps + " in current cycle, cycleCounter=" + cycleCounter);
        Log.getLogWriter().info("Done doHASenderOperationsAndVerify");
    }

    public void doSenderOperations() {
        Log.getLogWriter().info("Starting task doSenderOperations.");
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
            for (GatewaySender sender : senders) {
                this.doSenderOperation(sender);
                ++numOps;
            }
            Log.getLogWriter().info("Completed op " + numOps + " for doSenderOperations task");
            MasterController.sleepForMs(5000);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSenderOperation(GatewaySender sender) {
        logger.info("In doSenderOperation on sender " + sender.getId());
        SenderOperation ss = this.getSenderOperation(sender);
        Object object = this.senderLock;
        synchronized (object) {
            switch (ss) {
                case START: {
                    try {
                        logger.info("doSenderOperation: starting sender " + sender.getId());
                        sender.start();
                        logger.info("doSenderOperation: started sender " + sender.getId());
                        this.updateSenderStateToBB(sender);
                        break;
                    }
                    catch (Exception e) {
                        String s = "Problem starting gateway sender" + GatewaySenderHelper.gatewaySenderToString(sender);
                        throw new HydraRuntimeException(s, e);
                    }
                }
                case STOP: {
                    logger.info("doSenderOperation: stopping sender " + sender.getId());
                    sender.stop();
                    logger.info("doSenderOperation: stopped sender " + sender.getId());
                    this.updateSenderStateToBB(sender);
                    break;
                }
                case PAUSE: {
                    logger.info("doSenderOperation: pausing sender " + sender.getId());
                    sender.pause();
                    logger.info("doSenderOperation: paused sender " + sender.getId());
                    this.updateSenderStateToBB(sender);
                    break;
                }
                case RESUME: {
                    logger.info("doSenderOperation: resuming sender " + sender.getId());
                    sender.resume();
                    logger.info("doSenderOperation: resumed sender " + sender.getId());
                    this.updateSenderStateToBB(sender);
                    break;
                }
                default: {
                    throw new TestException("Possible test issue: invalid state for sender " + sender.getId() + " status is " + (Object)((Object)ss));
                }
            }
        }
    }

    public SenderOperation getSenderOperation(GatewaySender sender) {
        SenderOperation op = null;
        boolean foundOp = false;
        while (!(foundOp = (op = this.getSenderOperation(WANOperationsClientPrms.senderOperations)).equals((Object)SenderOperation.STOP) ? this.isStopPossible(sender) : true)) {
        }
        return op;
    }

    protected SenderOperation getSenderOperation(Long whichPrm) {
        SenderOperation op = null;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("start")) {
            op = SenderOperation.START;
        } else if (operation.equals("stop")) {
            op = SenderOperation.STOP;
        } else if (operation.equals("pause")) {
            op = SenderOperation.PAUSE;
        } else if (operation.equals("resume")) {
            op = SenderOperation.RESUME;
        } else {
            throw new TestException("Unknown sender operation: " + operation + ". Allowed operations are 'start', 'stop', 'pause' and 'resume'");
        }
        return op;
    }

    public void updateSenderStateToBB(GatewaySender sender) {
        WANBlackboard bb = WANBlackboard.getInstance();
        String senderId = this.getSenderLocalVMId(sender);
        if (sender.isRunning()) {
            if (sender.isPaused()) {
                bb.getSharedMap().put(senderId, (Object)SenderState.SENDER_PAUSED);
            } else {
                bb.getSharedMap().put(senderId, (Object)SenderState.SENDER_RUNNING);
            }
        } else {
            bb.getSharedMap().put(senderId, (Object)SenderState.SENDER_STOPPED);
        }
    }

    protected boolean isStopPossible(GatewaySender sender) {
        String sid = sender.getId();
        String localSid = this.getSenderLocalVMId(sender);
        boolean isStopOk = false;
        WANBlackboard bb = WANBlackboard.getInstance();
        Set mapKeys = bb.getSharedMap().getMap().keySet();
        for (String key : mapKeys) {
            Object senderState;
            if (key.equals(localSid) || !key.contains(sid) || !((senderState = bb.getSharedMap().get(key)) instanceof SenderState) || ((SenderState)((Object)senderState)).equals((Object)SenderState.SENDER_STOPPED)) continue;
            isStopOk = true;
        }
        return isStopOk;
    }

    protected String getSenderLocalVMId(GatewaySender sender) {
        return "SenderKey_vm_" + RemoteTestModule.getMyVmid() + "_" + sender.getId();
    }

    public void verifySenderOperations() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        logger.info("In verify sender operation on senders " + senders);
        for (GatewaySender sender : senders) {
            this.verifySenderOperation(sender);
        }
        logger.info("Done verify sender operation on senders " + senders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifySenderOperation(GatewaySender sender) {
        logger.info("verifySenderOperation on sender " + sender.getId());
        boolean verifyOps = true;
        Object object = this.senderLock;
        synchronized (object) {
            SenderState state = this.getSenderState(sender);
            logger.info("verifySenderOperation on sender " + sender.getId() + " found state " + (Object)((Object)state));
            switch (state) {
                case SENDER_RUNNING: {
                    if (sender.isRunning()) {
                        if (!sender.isPaused()) break;
                        throw new TestException("Expected sender status to be running and not paused, found running but paused for sender " + GatewaySenderHelper.gatewaySenderToString(sender));
                    }
                    throw new TestException("Expected sender status to be running, found not-running for sender " + GatewaySenderHelper.gatewaySenderToString(sender));
                }
                case SENDER_PAUSED: {
                    if (sender.isRunning() && sender.isPaused()) break;
                    throw new TestException("Expected sender status to be running and paused, found isRunning=" + sender.isRunning() + ", isPaused=" + sender.isPaused() + " for sender " + GatewaySenderHelper.gatewaySenderToString(sender));
                }
                case SENDER_STOPPED: {
                    if (!sender.isRunning()) break;
                    throw new TestException("Expected sender status to be stopped, but found running as isRunning=" + sender.isRunning() + ", isPaused=" + sender.isPaused() + " for sender " + GatewaySenderHelper.gatewaySenderToString(sender));
                }
                default: {
                    throw new TestException("Possible test issue: invalid state for sender " + sender.getId() + ", status is " + (Object)((Object)state));
                }
            }
        }
    }

    protected SenderState getSenderState(GatewaySender sender) {
        WANBlackboard bb = WANBlackboard.getInstance();
        Object s = bb.getSharedMap().get(this.getSenderLocalVMId(sender));
        if (s == null) {
            throw new TestException("Possible test issue. Expected sender state in blackboard for sender " + sender.getId() + ", found state as " + s);
        }
        return (SenderState)((Object)s);
    }

    protected int tid() {
        return RemoteTestModule.getCurrentThread().getThreadId();
    }

    protected int tgid() {
        return RemoteTestModule.getCurrentThread().getThreadGroupId();
    }

    protected int ttgid() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        int id = task.getTaskThreadGroupId(tgname, this.tgid());
        return id;
    }

    protected int numThreads() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        return task.getTotalThreads();
    }

    protected int getWanId() {
        String clientName = RemoteTestModule.getMyClientName();
        int lIndex = clientName.lastIndexOf("_");
        int fIndex = clientName.substring(0, lIndex).lastIndexOf("_");
        String site = clientName.substring(fIndex + 1, lIndex);
        try {
            return Integer.parseInt(site);
        }
        catch (NumberFormatException e) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new HydraRuntimeException(s, e);
        }
    }

    public void checkForTermicationCondition() {
        long opsCounter;
        int termMethod = WANOperationsClientPrms.getTaskTerminationMethod();
        int termthreshold = WANOperationsClientPrms.getTaskTerminatorThreshold();
        if (termMethod == 1) {
            long numEventResolved = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.WanEventResolved);
            if (numEventResolved >= (long)termthreshold) {
                WANOperationsClientBB.getBB().getSharedMap().put(WANOperationsClientBB.IS_TASK_SCHEDULING_STOPPED, new Boolean(true));
                throw new StopSchedulingOrder("Time to stop as min number of WAN event resolved reached. WanEventResolved=" + numEventResolved);
            }
        } else if (termMethod == 0 && (opsCounter = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.operation_counter)) >= (long)termthreshold) {
            WANOperationsClientBB.getBB().getSharedMap().put(WANOperationsClientBB.IS_TASK_SCHEDULING_STOPPED, new Boolean(true));
            throw new StopSchedulingOrder("Time to stop as max number of operations reached. Operations=" + opsCounter);
        }
    }

    public static enum SenderOperation {
        START,
        STOP,
        PAUSE,
        RESUME;

    }

    public static enum SenderState {
        SENDER_RUNNING,
        SENDER_STOPPED,
        SENDER_PAUSED;

    }
}

