/*
 * Decompiled with CFR 0.152.
 */
package nbsTests;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import durableClients.DurableClientsBB;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hct.BBoard;
import hct.HctPrms;
import hct.InterestPolicyTest;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.BitSet;
import java.util.HashMap;
import nbsTests.EventCounterListener;
import nbsTests.NBSTestBB;
import parReg.ParRegBB;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class NBSTest
extends InterestPolicyTest {
    public static final String VM_REG_INTEREST = "Vm Register Interest";
    public static final String REG_INT_ALLKEYS = "Register Interest All Keys";
    public static final String REG_INT_LIST = "Register Interest List";
    public static final String REG_INT_SINGLE_KEY = "Register Interest Single Key";
    public static final String REG_INT_REGEX = "Register Interest Regex";
    private boolean useTransactions = false;

    public static void StartTask_initialize() {
        InterestPolicyTest.StartTask_initialize();
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new NBSTest();
            ((NBSTest)testInstance).initInstance();
            ((NBSTest)testInstance).readyForEvents();
        }
    }

    protected void readyForEvents() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            CacheHelper.getCache().readyForEvents();
        }
    }

    public static synchronized void HydraTask_validateClientEventsForOnClients() {
        ((NBSTest)testInstance).validateClientEventsForOnClients();
    }

    public static synchronized void HydraTask_validateClientEventsForOffClients() {
        ((NBSTest)testInstance).validateClientEventsForOffClients();
    }

    public static void initBridgeServer() {
        if (testInstance == null) {
            testInstance = new NBSTest();
        }
        InterestPolicyTest.initBridgeServer();
    }

    public static void HydraTask_registerInterestWithTrue() throws Exception {
        int NUM_CASES = 4;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.ExecutionNumber);
        testCase = testCase % 4 + 1;
        NBSTest.registerInterest(testCase, true);
    }

    public static void HydraTask_registerInterestWithFalse() throws Exception {
        int NUM_CASES = 4;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.ExecutionNumber);
        testCase = testCase % 4 + 1;
        NBSTest.registerInterest(testCase, false);
    }

    public static void registerInterest(int testCase, boolean receiveValues) throws Exception {
        switch (testCase) {
            case 1: {
                Log.getLogWriter().info("Calling register interest : ALL_KEYS with receiveValues " + receiveValues);
                NBSTest.HydraTask_registerInterestAllKeys(receiveValues);
                InitImageBB.getBB().getSharedMap().put(VM_REG_INTEREST, REG_INT_ALLKEYS);
                break;
            }
            case 2: {
                Log.getLogWriter().info("Calling register interest : LIST with receiveValues " + receiveValues);
                NBSTest.HydraTask_registerInterestList(receiveValues);
                InitImageBB.getBB().getSharedMap().put(VM_REG_INTEREST, REG_INT_LIST);
                break;
            }
            case 3: {
                Log.getLogWriter().info("Calling register interest : SINGLE_KEY with receiveValues " + receiveValues);
                NBSTest.HydraTask_registerInterestSingle(receiveValues);
                InitImageBB.getBB().getSharedMap().put(VM_REG_INTEREST, REG_INT_SINGLE_KEY);
                break;
            }
            case 4: {
                Log.getLogWriter().info("Calling register interest : REG_EX with receiveValues " + receiveValues);
                NBSTest.HydraTask_registerInterestRegex(receiveValues);
                InitImageBB.getBB().getSharedMap().put(VM_REG_INTEREST, REG_INT_REGEX);
                break;
            }
        }
    }

    public static void HydraTask_registerInterestSingle(boolean receiveValues) throws Exception {
        NBSTest test = (NBSTest)testInstance;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        test.registerInterestSingle(false, receiveValues);
    }

    public static void HydraTask_registerInterestList(boolean receiveValues) {
        ((NBSTest)testInstance).registerInterest(keyList, receiveValues);
    }

    public static void HydraTask_registerInterestAllKeys(boolean receiveValues) {
        ((NBSTest)testInstance).registerInterest("ALL_KEYS", receiveValues);
    }

    public static void HydraTask_registerInterestRegex(boolean receiveValues) {
        ((NBSTest)testInstance).registerInterestRegex(receiveValues);
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        testInstance.doOps(availableOps);
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    @Override
    public void doOps(BitSet availableOps) {
        boolean useTransactions = InitImagePrms.useTransactions();
        while (availableOps.cardinality() != 0) {
            int whichOp = this.getOp(availableOps, operations.length);
            boolean doneWithOps = false;
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                switch (whichOp) {
                    case 7: {
                        doneWithOps = this.addNewKey();
                        break;
                    }
                    case 8: {
                        if (useTransactions) {
                            doneWithOps = true;
                            break;
                        }
                        doneWithOps = this.putAllNewKey();
                        break;
                    }
                    case 1: {
                        doneWithOps = this.invalidate();
                        break;
                    }
                    case 3: {
                        doneWithOps = this.destroy();
                        break;
                    }
                    case 5: {
                        doneWithOps = this.updateExistingKey();
                        break;
                    }
                    case 6: {
                        doneWithOps = this.get();
                        break;
                    }
                    case 2: {
                        if (useTransactions) {
                            doneWithOps = true;
                            break;
                        }
                        doneWithOps = this.localInvalidate();
                        break;
                    }
                    case 4: {
                        if (useTransactions) {
                            doneWithOps = true;
                            break;
                        }
                        doneWithOps = this.localDestroy();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " Expected with 6.5 PR Tx behavior, continuing test.");
                this.incrementFailedOpCounter(whichOp);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " Expected with 6.5 PR Tx behavior, continuing test.");
                this.incrementFailedOpCounter(whichOp);
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " Expected with 6.5 PR Tx behavior, continuing test.");
                    this.incrementFailedOpCounter(whichOp);
                }
                catch (TransactionDataRebalancedException e) {
                    if (!useTransactions) {
                        throw new TestException("Caught unexpected Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " Expected with 6.5 PR Tx behavior, continuing test.");
                    this.incrementFailedOpCounter(whichOp);
                }
                catch (TransactionInDoubtException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " Expected with 6.5 PR Tx behavior, continuing test.");
                    this.incrementFailedOpCounter(whichOp);
                }
                catch (CommitConflictException e) {
                    throw new TestException("Unexpected CommitConflictException " + TestHelper.getStackTrace(e));
                }
            }
            if (!doneWithOps) continue;
            Log.getLogWriter().info("Done with operation " + whichOp);
            availableOps.clear(whichOp);
        }
        Log.getLogWriter().info("Done in doOps");
        if (this.sleepMSAfterOps > 0) {
            try {
                Log.getLogWriter().info("Sleeping for " + this.sleepMSAfterOps + " millis to allow ops to be distributed");
                Thread.sleep(this.sleepMSAfterOps);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    private void incrementFailedOpCounter(int op) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("incrementFailedOpCounter: ");
        SharedCounters sc = NBSTestBB.getBB().getSharedCounters();
        int whichCounter = 0;
        switch (op) {
            case 7: 
            case 8: {
                whichCounter = NBSTestBB.FAILED_CREATES;
                aStr.append("ADD_NEW_KEY/PUTALL_NEW_KEY failed, incrementing NBSTestBB.FAILED_CREATES, ");
                break;
            }
            case 1: 
            case 2: {
                whichCounter = NBSTestBB.FAILED_INVALIDATES;
                aStr.append("LOCAL_INVALIDATE/INVALIDATE failed, incrementing NBSTestBB.FAILED_INVALIDATES, ");
                break;
            }
            case 3: 
            case 4: {
                whichCounter = NBSTestBB.FAILED_DESTROYS;
                aStr.append("LOCAL_DESTROY/DESTROY failed, incrementing NBSTestBB.FAILED_DESTROYS, ");
                break;
            }
            case 5: {
                whichCounter = NBSTestBB.FAILED_UPDATES;
                aStr.append("UPDATE_EXISTING_KEY failed, incrementing NBSTestBB.FAILED_UPDATES, ");
                break;
            }
        }
        if (whichCounter > 0) {
            long counter = NBSTestBB.getBB().getSharedCounters().incrementAndRead(whichCounter);
            aStr.append("New value = " + counter);
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static void HydraTask_recycleVm() {
        try {
            MasterController.sleepForMs(5000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    protected void registerInterest(Object keysOfInterest, boolean receiveValues) {
        int NUM_CASES = 3;
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        testCase = testCase % 3 + 1;
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            BBoard.getInstance().getSharedMap().put(VmDurableId, policy);
            Log.getLogWriter().info("Policy is " + policy.toString());
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            map.put("Policy", policy);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        try {
            Log.getLogWriter().info("Calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            if (!VmDurableId.equals("")) {
                Log.getLogWriter().info("Doing durable register interest");
                this.aRegion.registerInterest(keysOfInterest, policy, true, receiveValues);
            } else {
                Log.getLogWriter().info("Doing non-durable register interest");
                this.aRegion.registerInterest(keysOfInterest, policy, false, receiveValues);
            }
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Done calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void registerInterestRegex(boolean receiveValues) {
        int NUM_CASES = 3;
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        testCase = testCase % 3 + 1;
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            BBoard.getInstance().getSharedMap().put(VmDurableId, policy);
            Log.getLogWriter().info("Policy is " + policy.toString());
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            map.put("Policy", policy);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        String keysOfInterest = this.getRegex();
        try {
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            if (!VmDurableId.equals("")) {
                Log.getLogWriter().info("Doing durable register interest");
                this.aRegion.registerInterestRegex(keysOfInterest, policy, true, receiveValues);
            } else {
                Log.getLogWriter().info("Doing non-durable register interest");
                this.aRegion.registerInterestRegex(keysOfInterest, policy, false, receiveValues);
            }
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void registerInterestSingle(boolean isPartial, boolean receiveValues) throws Exception {
        int NUM_CASES = 3;
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        StringBuffer errStr = new StringBuffer();
        for (int i = 0; i < keyList.size(); ++i) {
            Object key = keyList.get(i);
            try {
                Log.getLogWriter().info("Calling registerInterest with single key of interest: " + TestHelper.toString(key) + ", policy: " + policy);
                long start = System.currentTimeMillis();
                this.aRegion.registerInterest(key, policy, false, receiveValues);
                long l = System.currentTimeMillis();
                continue;
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    protected void validateClientEventsForOnClients() {
        if (this.aRegion == null) {
            this.aRegion = RegionHelper.getRegion("InterestPolicyRegion");
        }
        EventCounterListener listener = (EventCounterListener)this.aRegion.getAttributes().getCacheListeners()[0];
        long numOfKeys = TestConfig.tab().longAt(InitImagePrms.numKeys);
        long numNewKeys = TestConfig.tab().longAt(InitImagePrms.numNewKeys);
        long expectedCreateEvents = 0L;
        long expectedInvalidateEvents = 0L;
        long expectedUpdateEvents = 0L;
        long expectedDestroyEvents = 0L;
        expectedCreateEvents = numNewKeys;
        expectedInvalidateEvents = this.keyIntervals.getNumKeys(1001);
        expectedUpdateEvents = this.keyIntervals.getNumKeys(1005);
        expectedDestroyEvents = this.keyIntervals.getNumKeys(1003);
        if (InitImagePrms.useTransactions()) {
            SharedCounters sc = NBSTestBB.getBB().getSharedCounters();
            Log.getLogWriter().info("Adjusting expected event counts based on failed creates (" + sc.read(NBSTestBB.FAILED_CREATES) + "), failed updates (" + sc.read(NBSTestBB.FAILED_UPDATES) + ") and failed destroys (" + sc.read(NBSTestBB.FAILED_DESTROYS) + ")");
            expectedCreateEvents -= sc.read(NBSTestBB.FAILED_CREATES);
            expectedUpdateEvents -= sc.read(NBSTestBB.FAILED_UPDATES);
            expectedDestroyEvents -= sc.read(NBSTestBB.FAILED_DESTROYS);
        }
        if (expectedCreateEvents != listener.getAfterCreateEvents() || expectedDestroyEvents != listener.getAfterDestroyEvents() || expectedInvalidateEvents != listener.getAfterInvalidateEvents() || expectedUpdateEvents != listener.getAfterUpdateEvents()) {
            throw new TestException("Expected events are:  afterCreateEvents=" + expectedCreateEvents + ",  afterDestroyEvents=" + expectedDestroyEvents + ",  afterUpdateEvents=" + expectedUpdateEvents + ",  afterInvalidateEvents=" + expectedInvalidateEvents + ",  but received: " + listener.getEventCountersInfo());
        }
        Log.getLogWriter().info("Got the expected events: " + listener.getEventCountersInfo());
    }

    protected void validateClientEventsForOffClients() {
        if (this.aRegion == null) {
            this.aRegion = RegionHelper.getRegion("InterestPolicyRegion");
        }
        EventCounterListener listener = (EventCounterListener)this.aRegion.getAttributes().getCacheListeners()[0];
        long numOfKeys = TestConfig.tab().longAt(InitImagePrms.numKeys);
        long numNewKeys = TestConfig.tab().longAt(InitImagePrms.numNewKeys);
        long expectedCreateEvents = 0L;
        long expectedInvalidateEvents = 0L;
        long expectedUpdateEvents = 0L;
        long expectedDestroyEvents = 0L;
        expectedInvalidateEvents = this.keyIntervals.getNumKeys(1001) + this.keyIntervals.getNumKeys(1005);
        expectedDestroyEvents = this.keyIntervals.getNumKeys(1003);
        if (InitImagePrms.useTransactions()) {
            SharedCounters sc = NBSTestBB.getBB().getSharedCounters();
            Log.getLogWriter().info("Adjusting expected event counts based on failed updates (" + sc.read(NBSTestBB.FAILED_UPDATES) + ") and failed destroys (" + sc.read(NBSTestBB.FAILED_DESTROYS) + ")");
            expectedInvalidateEvents -= sc.read(NBSTestBB.FAILED_UPDATES);
            expectedDestroyEvents -= sc.read(NBSTestBB.FAILED_DESTROYS);
        }
        if (expectedCreateEvents != listener.getAfterCreateEvents() || expectedDestroyEvents != listener.getAfterDestroyEvents() || expectedInvalidateEvents != listener.getAfterInvalidateEvents() || expectedUpdateEvents != listener.getAfterUpdateEvents()) {
            throw new TestException("Expected events are " + expectedCreateEvents + " afterCreateEvents" + expectedInvalidateEvents + " afterInvalidateEvents " + expectedUpdateEvents + " afterUpdateEvents " + expectedDestroyEvents + " afterDestroyEvents but received " + listener.getEventCountersInfo());
        }
        Log.getLogWriter().info("Got the expected events: " + listener.getEventCountersInfo());
    }
}

