/*
 * Decompiled with CFR 0.152.
 */
package mapregion;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import diskReg.DiskRegPrms;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import mapregion.MapBB;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class MapRegionTest {
    protected static final int PUT = 1;
    protected static final int PUTALL = 2;
    protected static final int CLEAR = 3;
    protected static final int REMOVE = 4;
    protected static final int INVALIDATE = 5;
    protected static final int DESTROY = 6;
    protected static final int REGION_INVALIDATE = 7;
    protected static final int REGION_DESTROY = 8;
    protected static final int LOCAL_INVALIDATE = 9;
    protected static final int LOCAL_DESTROY = 10;
    protected static final int LOCAL_REGION_INVALIDATE = 11;
    protected static final int LOCAL_REGION_DESTROY = 12;
    protected static final int SIZE = 13;
    protected static final int ISEMPTY = 14;
    protected static final int CONTAINSVALUE = 15;
    protected static final int TRANSACTIONS = 16;
    protected static final int LOCAL_CLEAR = 17;
    protected static final int PUT_PREVIOUS = 18;
    protected static final int FORCE_ROLLING = 19;
    protected static final int WRITE_TO_DISK = 20;
    protected static final int PUT_IF_ABSENT = 21;
    protected static final int CM_REMOVE = 22;
    protected static final int REPLACE = 23;
    protected static final int MIRROR_TYPE_AND_OPERATION_MISMATCH = 99;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected static MapRegionTest mapRegionTest;
    protected static boolean isCarefulValidation;
    protected static Cache cache;
    protected static volatile Region region;
    protected static RegionAttributes attr;
    private static String regionName;
    static boolean isReplicate;
    private static int endTestOnNumKeysInRegion;
    protected int lowerThreshold;
    protected int upperThreshold;
    protected static final int NO_DISK = 1001;
    protected static final int DISK_FOR_OVRFLW = 1002;
    protected static final int DISK_FOR_PERSIST = 1003;
    protected static final int DISK_FOR_OVRFLW_PERSIST = 1004;
    protected boolean persistentReplicate;
    protected int evictionLimit;
    protected int regionType = 0;

    public static synchronized void HydraTask_initialize() {
        if (mapRegionTest == null) {
            mapRegionTest = new MapRegionTest();
            mapRegionTest.initialize();
        }
    }

    protected void initialize() {
        try {
            this.initCache();
            attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            if (region == null) {
                region = RegionHelper.createRegion(regionName, attr);
                boolean tempReplicate = false;
                boolean tempPersistReplicate = false;
                tempReplicate = region.getAttributes().getDataPolicy().isReplicate();
                tempPersistReplicate = region.getAttributes().getDataPolicy().isPersistentReplicate();
                if (tempReplicate || tempPersistReplicate) {
                    isReplicate = true;
                }
            }
            this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
            isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    private synchronized void initCache() {
        try {
            cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public void createRegion() {
        try {
            region = cache.createRegion(regionName, attr);
        }
        catch (RegionExistsException reex) {
            Log.getLogWriter().info("RegionExistsException...may occur in concurrent environment. Continuing with test.");
        }
        catch (DiskAccessException dae) {
            Throwable cause = dae.getCause();
            if (cause instanceof RegionDestroyedException) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            }
            throw new TestException(TestHelper.getStackTrace(dae));
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_closetask() {
        if (mapRegionTest != null) {
            mapRegionTest.closeTask();
            mapRegionTest = null;
        }
    }

    protected void closeTask() {
        MapBB.getBB().print();
        this.closeCache();
    }

    public void closeCache() {
        try {
            CacheHelper.closeCache();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_endtask() {
        if (mapRegionTest == null) {
            mapRegionTest = new MapRegionTest();
            mapRegionTest.closeTask();
            mapRegionTest = null;
        }
    }

    public static void HydraTask_performEntryOperations() {
        endTestOnNumKeysInRegion = TestConfig.tab().intAt(DiskRegPrms.endTestOnNumKeysInRegion, -1);
        mapRegionTest.performEntryOperations();
        try {
            if (endTestOnNumKeysInRegion > -1) {
                int numKeys = region.keySet().size();
                Log.getLogWriter().info("Current numKeys is " + numKeys + ", endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
                if (numKeys >= endTestOnNumKeysInRegion) {
                    throw new StopSchedulingTaskOnClientOrder("Workload based test has " + numKeys + " keys in region, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
                }
            }
        }
        catch (CancelException cclex) {
            Log.getLogWriter().info("CancelException may occur in concurrent environment - continuing with test: + cclex");
        }
        catch (RegionDestroyedException rgdex) {
            Log.getLogWriter().info("RegionDestroyedException may occur in concurrent environment - continuing with test");
        }
    }

    protected void performEntryOperations() {
        long startTime = System.currentTimeMillis();
        this.lowerThreshold = TestConfig.tab().intAt(MapPrms.lowerThreshold, -1);
        this.upperThreshold = TestConfig.tab().intAt(MapPrms.upperThreshold, Integer.MAX_VALUE);
        Log.getLogWriter().info("lowerThreshold " + this.lowerThreshold + ", upperThreshold " + this.upperThreshold);
        do {
            int whichOp = this.getEntryOperation(MapPrms.entryOperationName, isReplicate);
            int size = 0;
            try {
                size = region.size();
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent execution mode. Continuing with test.");
                this.recoverRegion();
            }
            if (size >= this.upperThreshold) {
                whichOp = this.getEntryOperation(MapPrms.upperThresholdOperations, isReplicate);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getEntryOperation(MapPrms.lowerThresholdOperations, isReplicate);
            }
            try {
                switch (whichOp) {
                    case 1: {
                        this.putObject();
                        break;
                    }
                    case 18: {
                        this.putPrevious();
                        break;
                    }
                    case 2: {
                        this.putAllObjects();
                        break;
                    }
                    case 4: {
                        this.removeObject();
                        break;
                    }
                    case 5: {
                        this.invalidateObject();
                        break;
                    }
                    case 6: {
                        this.destroyObject();
                        break;
                    }
                    case 9: {
                        this.invalidateLocalObject();
                        break;
                    }
                    case 10: {
                        this.destroyLocalObject();
                        break;
                    }
                    case 21: {
                        this.putIfAbsent();
                        break;
                    }
                    case 22: {
                        this.concurrentMapRemove();
                        break;
                    }
                    case 23: {
                        this.replace();
                        break;
                    }
                    case 13: {
                        this.sizeOfRegion();
                        break;
                    }
                    case 14: {
                        this.isEmptyMethod();
                        break;
                    }
                    case 15: {
                        this.containsValueMethod();
                        break;
                    }
                    case 16: {
                        this.useTransactions();
                        break;
                    }
                    case 99: {
                        this.logMirrorTypeAndOperationMismatch();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
                this.recoverRegion();
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public static void HydraTask_performRegionOperations() {
        mapRegionTest.performRegionOperations();
    }

    protected void performRegionOperations() {
        try {
            int whichOp = this.getRegionOperation(MapPrms.regionOperationName, isReplicate);
            switch (whichOp) {
                case 3: {
                    this.clearRegion();
                    break;
                }
                case 7: {
                    this.invalidateRegion();
                    break;
                }
                case 8: {
                    this.destroyRegion();
                    this.recoverRegion();
                    break;
                }
                case 11: {
                    this.invalidateLocalRegion();
                    break;
                }
                case 12: {
                    this.destroyLocalRegion();
                    break;
                }
                case 17: {
                    this.localClearRegion();
                    break;
                }
                case 99: {
                    this.logMirrorTypeAndOperationMismatch();
                    break;
                }
                case 19: {
                    this.forceRollOplogs();
                    break;
                }
                case 20: {
                    this.writeToDisk();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected synchronized void recoverRegion() {
        try {
            if (region == null || region.isDestroyed()) {
                Log.getLogWriter().info("recovering region...");
                Thread.sleep(2000L);
                this.createRegion();
                Log.getLogWriter().info("region recovered...");
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected int getEntryOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("put")) {
            op = 1;
        } else if (operation.equals("putPrevious")) {
            op = 18;
        } else if (operation.equals("putAll")) {
            op = 2;
        } else if (operation.equals("remove")) {
            op = 4;
        } else if (operation.equals("invalidate")) {
            op = 5;
        } else if (operation.equals("destroy")) {
            op = 6;
        } else if (operation.equals("localInvalidate")) {
            op = 9;
        } else if (operation.equals("localDestroy")) {
            op = 10;
        } else if (operation.equalsIgnoreCase("putIfAbsent")) {
            op = 21;
        } else if (operation.equalsIgnoreCase("cmRemove")) {
            op = 22;
        } else if (operation.equalsIgnoreCase("replace")) {
            op = 23;
        } else if (operation.equals("size")) {
            op = 13;
        } else if (operation.equals("isEmpty")) {
            op = 14;
        } else if (operation.equals("containsValue")) {
            op = 15;
        } else if (operation.equals("useTransactions")) {
            op = 16;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        if (System.currentTimeMillis() - startTime > limit) {
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        }
        if (disallowLocalEntryOps && (op == 9 || op == 10)) {
            op = 99;
        }
        Log.getLogWriter().info("performing " + operation + " on region " + region);
        return op;
    }

    protected int getRegionOperation(Long whichPrm, boolean disallowLocalRegionOps) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("clear")) {
            op = 3;
        } else if (operation.equals("regionInvalidate")) {
            op = 7;
        } else if (operation.equals("regionDestroy")) {
            op = 8;
        } else if (operation.equals("localRegionInvalidate")) {
            op = 11;
        } else if (operation.equals("localRegionDestroy")) {
            op = 12;
        } else if (operation.equals("localClear")) {
            op = 17;
        } else if (operation.equals("forceRolling")) {
            op = 19;
        } else if (operation.equals("writeToDisk")) {
            op = 20;
        } else {
            throw new TestException("Unknown region operation: " + operation);
        }
        if (disallowLocalRegionOps && (op == 11 || op == 17)) {
            op = 99;
        }
        Log.getLogWriter().info("performing " + operation + " on region" + region);
        return op;
    }

    protected void putObject() {
        try {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            int putKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
            key = ObjectHelper.createName(putKeyInt);
            val = ObjectHelper.createObject(objectType, putKeyInt);
            Object got = region.get(key);
            Log.getLogWriter().info("executing put(" + key + ", " + val + ")");
            Object returnObj = region.put(key, val);
            Log.getLogWriter().info("done with put(" + key + ", " + val + ")");
            if (isCarefulValidation) {
                Object gotAfterPut;
                if (got == null) {
                    Log.getLogWriter().info("No value associated with the key: " + key + " before put operation");
                    if (returnObj != null) {
                        throw new TestException("Expected null to be returned from put, but it is " + returnObj);
                    }
                } else if (!PartitionRegionHelper.isPartitionedRegion((Region)region)) {
                    if (got.equals(returnObj)) {
                        Log.getLogWriter().info("Correct value returned on region.put(key, value)");
                    } else {
                        throw new TestException("INCORRECT value returned on region.put(key, value)");
                    }
                }
                if (!(gotAfterPut = region.get(key)).equals(val)) {
                    throw new TestException("Validation error after put operation. Expected: " + val + " got: " + gotAfterPut);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent execution mode. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putPrevious() {
        try {
            int currentKey = (int)MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
            String objectType = MapPrms.getObjectType();
            int putKeyInt = TestConfig.tab().getRandGen().nextInt(Math.max(currentKey - 1, currentKey - 50), currentKey - 1);
            Object key = ObjectHelper.createName(putKeyInt);
            Object val = ObjectHelper.createObject(objectType, TestConfig.tab().getRandGen().nextInt());
            Object got = region.get(key);
            Log.getLogWriter().info("Putting with previous key " + key + ", value " + val + ", old value is " + got);
            Log.getLogWriter().info("executing put(" + key + ", " + val + ")");
            Object returnObj = region.put(key, val);
            Log.getLogWriter().info("done with put(" + key + ", " + val + ")");
            Log.getLogWriter().info("Done putting with previous key " + key + ", value " + val + " returned value is " + returnObj);
            if (isCarefulValidation) {
                Object gotAfterPut;
                if (got == null) {
                    Log.getLogWriter().info("No value associated with the key: " + key + " before put operation");
                    if (returnObj != null) {
                        throw new TestException("Expected null to be returned from put, but it is " + returnObj);
                    }
                } else if (!PartitionRegionHelper.isPartitionedRegion((Region)region)) {
                    if (got.equals(returnObj)) {
                        Log.getLogWriter().info("Correct value returned on region.put(key, value)");
                    } else {
                        throw new TestException("INCORRECT value " + returnObj + " returned on region.put(" + key + ", " + val + "); expected " + got);
                    }
                }
                if (!(gotAfterPut = region.get(key)).equals(val)) {
                    throw new TestException("Validation error after put operation. Expected: " + val + " got: " + gotAfterPut);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent execution mode. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putAllObjects() {
        int putAllKeyInt;
        Object key = null;
        Object val = null;
        String objectType = MapPrms.getObjectType();
        TreeMap<Object, Object> m = new TreeMap<Object, Object>();
        int mapSize = 0;
        int numEntries = TestConfig.tab().getRandGen().nextInt(1, 25);
        do {
            putAllKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
            key = ObjectHelper.createName(putAllKeyInt);
            val = ObjectHelper.createObject(objectType, putAllKeyInt);
            m.put(key, val);
        } while (++mapSize < numEntries);
        try {
            Log.getLogWriter().info("executing putAll of " + ((Object)m).toString());
            region.putAll(m);
            Log.getLogWriter().info("done with putAll");
            if (isCarefulValidation) {
                key = null;
                Object got = null;
                for (int i = putAllKeyInt; i < putAllKeyInt - mapSize; ++i) {
                    key = ObjectHelper.createName(i);
                    got = region.get(key);
                    if (got != null) continue;
                    throw new TestException("get on key: " + key + " is returning null value after putAll");
                }
            }
            Log.getLogWriter().info("----performed putAll operation on region");
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment mode. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void removeObject() {
        block4: {
            try {
                Object key = null;
                int removeKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
                key = ObjectHelper.createName(removeKeyInt);
                Object got = region.get(key);
                if (got == null) break block4;
                Log.getLogWriter().info("executing Map remove(" + key + ")");
                Object returnObj = region.remove(key);
                Log.getLogWriter().info("done with Map remove(" + key + ")");
                if (!isCarefulValidation || PartitionRegionHelper.isPartitionedRegion((Region)region)) break block4;
                if (got.equals(returnObj)) {
                    Log.getLogWriter().info("Correct value returned on region.remove(key)");
                    break block4;
                }
                throw new TestException("INCORRECT value returned on region.remove(key)");
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
                this.recoverRegion();
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        }
    }

    protected void invalidateObject() {
        try {
            Object key = null;
            int invalidateKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_INVALIDATE);
            key = ObjectHelper.createName(invalidateKeyInt);
            Object got = region.get(key);
            if (got != null) {
                Log.getLogWriter().info("executing invalidate(" + key + ")");
                region.invalidate(key);
                Log.getLogWriter().info("done with invalidate(" + key + ")");
                Object gotAfterInvalidate = region.get(key);
                if (isCarefulValidation && gotAfterInvalidate != null) {
                    throw new TestException("region.get(Object key) returns NON NULL value immediately after region.invalidate(Object key)" + gotAfterInvalidate);
                }
            }
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void destroyObject() {
        try {
            Object key = null;
            int destroyKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_DESTROY);
            key = this.getExistingKey(region);
            if (key == null) {
                Log.getLogWriter().info("No keys in region, returning from destroyObject()");
                return;
            }
            Object got = region.get(key);
            int sizeBeforeDestroy = region.size();
            Log.getLogWriter().info("executing destroy(" + key + ")");
            region.destroy(key);
            Log.getLogWriter().info("done with destroy(" + key + ")");
            int sizeAfterDestroy = region.size();
            Object gotAfterDestroy = region.get(key);
            if (isCarefulValidation) {
                if (sizeAfterDestroy != sizeBeforeDestroy - 1) {
                    throw new TestException("sizeAfterDestroy=" + sizeAfterDestroy + " is NOT equal to (sizeBeforeDestroy-1)=" + (sizeBeforeDestroy - 1));
                }
                Log.getLogWriter().info("sizeAfterDestroy is equal to (sizeBeforeDestroy-1)");
                Log.getLogWriter().info("gotAfterDestroy " + gotAfterDestroy);
                if (gotAfterDestroy != null) {
                    throw new TestException("region.get(Object key) returns non null value immediately after region.destroy(Object key) " + gotAfterDestroy + " for region: " + region.getName());
                }
            }
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putIfAbsent() {
        block12: {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            boolean expectSuccess = false;
            boolean invalidatedEntry = false;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                int keyBase = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
                key = ObjectHelper.createName(keyBase);
                val = ObjectHelper.createObject(objectType, keyBase);
                expectSuccess = true;
                Log.getLogWriter().info("executing putIfAbsent(" + key + ", " + val + ") with expectSuccess = " + expectSuccess);
            } else {
                Object existingKey = this.getExistingKey(region);
                if (existingKey == null) {
                    expectSuccess = true;
                    int keyBase = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
                    key = ObjectHelper.createName(keyBase);
                    val = ObjectHelper.createObject(objectType, keyBase);
                } else {
                    key = existingKey;
                    val = ObjectHelper.createObject(objectType, TestConfig.tab().getRandGen().nextInt());
                }
                Log.getLogWriter().info("executing putIfAbsent(" + key + ", " + val + ") with expectSuccess = " + expectSuccess);
            }
            Object retVal = null;
            Object oldVal = null;
            try {
                oldVal = region.get(key);
                invalidatedEntry = false;
                if (oldVal == null && region.containsKey(key)) {
                    invalidatedEntry = true;
                }
                retVal = region.putIfAbsent(key, val);
                Log.getLogWriter().info("putIfAbsent returned " + retVal);
                if (!isCarefulValidation) break block12;
                if (expectSuccess) {
                    if (retVal != null) {
                        Log.getLogWriter().info("putIfAbsent was expected to succeed, but non-null value " + retVal + " returned");
                        throw new TestException("putIfAbsent was expected to succeed, but non-null value " + retVal + " returned" + TestHelper.getStackTrace());
                    }
                    Object valAfterPut = region.get(key);
                    if (!valAfterPut.equals(val)) {
                        Log.getLogWriter().info("get after putIfAbsent of " + val + " returned " + valAfterPut);
                        throw new TestException("get after putIfAbsent of " + val + " returned " + valAfterPut + TestHelper.getStackTrace());
                    }
                    break block12;
                }
                if (PartitionRegionHelper.isPartitionedRegion((Region)region) || oldVal == null) break block12;
                if (oldVal.equals(retVal)) {
                    Log.getLogWriter().info("Correct (previous) value returned on region.putIfAbsent(key, value)");
                    break block12;
                }
                throw new TestException("INCORRECT value " + retVal + " returned on region.putIfAbsent(" + key + ", " + val + ")");
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException may occur in both serial and concurrent execution mode. Continuing with test.");
                this.recoverRegion();
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        }
    }

    protected void concurrentMapRemove() {
        int keysPut;
        Object key = null;
        Object oldVal = null;
        boolean expectSuccess = true;
        boolean removed = false;
        String objectType = MapPrms.getObjectType();
        int keyBase = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
        if (keyBase >= (keysPut = (int)MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT))) {
            Log.getLogWriter().info("early return from remove, need new keys to work on");
            return;
        }
        key = ObjectHelper.createName(keyBase);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                if (region.containsKey(key)) {
                    oldVal = region.get(key);
                } else {
                    expectSuccess = false;
                }
            } else {
                expectSuccess = false;
                oldVal = ObjectHelper.createObject(objectType, TestConfig.tab().getRandGen().nextInt());
                Log.getLogWriter().info("substituting " + oldVal + " for existing value " + region.get(key) + " to test condition value.  expectSuccess = " + expectSuccess);
            }
            Log.getLogWriter().info("executing concurrentMap remove(" + key + ", " + oldVal + ") expectSuccess = " + expectSuccess);
            removed = region.remove(key, oldVal);
            Log.getLogWriter().info("concurrentMap remove() returned " + removed);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("concurrentMap remove caught RegionDestroyedException; may occur in both serial and concurrent environment. Continuing with test.");
            this.recoverRegion();
            return;
        }
        catch (EntryNotFoundException e) {
            if (isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught RegionDestroyedException; may occur in concurrent environment. Continuing with test.");
            return;
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        if (isCarefulValidation && (expectSuccess ? !removed : removed)) {
            throw new TestException(TestHelper.getStackTrace());
        }
    }

    protected void replace() {
        String objectType = MapPrms.getObjectType();
        Object newVal = null;
        boolean expectSuccess = true;
        boolean replaced = false;
        Object key = this.getExistingKey(region);
        if (key == null) {
            Log.getLogWriter().info("early return from replace, getExistingKey returned null");
            return;
        }
        Object oldVal = region.get(key);
        newVal = ObjectHelper.createObject(objectType, TestConfig.tab().getRandGen().nextInt());
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                if (oldVal != null && TestConfig.tab().getRandGen().nextBoolean()) {
                    expectSuccess = false;
                    Log.getLogWriter().info("executing replace(" + key + ", " + newVal + ", " + oldVal + "), expectSuccess = " + expectSuccess);
                    replaced = region.replace(key, newVal, oldVal);
                    Log.getLogWriter().info("replace returned " + replaced);
                } else {
                    Log.getLogWriter().info("executing replace(" + key + ", " + oldVal + ", " + newVal + "), expectSuccess = " + expectSuccess);
                    replaced = region.replace(key, oldVal, newVal);
                    Log.getLogWriter().info("replace returned " + replaced);
                }
            } else {
                Log.getLogWriter().info("executing replace(" + key + ", " + newVal + "), with oldVal " + oldVal + " expectSuccess = " + expectSuccess);
                Object retVal = region.replace(key, newVal);
                replaced = false;
                if (oldVal == null) {
                    if (retVal == null) {
                        replaced = true;
                    }
                } else if (retVal != null && retVal.equals(oldVal)) {
                    replaced = true;
                }
                Log.getLogWriter().info("replace returned " + retVal + " replaced = " + replaced);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("Caught RegionDestroyedException; may occur in both serial and concurrent execution mode. Continuing with test.");
            this.recoverRegion();
            return;
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        if (isCarefulValidation) {
            Object gotAfterReplace = region.get(key);
            if (expectSuccess) {
                if (!replaced) {
                    throw new TestException(TestHelper.getStackTrace());
                }
                if (!gotAfterReplace.equals(newVal)) {
                    throw new TestException("Validation error after replace operation. Expected: " + newVal + " got: " + gotAfterReplace);
                }
            } else if (replaced) {
                throw new TestException(TestHelper.getStackTrace());
            }
        }
    }

    protected Object getExistingKey(Region aRegion) {
        Object key = null;
        Object[] keyList = aRegion.keySet().toArray();
        int index = TestConfig.tab().getRandGen().nextInt(0, keyList.length - 1);
        if (index > 0) {
            key = keyList[index];
        }
        return key;
    }

    protected void clearRegion() {
        try {
            region.clear();
            int sizeAfterClear = region.size();
            if (isCarefulValidation) {
                if (sizeAfterClear != 0) {
                    throw new TestException("sizeAfterClear is NOT equal ZERO. Region holds few entries even after region.clear()");
                }
                Log.getLogWriter().info("sizeAfterClear is equal to ZERO");
                boolean isEmpty = region.isEmpty();
                if (isEmpty) {
                    Log.getLogWriter().info("region after clear operation is empty");
                } else {
                    throw new TestException("region after clear operation is NOT empty");
                }
            }
            MapBB.incrementCounter("MapBB.NUM_CLEAR", MapBB.NUM_CLEAR);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void localClearRegion() {
        try {
            region.localClear();
            int sizeAfterLocalClear = region.size();
            if (isCarefulValidation) {
                if (sizeAfterLocalClear != 0) {
                    throw new TestException("sizeAfterClear is NOT equal ZERO. Region holds few entries even after region.clear()");
                }
                Log.getLogWriter().info("sizeAfterLocalClear is equal to ZERO");
                boolean isEmpty = region.isEmpty();
                if (isEmpty) {
                    Log.getLogWriter().info("region after localClear operation is empty");
                } else {
                    throw new TestException("region after localClear operation is NOT empty");
                }
            }
            MapBB.incrementCounter("MapBB.NUM_LOCAL_CLEAR", MapBB.NUM_LOCAL_CLEAR);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void invalidateRegion() {
        try {
            region.invalidateRegion();
            if (isCarefulValidation) {
                Collection values = region.values();
                for (Object got : values) {
                    if (got == null) continue;
                    throw new TestException("region.get(Object key) returns non null value immediately after region.invalidateRegion");
                }
            }
            MapBB.incrementCounter("MapBB.NUM_REGION_INVALIDATE", MapBB.NUM_REGION_INVALIDATE);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void destroyRegion() {
        try {
            region.destroyRegion();
            if (isCarefulValidation) {
                try {
                    if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
                        region.destroyRegion();
                    } else {
                        region.clear();
                    }
                    throw new TestException("Should have thrown RegionDestroyedException");
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
            MapBB.incrementCounter("MapBB.NUM_REGION_DESTROY", MapBB.NUM_REGION_DESTROY);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void sizeOfRegion() {
        try {
            int i = region.size();
            Log.getLogWriter().info("----size of region is " + i);
            MapBB.incrementCounter("MapBB.NUM_SIZE", MapBB.NUM_SIZE);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void containsValueMethod() {
        try {
            if (isCarefulValidation) {
                Collection values = region.values();
                for (Object got : values) {
                    boolean containsValue;
                    if (got == null || (containsValue = region.containsValue(got))) continue;
                    throw new TestException("region.containsValue(Object val) should retun true but got: " + containsValue);
                }
            } else {
                Collection values = region.values();
                for (Object got : values) {
                    boolean containsValue;
                    if (got == null || (containsValue = region.containsValue(got))) continue;
                    Log.getLogWriter().info("region.containsValue(Object val) should retun true but got: " + containsValue + ". May occur in concurrent execution. Continuing with test.");
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void isEmptyMethod() {
        try {
            boolean val = region.isEmpty();
            MapBB.incrementCounter("MapBB.NUM_ISEMPTY", MapBB.NUM_ISEMPTY);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void invalidateLocalObject() {
        try {
            Object key = null;
            int invalidateKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_INVALIDATE);
            key = ObjectHelper.createName(invalidateKeyInt);
            Object got = region.get(key);
            if (got != null) {
                region.localInvalidate(key);
                Object gotAfterInvalidate = null;
                Region.Entry entry = region.getEntry(key);
                if (entry != null) {
                    gotAfterInvalidate = entry.getValue();
                }
                if (isCarefulValidation && (entry == null || gotAfterInvalidate != null)) {
                    throw new TestException("region.get(Object key) returns NON NULL value immediately after region.localInvalidate(Object key)" + gotAfterInvalidate);
                }
            }
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (EntryDestroyedException edex) {
            Log.getLogWriter().info("EntryDestroyedException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void destroyLocalObject() {
        block5: {
            try {
                Object key = null;
                int destroyKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_DESTROY);
                key = ObjectHelper.createName(destroyKeyInt);
                Object got = region.get(key);
                if (got == null) break block5;
                int sizeBeforeDestroy = region.size();
                region.localDestroy(key);
                int sizeAfterDestroy = region.size();
                if (!isCarefulValidation) break block5;
                if (sizeAfterDestroy == sizeBeforeDestroy - 1) {
                    Log.getLogWriter().info("sizeAfterDestroy is equal to (sizeBeforeDestroy-1)");
                    break block5;
                }
                throw new TestException("sizeAfterDestroy=" + sizeAfterDestroy + " is NOT equal to (sizeBeforeDestroy-1)=" + (sizeBeforeDestroy - 1));
            }
            catch (EntryNotFoundException enfe) {
                Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
                this.recoverRegion();
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        }
    }

    protected void destroyLocalRegion() {
        try {
            region.localDestroyRegion();
            if (isCarefulValidation) {
                try {
                    region.clear();
                    throw new TestException("Should have thrown RegionDestroyedException");
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void invalidateLocalRegion() {
        try {
            region.localInvalidateRegion();
            if (isCarefulValidation) {
                Collection values = region.values();
                for (Object got : values) {
                    if (got == null) continue;
                    throw new TestException("region.get(Object key) returns non null value immediately after region.localInvalidateRegion");
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void useTransactions() {
        this.putGetPutAllDestroyTxn();
        this.putRemoveClearTxn();
    }

    protected void putGetPutAllDestroyTxn() {
        try {
            CacheTransactionManager cacheTxnMgr = cache.getCacheTransactionManager();
            cacheTxnMgr.begin();
            int i = new Random().nextInt();
            for (int j = 0; j < 10; ++j) {
                region.put((Object)new Integer(i), (Object)Integer.toString(i));
                ++i;
            }
            i = new Random().nextInt();
            TreeMap<Integer, String> m = new TreeMap<Integer, String>();
            for (int j = 0; j < 10; ++j) {
                m.put(new Integer(i), Integer.toString(i));
                ++i;
            }
            region.putAll(m);
            Set s = region.keySet();
            Iterator itr = s.iterator();
            if (itr.hasNext()) {
                region.destroy(itr.next());
            }
            cacheTxnMgr.commit();
            Log.getLogWriter().info("----transaction is committed");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putRemoveClearTxn() {
        try {
            CacheTransactionManager cacheTxnMgr = cache.getCacheTransactionManager();
            cacheTxnMgr.begin();
            int i = new Random().nextInt();
            for (int j = 0; j < 10; ++j) {
                region.put((Object)new Integer(i), (Object)Integer.toString(i));
                ++i;
            }
            region.clear();
            if (region.size() != 0) {
                Log.getLogWriter().info("----clear operation on region inside transaction is not successful");
            }
            i = new Random().nextInt();
            TreeMap<Integer, String> m = new TreeMap<Integer, String>();
            for (int j = 0; j < 10; ++j) {
                m.put(new Integer(i), Integer.toString(i));
                ++i;
            }
            region.putAll(m);
            Set s = region.keySet();
            Iterator itr = s.iterator();
            if (itr.hasNext()) {
                region.remove(itr.next());
            }
            cacheTxnMgr.rollback();
            Log.getLogWriter().info("----transaction is rolled back");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void validate(int index, Object obj) {
        if (obj == null) {
            Log.getLogWriter().info("Validating null:" + index + "=" + obj);
        } else {
            Log.getLogWriter().info("Validating " + obj.getClass().getName() + ":" + index + "=" + obj);
        }
        ObjectHelper.validate(index, obj);
        if (obj == null) {
            Log.getLogWriter().info("Validated null:" + index + "=" + obj);
        } else {
            Log.getLogWriter().info("Validated " + obj.getClass().getName() + ":" + index + "=" + obj);
        }
    }

    protected int getSize() {
        int size = 0;
        try {
            size = region.size();
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        return size;
    }

    protected Set getEntrySet() {
        Set entrySet = null;
        try {
            entrySet = region.entrySet();
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        return entrySet;
    }

    protected void logMirrorTypeAndOperationMismatch() {
        Log.getLogWriter().info("Mirror type and operation mismatch. Getting next operation...");
    }

    protected void forceRollOplogs() {
        try {
            this.persistentReplicate = attr.getDataPolicy().isPersistentReplicate();
            this.evictionLimit = attr.getEvictionAttributes().getMaximum();
            this.regionType = this.persistentReplicate ? (this.evictionLimit <= 0 ? 1003 : 1004) : (this.evictionLimit <= 0 ? 1001 : 1002);
            if (this.regionType == 1003 || this.regionType == 1004 || this.regionType == 1002) {
                region.forceRolling();
                Log.getLogWriter().info("force rolled oplogs");
            }
            if (this.regionType == 1001) {
                try {
                    region.forceRolling();
                    throw new TestException("Should have thrown UnsupportedOperationException while performing forceRolling on non disk regions");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void writeToDisk() {
        try {
            this.persistentReplicate = attr.getDataPolicy().isPersistentReplicate();
            this.evictionLimit = attr.getEvictionAttributes().getMaximum();
            if (this.persistentReplicate) {
                if (this.evictionLimit <= 0) {
                    this.regionType = 1003;
                }
            } else {
                this.regionType = 1004;
            }
            if (this.regionType == 1003 || this.regionType == 1004) {
                region.writeToDisk();
                Log.getLogWriter().info("writeToDisk performed on persistent region");
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    static {
        isCarefulValidation = false;
        isReplicate = false;
        endTestOnNumKeysInRegion = -1;
    }
}

