/*
 * Decompiled with CFR 0.152.
 */
package management.util;

import com.gemstone.gemfire.cache.Region;
import management.util.HydraUtil;
import util.TestException;

public class RegionUtil {
    public static void checkRegionKeyExists(Region r, Object key) {
        if (HydraUtil.isSerialTest()) {
            if (r.containsKey(key)) {
                return;
            }
            throw new TestException("Region " + r.getName() + " does not contain key " + key);
        }
    }

    public static void checkRegionKeyExistsValueExists(Region r, Object key, Object value) {
        if (HydraUtil.isSerialTest()) {
            if (value == null) {
                throw new TestException("Expected value can not be null ");
            }
            RegionUtil.checkRegionKeyExists(r, key);
            Object regionValue = r.get(key);
            if (regionValue == null) {
                throw new TestException("Region " + r.getName() + " value for  " + key + " is " + regionValue + " but expected " + value);
            }
            if (regionValue != null && !regionValue.equals(value)) {
                throw new TestException("Region " + r.getName() + " value for  " + key + " is " + regionValue + " but expected " + value);
            }
        }
    }

    public static void checkRegionValueDoesNotExists(Region r, Object key) {
        if (HydraUtil.isSerialTest()) {
            if (!r.containsValueForKey(key)) {
                return;
            }
            throw new TestException("Region " + r.getName() + " contains value for " + key + " but was invalidated before");
        }
    }

    public static void checkRegionKeyDoesNotExistsValueDoesNotExists(Region r, Object key) {
        if (HydraUtil.isSerialTest()) {
            if (r.containsKey(key)) {
                throw new TestException("Region " + r.getName() + " contains key " + key + " but was destroyed before");
            }
            if (!r.containsValueForKey(key)) {
                return;
            }
            throw new TestException("Region " + r.getName() + " contains value for " + key + " but was destroyed/invalidated before");
        }
    }
}

