/*
 * Decompiled with CFR 0.152.
 */
package management.test.federation;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientPrms;
import hydra.ClientVmInfo;
import hydra.HydraVector;
import hydra.JMXManagerBlackboard;
import hydra.JMXManagerHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import management.Expectations;
import management.jmx.Expectation;
import management.jmx.JMXBlackboard;
import management.jmx.JMXNotificationListener;
import management.jmx.SimpleJMXRecorder;
import management.jmx.validation.JMXValidator;
import management.jmx.validation.ValidationResult;
import management.test.federation.FederationBlackboard;
import management.test.federation.FederationPrms;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import splitBrain.SBUtil;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;

public class FederationTest {
    private static final int ATTR_STATE_OP_INCREMENT_TOGETHER = 1;
    private static final int ATTR_STATE_OP_DECREMENT_TOGETHER = 2;
    private static final int ATTR_STATE_OP_MODIFY_DEPENDING = 3;
    private static final int ATTR_STATE_OP_MIRRORING = 4;
    private static FederationTest testInstance;
    private AtomicInteger notificationSequenceCounter = new AtomicInteger();
    private long waitTime;
    private DistributedSystem ds = null;
    private GemFireCacheImpl cache = null;
    private ManagementService service;
    private Map<String, Class> klassLoaded = new HashMap<String, Class>();
    private Set<ObjectName> localMbeans = new HashSet<ObjectName>();
    private Set<ObjectName> unregisteredMbeans = new HashSet<ObjectName>();
    private Map<ObjectName, String> mbeanToOpMapping = new HashMap<ObjectName, String>();
    private Map<ObjectName, AtomicInteger> mbeanOpCountMapping = new HashMap<ObjectName, AtomicInteger>();
    private Map<ObjectName, JMXNotificationListener> notifListenerMap = new HashMap<ObjectName, JMXNotificationListener>();
    private List<Expectation> globalExpectationList = new ArrayList<Expectation>();
    private SimpleJMXRecorder jmxEventRecorder = new SimpleJMXRecorder();

    public static synchronized void HydraInitTask_initialize() {
        if (testInstance == null) {
            testInstance = new FederationTest();
            testInstance.initialize();
        }
    }

    public static void HydraInitTask_becomeManager() {
        testInstance.becomeManager();
    }

    public static void HydraInitTask_RegisterMBeans() {
        testInstance.initMBeanSet();
    }

    public static void HydraInitTask_InitFedBB() {
        testInstance.initFB();
    }

    public static void HydraTask_RegisterMBean() {
        testInstance.registerMBean();
    }

    public static void HydraTask_UnRegisterMBean() {
        testInstance.unregisterMBean();
    }

    public static void HydraTask_RestartManaged() {
        testInstance.restartRandomManagedNode();
    }

    public static void HydraTask_RestartManaging() {
        testInstance.restartRandomManagingNode();
    }

    public static void HydraTask_becomeManager() {
        testInstance.becomeManager();
    }

    public static void HydraTask_performMbeanStateOperations() {
        testInstance.performMbeanStateOperations();
    }

    public static void HydraTask_generateNotifications() {
        testInstance.generateNotifications();
    }

    public static void HydraTask_doJMXOperations() {
        testInstance.doJMXOperations();
    }

    public static void HydraTask_doSickMember() {
        testInstance.doSickMember();
    }

    public static void HydraCloseTask_verifyMBeanSet() {
        testInstance.verifyMBeanSet();
    }

    public static void HydraCloseTask_verifyMBeanState() {
        testInstance.verifyMBeanState();
    }

    public static void HydraCloseTask_verifyMBeanOperationsAndNotifications() {
        testInstance.verifyMBeanOperationsAndNotifications();
    }

    private void initialize() {
        this.waitTime = TestConfig.tab().longAt(FederationPrms.taskWaitTime);
        this.createCache();
        if (this.service == null) {
            this.service = ManagementService.getManagementService((Cache)this.cache);
        }
    }

    private void createCache() {
        if (this.cache == null) {
            String cacheConfig = TestConfig.tab().stringAt(CachePrms.names);
            this.cache = (GemFireCacheImpl)CacheHelper.createCache(cacheConfig);
        }
    }

    private void becomeManager() {
        ManagementUtil.saveMemberManagerInBlackboard();
        if (!this.service.isManager()) {
            this.service.startManager();
        }
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.logInfo("JMX Manager Blackboard ");
        JMXManagerBlackboard.getInstance().print();
        HydraUtil.logInfo("JMX Manager Endpoints  " + HydraUtil.ObjectToString(JMXManagerHelper.getEndpoints()));
    }

    private void initMBeanSet() {
        HydraVector mbeans = TestConfig.tab().vecAt(FederationPrms.mbeanInitSet);
        for (String klass : mbeans) {
            this.createMbeanForClass(klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMbeanForClass(String klass) {
        Class<?>[] interfaces;
        Class kklass = null;
        if (!this.klassLoaded.containsKey(klass)) {
            try {
                kklass = Class.forName(klass);
                this.klassLoaded.put(klass, kklass);
            }
            catch (Exception e) {
                HydraUtil.logErrorAndRaiseException("Error loading class " + klass, e);
            }
        } else {
            kklass = this.klassLoaded.get(klass);
        }
        if ((interfaces = kklass.getInterfaces()).length > 1) {
            HydraUtil.logErrorAndRaiseException("Mbean implementation has more than one interfaces dont know which one to use");
        }
        Class<?> interfaceClass = null;
        boolean notificationEmitting = false;
        for (Class<?> kl : interfaces) {
            if (!kl.getName().contains("Custom")) continue;
            interfaceClass = kl;
            break;
        }
        for (Class<?> kl : interfaces) {
            if (!kl.getName().contains("NotificationBroadcaster")) continue;
            notificationEmitting = true;
            HydraUtil.logFine(klass + " MBean is configured for Notification emitting.");
        }
        Class superclasses = kklass.getSuperclass();
        if (superclasses.getName().contains("NotificationBroadcaster")) {
            notificationEmitting = true;
            HydraUtil.logFine(klass + " MBean is configured for Notification emitting.");
        }
        Object mbeanImpl = null;
        try {
            mbeanImpl = kklass.newInstance();
        }
        catch (Exception e) {
            HydraUtil.logErrorAndRaiseException("Cant create Mbean object of " + klass);
        }
        int objectNameCount = FederationBlackboard.getBB().getNextObjectNameCounter();
        String templateName = this.getTemplateObjectName(mbeanImpl, interfaceClass) + objectNameCount;
        ObjectName changedObjectName = this.registerMbean(mbeanImpl, interfaceClass, true, templateName, notificationEmitting);
        Set<ObjectName> set = this.localMbeans;
        synchronized (set) {
            this.localMbeans.add(changedObjectName);
        }
    }

    private ObjectName registerMbean(Object mbeanImpl, Class interfaceClass, boolean federate, String objectName, boolean isNotificationEmitter) {
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            HydraUtil.logErrorAndRaiseException("Failed to create objectName with " + objectName, e);
        }
        catch (NullPointerException e) {
            HydraUtil.logErrorAndRaiseException("Failed to create objectName with " + objectName, e);
        }
        ObjectName changedObjectName = this.service.registerMBean(mbeanImpl, mbeanName);
        if (federate) {
            this.service.federate(changedObjectName, interfaceClass, isNotificationEmitter);
            if (isNotificationEmitter && this.registerForNotifications()) {
                JMXNotificationListener listner = new JMXNotificationListener(FederationTest.class.getName(), this.jmxEventRecorder, changedObjectName);
                this.notifListenerMap.put(changedObjectName, listner);
                try {
                    this.getPlatformMbeanServer().addNotificationListener(changedObjectName, listner, null, null);
                }
                catch (InstanceNotFoundException e) {
                    HydraUtil.logErrorAndRaiseException("Failed registed listner on " + objectName, e);
                }
            }
        }
        return changedObjectName;
    }

    private MBeanServer getPlatformMbeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private boolean registerForNotifications() {
        return TestConfig.tab().booleanAt(FederationPrms.registerForNotifications);
    }

    private String getTemplateObjectName(Object mbeanImpl, Class interfaceClass) {
        Class[] ptypes = new Class[]{};
        try {
            Method m = interfaceClass.getMethod("getTemplateObjectName", ptypes);
            String str = (String)m.invoke(mbeanImpl, (Object[])null);
            return str;
        }
        catch (SecurityException e) {
            HydraUtil.logErrorAndRaiseException("Cant get template object name", e);
        }
        catch (NoSuchMethodException e) {
            HydraUtil.logErrorAndRaiseException("Cant get template object name", e);
        }
        catch (IllegalArgumentException e) {
            HydraUtil.logErrorAndRaiseException("Cant get template object name", e);
        }
        catch (IllegalAccessException e) {
            HydraUtil.logErrorAndRaiseException("Cant get template object name", e);
        }
        catch (InvocationTargetException e) {
            HydraUtil.logErrorAndRaiseException("Cant get template object name", e);
        }
        return null;
    }

    private void registerMBean() {
        String klassName = TestConfig.tab().stringAt(FederationPrms.mbeanSet);
        this.createMbeanForClass(klassName);
        this.sleepForReplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMBean() {
        Set<ObjectName> set = this.localMbeans;
        synchronized (set) {
            int size = this.localMbeans.size();
            HydraUtil.logInfo("Current number of mbean registered " + size);
            if (size == 1) {
                HydraUtil.logInfo("Only one mbean left so returning without unregistering any mbean");
                return;
            }
            int r = TestConfig.tab().getRandGen().nextInt(size - 1);
            Iterator<ObjectName> iterator = this.localMbeans.iterator();
            ObjectName n = null;
            for (int i = 0; i <= r; ++i) {
                n = iterator.next();
                if (i == r) break;
            }
            HydraUtil.logInfo("Unregistering mbean with objectName " + n);
            this.service.unregisterMBean(n);
            HydraUtil.logInfo("Unreigstered MBean " + n);
            this.clearLocalMBeanState(n);
            this.unregisteredMbeans.add(n);
        }
        this.sleepForReplication();
    }

    private void clearLocalMBeanState(ObjectName n) {
        this.localMbeans.remove(n);
        this.mbeanOpCountMapping.remove(n);
        this.mbeanToOpMapping.remove(n);
        this.notifListenerMap.remove(n);
    }

    private void restartRandomManagedNode() {
        HydraVector clientNames = TestConfig.tab().vecAt(ClientPrms.names, null);
        ArrayList<String> list = new ArrayList<String>();
        for (String name : clientNames) {
            if (!name.contains("managed")) continue;
            list.add(name);
        }
        int numVMsToStop = 1 + TestConfig.tab().getRandGen().nextInt(list.size() - 1);
        List vmList = null;
        HashSet<? extends ObjectName> oldMbeans = new HashSet<ObjectName>();
        if (numVMsToStop > 0) {
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "managed");
            vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            for (ClientVmInfo cInfo : vmList) {
                String clientName = cInfo.getClientName();
                int vmId = cInfo.getVmid();
                String pidPrefix = "MEMBERNAME_" + clientName + vmId;
                String memberId = (String)FederationBlackboard.getBB().getSharedMap().get(pidPrefix);
                oldMbeans.addAll(this.getMbeansFor(memberId));
            }
            HydraUtil.logInfo("MbeanSet before restart of nodes " + vmList + " is -> " + HydraUtil.ObjectToString(oldMbeans));
            HydraUtil.logInfo("Restarting " + numVMsToStop + " managed nodes  vmList " + vmList + " corresponding managing stop Modes " + stopModeList);
            List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
            StopStartVMs.joinStopStart(vmList, threads);
            HydraUtil.logInfo("Completed restart of " + numVMsToStop + " managed nodes. Checking for new mbeans");
            this.sleepForReplication();
            this.sleepForReplication();
            this.sleepForReplication();
        }
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        HashSet<ObjectName> unwantedMBeans = new HashSet<ObjectName>();
        for (String managingUrl : urls) {
            HydraUtil.logInfo("Checking MbeanSet at " + managingUrl + " for old mbeans :" + HydraUtil.ObjectToString(oldMbeans));
            MBeanServerConnection remoteMBS = null;
            try {
                remoteMBS = ManagementUtil.connectToUrl(managingUrl);
            }
            catch (MalformedURLException e) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            catch (IOException e) {
                if (HydraUtil.isSerialTest()) {
                    HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
                }
                HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            }
            try {
                Set<ObjectName> objectNames = remoteMBS.queryNames(null, null);
                for (ObjectName n : objectNames) {
                    for (Object e : oldMbeans) {
                        if (!e.equals(n)) continue;
                        unwantedMBeans.add(n);
                    }
                }
                if (unwantedMBeans.size() <= 0) continue;
                throw new TestException("Found " + unwantedMBeans.size() + " old mbeans " + unwantedMBeans + " after restart of managed nodes " + vmList);
            }
            catch (IOException e) {
                throw new TestException("Error trying query connector at " + managingUrl, e);
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private Collection<? extends ObjectName> getMbeansFor(String memberId) {
        String managingUrl = FederationBlackboard.getBB().getManagingNode();
        MBeanServerConnection remoteMBS = null;
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        try {
            remoteMBS = ManagementUtil.connectToUrl(managingUrl);
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
        }
        try {
            Set<ObjectName> objectNames = remoteMBS.queryNames(null, null);
            for (ObjectName n : objectNames) {
                if (!n.toString().contains(memberId)) continue;
                list.add(n);
            }
            return list;
        }
        catch (IOException e) {
            throw new TestException("Error trying query connector at " + managingUrl, e);
        }
    }

    private void restartRandomManagingNode() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        if (numVMsToStop > 0) {
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "managing_1");
            List vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            HydraUtil.logInfo("Restarting " + numVMsToStop + " managing nodes  vmList " + vmList + " corresponding managing stop Modes " + stopModeList);
            List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
            StopStartVMs.joinStopStart(vmList, threads);
        }
    }

    private void performMbeanStateOperations() {
        String opName;
        int size = this.localMbeans.size();
        HydraUtil.logInfo("Current number of mbean registered " + size);
        int r = TestConfig.tab().getRandGen().nextInt(size - 1);
        Iterator<ObjectName> iterator = this.localMbeans.iterator();
        ObjectName n = null;
        for (int i = 0; i <= r; ++i) {
            n = iterator.next();
            if (i == r) break;
        }
        if ((opName = this.mbeanToOpMapping.get(n)) == null) {
            int opCode = TestConfig.tab().getRandGen().nextInt(3) + 1;
            switch (opCode) {
                case 1: {
                    opName = "incrementCountersTogether";
                    break;
                }
                case 2: {
                    opName = "decrementCountersTogether";
                    break;
                }
                case 3: {
                    opName = "changeBwhenAisEven";
                    break;
                }
                case 4: {
                    opName = "mirrorCounters";
                }
            }
            this.mbeanToOpMapping.put(n, opName);
            this.mbeanOpCountMapping.put(n, new AtomicInteger());
        }
        HydraUtil.logInfo("Performing attribute modification operation on mbean with objectName " + n + " Operation Name " + opName);
        this.doJmxOperation(n, opName, null, null, null, true);
        this.sleepForReplication();
    }

    private void sleepForReplication() {
        HydraUtil.sleepForReplicationJMX();
    }

    private void doJMXOperations() {
        ObjectName mbean = this.getRandomLocalMbean();
        String url = FederationBlackboard.getBB().getManagingNode();
        String operationName = "doJmxOp";
        Object a = this.doJmxOperation(mbean, operationName, url, null, null, false);
        String b = "vmId" + RemoteTestModule.getMyVmid();
        HydraUtil.logFine("Result of operation : " + operationName + " on mbean " + mbean + " is " + a);
        if (a == null) {
            HydraUtil.logErrorAndRaiseException("Error during jmx operations returned null whereas expected value was " + b);
        }
        if (!"EXPECTED_EXCPTION".equals(a)) {
            this.jmxEventRecorder.addJmxOp(mbean, operationName, a);
            Expectation exp = Expectations.forMBean(mbean).expectMBeanAt(url).expectOperation(operationName, b);
            this.globalExpectationList.add(exp);
        }
    }

    private void generateNotifications() {
        String[] signature;
        String arugment;
        Object[] params;
        String url;
        String operationName;
        ObjectName mbean = this.getRandomLocalMbean();
        Object a = this.doJmxOperation(mbean, operationName = "sendNotificationToMe", url = FederationBlackboard.getBB().getManagingNode(), params = new Object[]{arugment = "seq" + this.notificationSequenceCounter.incrementAndGet()}, signature = new String[]{"java.lang.String"}, false);
        if (!(a instanceof String) || !a.equals("EXPECTED_EXCPTION")) {
            Expectation exp = Expectations.forMBean(mbean).expectMBeanAt(url).expectNotification("jmx.attribute.change", (Object)RemoteTestModule.getMyVmid(), arugment, null, 0);
            this.globalExpectationList.add(exp);
        }
    }

    private Object doJmxOperation(ObjectName n, String opName, String managingUrl, Object[] params, String[] signature, boolean record) {
        if (managingUrl == null) {
            Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
            int r = TestConfig.tab().getRandGen().nextInt(urls.size() - 1);
            Iterator<String> iterator = urls.iterator();
            String murl = null;
            for (int i = 0; i <= r; ++i) {
                murl = iterator.next();
                if (i == r) break;
            }
            managingUrl = murl;
        }
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = ManagementUtil.connectToUrl(managingUrl);
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            return "EXPECTED_EXCPTION";
        }
        Object returnValue = null;
        try {
            HydraUtil.logInfo("Invoking operation " + opName + " on " + n + " hosted in manging node " + managingUrl);
            returnValue = remoteMBS.invoke(n, opName, params, signature);
            if (record) {
                this.mbeanOpCountMapping.get(n).incrementAndGet();
            }
            HydraUtil.logInfo("Successfully completed operation " + opName + " on " + n + " hosted in manging node " + managingUrl + " result " + returnValue);
            return returnValue;
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + n + " on managing node " + managingUrl, e);
            }
            HydraUtil.logInfo("Continuing test expected execption " + e.getMessage() + " for mbean " + n);
            return "EXPECTED_EXCPTION";
        }
        catch (MBeanException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + n + " on managing node " + managingUrl, e);
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + n + " on managing node " + managingUrl, e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + n + " on managing node " + managingUrl, e);
        }
        return returnValue;
    }

    private void doSickMember() {
        ObjectName mbean = this.getRandomLocalMbean();
        String managingUrl = FederationBlackboard.getBB().getManagingNode();
        SBUtil.beSick();
        this.sleepForReplication();
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = ManagementUtil.connectToUrl(managingUrl);
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
        }
        try {
            remoteMBS.setAttribute(mbean, new Attribute("counter", 99));
            long timestamp = System.currentTimeMillis();
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isConcurrentTest()) {
                HydraUtil.logInfo("Expected exception in concurrent test continuing test . " + e.getMessage());
            } else {
                HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
            }
        }
        catch (AttributeNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
        }
        catch (InvalidAttributeValueException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
        }
        catch (MBeanException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isConcurrentTest()) {
                HydraUtil.logInfo("Expected exception in concurrent test continuing test . " + e.getMessage());
            }
            HydraUtil.logErrorAndRaiseException("Error trying to set attribute " + managingUrl, e);
        }
        this.sleepForReplication();
        Expectation exp = Expectations.forMBean(mbean).expectMBeanAt(managingUrl).expectAttribute("counter", "UNDEFINED");
        ArrayList<Expectation> list = new ArrayList<Expectation>();
        list.add(exp);
        JMXValidator validator = new JMXValidator(JMXBlackboard.getBB(), list);
        this.validateAndPrint(validator);
        this.sleepForReplication();
        SBUtil.beHealthy();
        this.sleepForReplication();
    }

    private void verifyMBeanOperationsAndNotifications() {
        ArrayList<Expectation> removedList = new ArrayList<Expectation>();
        for (ObjectName n : this.unregisteredMbeans) {
            for (Expectation e : this.globalExpectationList) {
                if (!e.getObjectName().equals(n)) continue;
                removedList.add(e);
            }
        }
        this.globalExpectationList.removeAll(removedList);
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        for (String url : urls) {
            HydraUtil.logInfo("Checking Global Expectation Set at  " + url);
            JMXValidator validator = new JMXValidator(this.jmxEventRecorder, this.globalExpectationList);
            this.validateAndPrint(validator);
        }
    }

    private void verifyMBeanSet() {
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        for (String url : urls) {
            HydraUtil.logInfo("Checking MBeanSet at Managing Node Url " + url);
            ArrayList<Expectation> list = new ArrayList<Expectation>();
            HydraUtil.logInfo("Checking mbeanSet " + this.localMbeans);
            for (ObjectName name : this.localMbeans) {
                Expectation exp = Expectations.forMBean(name).expectMBeanAt(url);
                list.add(exp);
            }
            JMXValidator validator = new JMXValidator(JMXBlackboard.getBB(), list);
            this.validateAndPrint(validator);
            MBeanServerConnection remoteMBS = null;
            try {
                remoteMBS = ManagementUtil.connectToUrl(url);
            }
            catch (MalformedURLException e) {
                throw new TestException("Error trying to managing node at " + url, e);
            }
            catch (IOException e) {
                throw new TestException("Error trying to managing node at " + url, e);
            }
            try {
                Set<ObjectName> objectNames = remoteMBS.queryNames(null, null);
                ArrayList<ObjectName> unwantedMBeans = new ArrayList<ObjectName>();
                for (ObjectName n : objectNames) {
                    if (!this.unregisteredMbeans.contains(n)) continue;
                    unwantedMBeans.add(n);
                }
                if (unwantedMBeans.size() <= 0) continue;
                throw new TestException("Found " + unwantedMBeans.size() + " mbeans which are already unregistered " + unwantedMBeans);
            }
            catch (IOException e) {
                throw new TestException("Error trying query connector at " + url, e);
            }
        }
    }

    private void verifyMBeanState() {
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        for (String url : urls) {
            HydraUtil.logInfo("Checking MBeanSet at Managing Node Url " + url);
            ArrayList<Expectation> list = new ArrayList<Expectation>();
            HydraUtil.logInfo("Checking mbeanSet " + this.localMbeans);
            for (ObjectName name : this.localMbeans) {
                if (!this.mbeanToOpMapping.containsKey(name)) continue;
                Expectation exp = Expectations.forMBean(name).expectMBeanAt(url);
                Integer[] aAndB = this.getAandBFor(name);
                exp.expectAttribute("A", aAndB[0]).expectAttribute("B", aAndB[1]);
                list.add(exp);
            }
            JMXValidator validator = new JMXValidator(this.jmxEventRecorder, list);
            this.validateAndPrint(validator);
        }
    }

    private Integer[] getAandBFor(ObjectName name) {
        int i;
        int a = 0;
        int b = 0;
        String op = this.mbeanToOpMapping.get(name);
        if (op == null) {
            HydraUtil.logErrorAndRaiseException("Did not find operation entry for " + name);
        }
        int count = this.mbeanOpCountMapping.get(name).get();
        HydraUtil.logInfo("Operation " + op + " was performed on " + name + " for " + count + " times");
        if ("incrementCountersTogether".equals(op)) {
            for (i = 0; i < count; ++i) {
                ++a;
                ++b;
            }
        } else if ("decrementCountersTogether".equals(op)) {
            for (i = 0; i < count; ++i) {
                --a;
                --b;
            }
        } else if ("changeBwhenAisEven".equals(op)) {
            for (i = 0; i < count; ++i) {
                if (a % 2 == 0) {
                    ++b;
                    continue;
                }
                --b;
            }
        } else if ("mirrorCounters".equals(op)) {
            for (i = 0; i < count; ++i) {
                ++a;
                --b;
            }
        }
        Integer[] array = new Integer[]{a, b};
        return array;
    }

    private ObjectName getRandomLocalMbean() {
        int size = this.localMbeans.size();
        HydraUtil.logInfo("Current number of mbean registered " + size);
        int r = TestConfig.tab().getRandGen().nextInt(size - 1);
        Iterator<ObjectName> iterator = this.localMbeans.iterator();
        ObjectName n = null;
        for (int i = 0; i <= r; ++i) {
            n = iterator.next();
            if (i == r) break;
        }
        return n;
    }

    private void validateAndPrint(JMXValidator validator) {
        List<ValidationResult> result = validator.validate();
        if (result.size() > 0) {
            HydraUtil.logInfo("JMX Validations failed. See below details");
            StringBuilder sb = new StringBuilder();
            int i = 1;
            for (ValidationResult r : result) {
                HydraUtil.logError(r.toString());
                sb.append(i++ + "# " + r.toString());
            }
            throw new TestException(result.size() + " JMX validation failed \n" + sb.toString());
        }
        HydraUtil.logInfo("JMX Validations suceeded");
    }

    private void initFB() {
        String pidPrefix = "MEMBERNAME_" + RemoteTestModule.getMyClientName() + RemoteTestModule.getMyVmid();
        String formattedMemberID = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        HydraUtil.logInfo("Storing member Name against vmId " + pidPrefix + " memberId " + formattedMemberID);
        FederationBlackboard.getBB().getSharedMap().put(pidPrefix, formattedMemberID);
    }
}

