/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.ManagementService;
import hydra.CacheHelper;
import hydra.DiskStoreHelper;
import hydra.HydraVector;
import hydra.JMXManagerBlackboard;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import java.util.List;
import java.util.Set;
import management.test.cli.CommandBB;
import management.test.cli.CommandPrms;
import management.test.cli.CommandTest;
import management.util.ManagementUtil;
import util.TestHelper;

public class CommandTestVersionHelper {
    public static void HydraTask_becomeManager() {
        CommandTest.HydraTask_becomeManager();
    }

    public static void saveMemberMbeanInBlackboard() {
        ManagementUtil.saveMemberMbeanInBlackboard();
    }

    public static String getName(DistributedMember member) {
        return member.getName();
    }

    public static List<String> getGroups(DistributedMember member) {
        return member.getGroups();
    }

    public static void createRegions() {
        HydraVector regionConfigNamesList = TestConfig.tab().vecAt(RegionPrms.names);
        for (String regionConfigName : regionConfigNamesList) {
            if (!CommandTestVersionHelper.shouldCreateRegion(regionConfigName)) continue;
            Log.getLogWriter().info("Creating region with config name " + regionConfigName);
            Region aRegion = RegionHelper.createRegion(regionConfigName);
            Log.getLogWriter().info("Done creating region with config name " + regionConfigName + ", region name is " + aRegion.getFullPath());
        }
        if (CommandPrms.getCreateSubregions()) {
            CommandTestVersionHelper.createSubregions();
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean shouldCreateRegion(String regionConfigName) {
        boolean isPersistentRegion;
        String configNameLC = regionConfigName.toLowerCase();
        boolean createProxyRegions = CommandPrms.getCreateProxyRegions();
        boolean createClientRegions = CommandPrms.getCreateClientRegions();
        boolean createPersistentRegions = CommandPrms.getCreatePersistentRegions();
        boolean isProxyRegion = configNameLC.indexOf("empty") >= 0 || configNameLC.indexOf("accessor") >= 0;
        boolean isClientRegion = configNameLC.startsWith("client");
        boolean bl = isPersistentRegion = configNameLC.indexOf("persist") >= 0;
        if (isPersistentRegion && !createPersistentRegions) {
            return false;
        }
        if (isClientRegion != createClientRegions) {
            return false;
        }
        if (isProxyRegion != createProxyRegions) {
            return false;
        }
        try {
            String colocatedWithRegion;
            RegionAttributes attr = RegionHelper.getRegionAttributes(regionConfigName);
            if (attr.getPartitionAttributes() != null && (colocatedWithRegion = attr.getPartitionAttributes().getColocatedWith()) != null) {
                return CacheHelper.getCache().getRegion(colocatedWithRegion) != null;
            }
        }
        catch (IllegalStateException e) {
            String errStr = e.toString();
            if (errStr.indexOf("Region specified in 'colocated-with' is not present") >= 0) {
                return false;
            }
            throw e;
        }
        HydraVector configNamesVec = TestConfig.tab().vecAt(RegionPrms.names);
        int index = configNamesVec.indexOf(regionConfigName);
        String regionName = (String)TestConfig.tab().vecAt(RegionPrms.regionName).get(index);
        int numMembersToHostRegion = CommandPrms.getNumMembersToHostRegion();
        if (numMembersToHostRegion >= 0) {
            SharedLock lock = CommandBB.getBB().getSharedLock();
            lock.lock();
            String key = regionName + "_counter";
            try {
                Integer counter = (Integer)CommandBB.getBB().getSharedMap().get(key);
                if (counter == null) {
                    counter = 0;
                }
                counter = counter + 1;
                CommandBB.getBB().getSharedMap().put(key, counter);
                if (counter > numMembersToHostRegion) {
                    Log.getLogWriter().info("Not creating " + regionName + " because this region is limited to existing in " + numMembersToHostRegion + " members");
                    boolean bl2 = false;
                    return bl2;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return true;
    }

    private static void createSubregions() {
        RegionAttributes regAttr;
        String diskStoreConfig;
        Cache theCache = CacheHelper.getCache();
        Set regionSet = theCache.rootRegions();
        boolean createProxyRegions = CommandPrms.getCreateProxyRegions();
        boolean createClientRegions = CommandPrms.getCreateClientRegions();
        boolean createPersistentRegions = CommandPrms.getCreatePersistentRegions();
        String regionConfigName = "replicate";
        if (createProxyRegions) {
            regionConfigName = "emptyReplicate1";
        }
        if (createClientRegions) {
            regionConfigName = "clientReplicate";
        }
        RegionAttributes attr = RegionHelper.getRegionAttributes(RegionHelper.getAttributesFactory(regionConfigName));
        RegionFactory fac = theCache.createRegionFactory(attr);
        Region fanoutParent = fac.create("fanoutParent");
        Region chainParent = fac.create("chainParent");
        String[] regionConfigNames = new String[]{"replicate", "replicateWithOverflow", "persistReplicate", "persistReplicateWithOverflow"};
        if (createProxyRegions) {
            regionConfigNames = new String[]{"emptyReplicate1", "emptyReplicate2", "persistEmptyReplicate1", "persistEmptyReplicate2"};
        }
        if (createClientRegions) {
            regionConfigNames = new String[]{"clientReplicate", "clientReplicateWithOverflow", "clientPersistReplicate", "clientPersistReplicateWithOverflow"};
        }
        int SUBREGION_CHAIN_LENGTH = 8;
        int count = 0;
        Region currentRegion = chainParent;
        for (int i = 1; i <= 8; ++i) {
            String regionConfig = regionConfigNames[count % regionConfigNames.length];
            RegionAttributes regAttr2 = RegionHelper.getRegionAttributes(regionConfig);
            String diskStoreConfig2 = regAttr2.getDiskStoreName();
            if (diskStoreConfig2 != null) {
                DiskStoreHelper.createDiskStore(diskStoreConfig2);
            }
            fac = theCache.createRegionFactory(regAttr2);
            currentRegion = fac.createSubregion(currentRegion, "region_" + ++count);
        }
        String regionConfig = "persistPR";
        if (createProxyRegions) {
            regionConfig = "prAccessor1";
        }
        if ((diskStoreConfig = (regAttr = RegionHelper.getRegionAttributes(regionConfig)).getDiskStoreName()) != null) {
            DiskStoreHelper.createDiskStore(diskStoreConfig);
        }
        fac = theCache.createRegionFactory(regAttr);
        fac.createSubregion(currentRegion, "region_" + ++count);
        for (Region existingRegion : regionSet) {
            fac = theCache.createRegionFactory(existingRegion.getAttributes());
            fac.createSubregion(fanoutParent, existingRegion.getName());
        }
    }

    public static void logManagerStatus() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("Cache does not exist in this jvm so cannot log manager status");
        } else {
            Object value;
            ManagementService service = ManagementService.getExistingManagementService((Cache)theCache);
            StringBuffer aStr = new StringBuffer();
            aStr.append("manager status\n");
            aStr.append("isManager: " + service.isManager() + "\n");
            Log.getLogWriter().info(aStr.toString());
            if (service.isManager() && (value = JMXManagerBlackboard.getInstance().getSharedMap().get(RemoteTestModule.getMyVmid())) != null) {
                Log.getLogWriter().info("This member is a manager and the jmx endpoint is " + value);
            }
        }
    }
}

