/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;

public class GatewayReceiverTestMBean
extends AbstractTestMBean<GatewayReceiverTestMBean> {
    public GatewayReceiverTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, GatewayReceiverTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[6];
    }

    public void checkReceiverConfig(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"Port", "SocketBufferSize", "BindAddress", "MaximumTimeBetweenPings", "StartPort", "EndPort", "GatewayTransportFilters"};
        HydraUtil.logInfo(prefix + " Calling checkReceiverConfig");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkReceiverConfig " + HydraUtil.ObjectToString(attrList));
    }

    public void checkReceiverStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"EventsReceivedRate", "ClientConnectionCount", "ConnectionLoad", "ConnectionThreads", "DuplicateBatchesReceived", "LoadPerConnection", "LoadPerQueue", "NumGateways", "OutoforderBatchesReceived", "QueueLoad", "ThreadQueueSize", "TotalConnectionsTimedOut", "TotalFailedConnectionAttempts", "TotalReceivedBytes", "TotalSentBytes", "CreateRequestsRate", "DestroyRequestsRate", "GetRequestAvgLatency", "GetRequestRate", "PutRequestRate", "UpdateRequestsRate"};
        HydraUtil.logInfo(prefix + " Calling checkReceiverStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkReceiverStatistics " + HydraUtil.ObjectToString(attrList));
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "GatewayReceiverTestMBean : ";
    }
}

