/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import java.util.Collection;
import java.util.Map;
import management.cli.CommandOutputValidator;
import management.cli.TestableGfsh;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import util.TestException;

public class NetstatExecutor
extends AbstractTestCommandExecutor {
    private String fileName = null;

    @Override
    public Object executeAndVerify(TestCommandInstance instance) {
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (!gfsh.isConnectedAndReady()) {
            CLITest.connectGfshToManagerNode();
        }
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, instance.toString(), CLITest.getGfshOutputFile(), true);
        Map map = (Map)object[0];
        CommandResult result = null;
        Collection values = map.values();
        for (Object r : values) {
            if (!(r instanceof CommandResult)) continue;
            result = (CommandResult)r;
            if (!result.getStatus().equals((Object)Result.Status.OK)) {
                throw new TestException("Command return status is *NOT* OK. Command execution has failed");
            }
            HydraUtil.logInfo("Completed exeuction of <" + instance + "> successfully");
        }
        this.verifyGemfire(gfsh, object);
        this.verifyJMX(gfsh, object);
        this.verifyCommand(gfsh, object);
        return result;
    }

    @Override
    public Object verifyCommand(TestableGfsh gfsh, Object object) {
        Object[] outputs = (Object[])object;
        CommandOutputValidator validator = new CommandOutputValidator(gfsh, outputs);
        validator.addUnExpectedErrorString("Error occurred while executing netstat on {0}").addUnExpectedErrorString("Could not find member(s) with Id(s) or name(s): {0}.").addUnExpectedErrorString("Only one of --group or --member should be specified.");
        CommandOutputValidator.CommandOutputValidatorResult result = validator.validate();
        if (!result.result) {
            this.addFailure(" Command Failed validation : " + result.getExceptionMessage());
        }
        if (this.fileName != null && !this.checkFile(this.fileName)) {
            this.addFailure(" Command Failed validation : Netstat command failed to create file named " + this.fileName);
        }
        this.fileName = null;
        return result;
    }

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        if ("group".equals(name)) {
            instance.addOption(name, this.getGroup());
        } else if ("file".equals(name)) {
            this.fileName = this.getFile(instance.getMode(), ".txt");
            instance.addOption(name, this.fileName);
        } else if ("with-lsof".equals(name)) {
            instance.addOption(name, "true");
        } else if (name.equals("member")) {
            instance.addOption(name, this.getMemberId());
        }
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

