/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import java.util.List;
import java.util.Map;
import management.operations.OperationEvent;
import management.operations.OperationPrms;
import management.operations.events.CQAndIndexOperationEvents;
import management.operations.events.impl.AbstractEvents;
import management.util.HydraUtil;

public class CQAndIndexEvents
extends AbstractEvents
implements CQAndIndexOperationEvents {
    public CQAndIndexEvents(Map<String, List<OperationEvent>> eventMap) {
        super(eventMap);
    }

    public CQAndIndexEvents() {
    }

    @Override
    public void cqCreated(String name, String query, String listeners) {
        if (OperationPrms.recordCqIndexOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_CQ_CREATED";
            event.data = new Object[]{name, query};
            this.addEvent(event);
        }
        HydraUtil.logInfo("CQIndexOperations: Cq create complete");
    }

    @Override
    public void cqStopped(String name, String query) {
        if (OperationPrms.recordCqIndexOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_CQ_STOP";
            event.data = new Object[]{name, query};
            this.addEvent(event);
        }
        HydraUtil.logInfo("CQIndexOperations: Cq stop complete");
    }

    @Override
    public void indexCreated(String name, String expression, String fromClause) {
        if (OperationPrms.recordCqIndexOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_INDEX_CREATED";
            event.data = new Object[]{name, expression, fromClause};
            this.addEvent(event);
        }
        HydraUtil.logInfo("CQIndexOperations: Index create complete");
    }

    @Override
    public void indexRemoved(String name) {
        if (OperationPrms.recordCqIndexOps()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_INDEX_REMOVED";
            event.data = new Object[]{name};
            this.addEvent(event);
        }
        HydraUtil.logInfo("CQIndexOperations: Index create complete");
    }
}

