/*
 * Decompiled with CFR 0.152.
 */
package management.jmx.validation;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import management.jmx.Expectation;
import management.jmx.JMXBlackboard;
import management.jmx.JMXEvent;
import management.jmx.JMXEventRecorder;
import management.jmx.JMXNotification;
import management.jmx.JMXOperation;
import management.jmx.validation.ValidationResult;
import management.util.HydraUtil;
import management.util.ManagementUtil;

public class JMXValidator
implements Serializable {
    List<JMXEvent> events = null;
    List<Expectation> expectedEvents = null;

    public JMXValidator(JMXBlackboard blackboard) {
        this.events = blackboard.getRecordedEvents();
        this.expectedEvents = blackboard.getExpectedState();
    }

    public JMXValidator(JMXEventRecorder recorder, List<Expectation> expectedEvents) {
        this.events = recorder.getRecordedEvents();
        this.expectedEvents = expectedEvents;
    }

    public List<ValidationResult> validate() {
        ArrayList<ValidationResult> list = new ArrayList<ValidationResult>();
        for (Expectation expectation : this.expectedEvents) {
            List<JMXEvent> eventsForThisMbean;
            List<ValidationResult> rsult = this.isExpectationSatisfied(expectation, eventsForThisMbean = this.getEventForThisMbean(this.events, expectation.getObjectName()));
            if (rsult == null) continue;
            list.addAll(rsult);
        }
        return list;
    }

    private List<JMXEvent> getEventForThisMbean(List<JMXEvent> events, ObjectName name) {
        ArrayList<JMXEvent> eventList = new ArrayList<JMXEvent>();
        HydraUtil.logInfo("Filtering out events for mbean objectName " + name);
        for (JMXEvent event : events) {
            if (!name.equals(event.getObjectName())) continue;
            eventList.add(event);
        }
        HydraUtil.logInfo("Filtered " + eventList.size() + " events out of " + events.size());
        return eventList;
    }

    private List<ValidationResult> isExpectationSatisfied(Expectation expectation, List<JMXEvent> events) {
        ArrayList<ValidationResult> list = new ArrayList<ValidationResult>();
        HydraUtil.logInfo("Validating expectation " + expectation);
        String url = expectation.getUrl();
        if (url == null) {
            list.add(ValidationResult.error(expectation.getObjectName(), null, "NO urls specified for the targeted mbean"));
            HydraUtil.logFine("Validation failed url not reachable " + url);
            return list;
        }
        MBeanServerConnection remoteMBS = null;
        ObjectName name = expectation.getObjectName();
        try {
            remoteMBS = !"<local>".equals(url) ? ManagementUtil.connectToUrlOrGemfireProxy(url) : ManagementUtil.getPlatformMBeanServerDW();
        }
        catch (MalformedURLException e) {
            list.add(ValidationResult.jmxError(name, url, e));
            return list;
        }
        catch (IOException e) {
            list.add(ValidationResult.jmxError(name, url, e));
            return list;
        }
        ArrayList<JMXOperation> recordedOpList = new ArrayList<JMXOperation>();
        ArrayList<JMXNotification> recordedNotificationList = new ArrayList<JMXNotification>();
        for (JMXEvent e : events) {
            if (e.isNotification()) {
                recordedNotificationList.add((JMXNotification)e);
            }
            if (!e.isOpertion()) continue;
            recordedOpList.add((JMXOperation)e);
        }
        if (this.validateAttributes(expectation, list, remoteMBS)) {
            return list;
        }
        this.validateOperations(expectation, list, recordedOpList);
        this.validateNotifications(expectation, list, recordedNotificationList);
        return list;
    }

    public boolean validateAttributes(Expectation expectation, List<ValidationResult> list, MBeanServerConnection remoteMBS) {
        String url = expectation.getUrl();
        ObjectName name = expectation.getObjectName();
        Map<String, Object> attributemap = expectation.getAttributes();
        HashMap actualAttributemap = new HashMap();
        for (String attr : attributemap.keySet()) {
            Object attrValue = null;
            try {
                attrValue = remoteMBS.getAttribute(expectation.getObjectName(url), attr);
            }
            catch (AttributeNotFoundException e1) {
                list.add(ValidationResult.jmxError(name, url, e1));
                return true;
            }
            catch (InstanceNotFoundException e1) {
                list.add(ValidationResult.jmxError(name, url, e1));
                return true;
            }
            catch (MBeanException e1) {
                list.add(ValidationResult.jmxError(name, url, e1));
                return true;
            }
            catch (ReflectionException e1) {
                list.add(ValidationResult.jmxError(name, url, e1));
                return true;
            }
            catch (IOException e1) {
                list.add(ValidationResult.jmxError(name, url, e1));
                return true;
            }
            Object expectedValue = attributemap.get(attr);
            if (expectedValue != null && !expectedValue.equals(attrValue)) {
                list.add(ValidationResult.attributeDontMatch(name, url, attr, attrValue, expectedValue));
                continue;
            }
            if (expectedValue == null || !expectedValue.equals(attrValue)) continue;
            HydraUtil.logInfo("Attribute value for attribute " + attr + " matched ");
        }
        return false;
    }

    public void validateOperations(Expectation expectation, List<ValidationResult> list, List<JMXOperation> recordedOpList) {
        ObjectName name = expectation.getObjectName();
        Map<String, Object> expectedOperationMap = expectation.getOperations();
        if (recordedOpList.size() < expectedOperationMap.size()) {
            list.add(ValidationResult.error(name, null, "Some operations are missing from events against the expected operations list recorded=" + recordedOpList.size() + " Expected=" + expectedOperationMap.size()));
            for (String op : expectedOperationMap.keySet()) {
                boolean flag = false;
                for (JMXOperation jmxOp : recordedOpList) {
                    if (!jmxOp.getOperationName().equals(op)) continue;
                    flag = true;
                    Object expected = expectedOperationMap.get(op);
                    Object recorded = jmxOp.getResult();
                    if (jmxOp.isError()) {
                        list.add(ValidationResult.operationResultedInError(name, jmxOp.getSource(), jmxOp.getOperationName(), jmxOp.getError()));
                        break;
                    }
                    if (expected == null || expected.equals(recorded)) break;
                    list.add(ValidationResult.operationResultUnExpected(name, jmxOp.getSource(), jmxOp.getOperationName(), recorded, expected));
                    break;
                }
                if (flag) continue;
                list.add(ValidationResult.error(name, null, "Operation missing " + op));
            }
        } else {
            for (JMXOperation jmxOp : recordedOpList) {
                Object expected = expectedOperationMap.get(jmxOp.getOperationName());
                Object object = jmxOp.getResult();
                if (jmxOp.isError()) {
                    list.add(ValidationResult.operationResultedInError(name, jmxOp.getSource(), jmxOp.getOperationName(), jmxOp.getError()));
                    continue;
                }
                if (expected == null || expected.equals(object)) continue;
                list.add(ValidationResult.operationResultUnExpected(name, jmxOp.getSource(), jmxOp.getOperationName(), object, expected));
            }
        }
    }

    public void validateNotifications(Expectation expectation, List<ValidationResult> list, List<JMXNotification> recordedNotificationList) {
        ObjectName name = expectation.getObjectName();
        String url = expectation.getUrl();
        List<Expectation.ExpectedNotification> expectedNotifications = expectation.getNotifications();
        if (recordedNotificationList.size() < expectedNotifications.size()) {
            list.add(ValidationResult.error(name, null, "Notifications missing recorded=" + recordedNotificationList.size() + " expected=" + expectedNotifications.size()));
        }
        for (Expectation.ExpectedNotification notification : expectedNotifications) {
            boolean flag = false;
            JMXNotification jmxn = null;
            String errorMessage = "";
            int matchCount = 0;
            for (JMXNotification n : recordedNotificationList) {
                flag = false;
                jmxn = n;
                StringBuilder sb = new StringBuilder();
                sb.append(" validatation : ").append(notification).append(" against ").append(n);
                if (n.getJmxNotificaiton().getType().equals(notification.type)) {
                    flag = true;
                    boolean modeMatch = false;
                    switch (notification.matchMode) {
                        case 5: {
                            if (!n.getJmxNotificaiton().getMessage().contains(notification.message)) break;
                            modeMatch = true;
                            break;
                        }
                        case 1: {
                            if (!n.getJmxNotificaiton().getMessage().equals(notification.message)) break;
                            modeMatch = true;
                            break;
                        }
                        case 0: {
                            if (!n.getJmxNotificaiton().getMessage().equals(notification.message) || !n.getJmxNotificaiton().getSource().equals(notification.source)) break;
                            modeMatch = true;
                            break;
                        }
                        case 4: {
                            if (!n.getJmxNotificaiton().getMessage().contains(notification.message) || !n.getJmxNotificaiton().getSource().equals(notification.source)) break;
                            modeMatch = true;
                            break;
                        }
                        case 2: {
                            if (!n.getJmxNotificaiton().getSource().equals(notification.source) || !n.getJmxNotificaiton().getUserData().equals(notification.userData)) break;
                            modeMatch = true;
                            break;
                        }
                        default: {
                            modeMatch = false;
                        }
                    }
                    if (flag && modeMatch) {
                        HydraUtil.logFine("Validation Passed " + sb.toString());
                        flag = true;
                    } else {
                        HydraUtil.logFine("Validation Failed." + sb.toString());
                        flag = false;
                    }
                }
                if (!flag) continue;
                ++matchCount;
            }
            if (jmxn != null && matchCount == 0) {
                switch (notification.matchMode) {
                    case 5: {
                        errorMessage = errorMessage + " Notification messageContains mismatch, expected message=" + HydraUtil.ObjectToString(notification.message);
                        errorMessage = errorMessage + " Notification matchCount mismatch, expected matchCount=" + HydraUtil.ObjectToString(notification.matchCount);
                        break;
                    }
                    case 1: {
                        errorMessage = errorMessage + " Notification message mismatch, expected message=" + HydraUtil.ObjectToString(notification.message);
                        break;
                    }
                    case 4: {
                        errorMessage = "Notification source mismatch, expected source={" + HydraUtil.ObjectToString(notification.source) + "})";
                        errorMessage = errorMessage + " Notification messageContains mismatch, expected message=" + HydraUtil.ObjectToString(notification.message);
                        break;
                    }
                    case 0: {
                        errorMessage = "Notification source mismatch, expected source={" + HydraUtil.ObjectToString(notification.source) + "})";
                        errorMessage = errorMessage + " Notification message mismatch, expected message=" + HydraUtil.ObjectToString(notification.message);
                        break;
                    }
                    case 2: {
                        errorMessage = "Notification source mismatch, expected source={" + HydraUtil.ObjectToString(notification.source) + "})";
                        errorMessage = errorMessage + " Notification userData mismatch, expected data=" + HydraUtil.ObjectToString(notification.userData);
                        break;
                    }
                    default: {
                        errorMessage = "Unknown mode of notification matching";
                    }
                }
                list.add(ValidationResult.missingNotification(name, url, notification.type, errorMessage));
                continue;
            }
            if (matchCount > 1 && notification.matchCount != -1) {
                if (matchCount == notification.matchCount) {
                    HydraUtil.logFine("Validation Passed for match count " + notification.matchCount);
                    continue;
                }
                list.add(ValidationResult.missingNotification(name, url, notification.type, "Match count mismatch expected=" + notification.matchCount + " recorded=" + matchCount));
                continue;
            }
            if (matchCount <= true || notification.matchCount != -1) continue;
            list.add(ValidationResult.error(name, null, "More than one Notification(Count=" + matchCount + ") (Probably #45748) for " + notification));
        }
    }
}

