/*
 * Decompiled with CFR 0.152.
 */
package junitExt;

import junit.framework.Assert;
import junitExt.TestRunnable;

public class MultiThreadedTestRunner {
    private static final Class THIS_CLASS = MultiThreadedTestRunner.class;
    private static final String THIS_CLASS_NAME = THIS_CLASS.getName();
    private static final long DEFAULT_MAX_FINAL_JOIN_TIME = 30000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 86400000L;
    private static final long MIN_WAIT_TIME = 10L;
    private Object synch = new Object();
    private boolean threadsFinished = false;
    private ThreadGroup threadGroup;
    private Thread coreThread;
    private Throwable exception;
    private TestRunnable[] runners;
    private TestRunnable[] monitors;
    private long maxFinalJoinTime = 30000L;
    private long maxWaitTime = 86400000L;
    private boolean performKills = true;

    public MultiThreadedTestRunner(TestRunnable[] tr) {
        this(tr, null);
    }

    public MultiThreadedTestRunner(TestRunnable[] runners, TestRunnable[] monitors) {
        if (runners == null) {
            throw new IllegalArgumentException("no null runners");
        }
        int len = runners.length;
        if (len <= 0) {
            throw new IllegalArgumentException("must have at least one runnable");
        }
        this.runners = new TestRunnable[len];
        System.arraycopy(runners, 0, this.runners, 0, len);
        if (monitors != null) {
            len = monitors.length;
            this.monitors = new TestRunnable[len];
            System.arraycopy(monitors, 0, this.monitors, 0, len);
        } else {
            this.monitors = new TestRunnable[0];
        }
    }

    public void runTestRunnables() throws Throwable {
        this.runTestRunnables(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestRunnables(long maxTime) throws Throwable {
        boolean threadsStillRunning;
        Thread.interrupted();
        this.exception = null;
        this.coreThread = Thread.currentThread();
        this.threadGroup = new ThreadGroup(THIS_CLASS_NAME);
        this.threadsFinished = false;
        Thread[] monitorThreads = this.setupThreads(this.threadGroup, this.monitors);
        Thread[] runnerThreads = this.setupThreads(this.threadGroup, this.runners);
        try {
            threadsStillRunning = this.joinThreads(runnerThreads, maxTime);
        }
        catch (InterruptedException ie) {
            threadsStillRunning = true;
        }
        finally {
            Object ie = this.synch;
            synchronized (ie) {
                if (!this.threadsFinished) {
                    this.interruptThreads();
                }
            }
        }
        if (threadsStillRunning) {
            this.setTimeoutError(maxTime);
            try {
                this.joinThreads(runnerThreads, this.maxFinalJoinTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            int killCount = this.killThreads(runnerThreads);
            if (killCount > 0) {
                this.setTimeoutError(this.maxFinalJoinTime);
            }
        }
        try {
            this.joinThreads(monitorThreads, this.maxFinalJoinTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.killThreads(monitorThreads);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        Object object = this.synch;
        synchronized (object) {
            if (this.exception == null) {
                this.exception = t;
            }
            if (!this.threadsFinished) {
                this.interruptThreads();
            }
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptThreads() {
        Object object = this.synch;
        synchronized (object) {
            if (Thread.currentThread() != this.coreThread) {
                this.coreThread.interrupt();
            }
            this.threadsFinished = true;
            int count = this.threadGroup.activeCount();
            Thread[] t = new Thread[count];
            this.threadGroup.enumerate(t);
            int i = t.length;
            while (--i >= 0) {
                if (t[i] == null || !t[i].isAlive()) continue;
                t[i].interrupt();
            }
        }
    }

    boolean areThreadsFinished() {
        return this.threadsFinished;
    }

    private Thread[] setupThreads(ThreadGroup tg, TestRunnable[] tr) {
        int i;
        int len = tr.length;
        Thread[] threads = new Thread[len];
        for (i = 0; i < len; ++i) {
            tr[i].setTestRunner(this);
            threads[i] = new Thread(tg, tr[i]);
            threads[i].setDaemon(true);
        }
        for (i = 0; i < len; ++i) {
            int count;
            threads[i].start();
            for (count = 0; !threads[i].isAlive() && count < 10; ++count) {
                Thread.yield();
            }
            if (count < 10) continue;
        }
        return threads;
    }

    private boolean joinThreads(Thread[] t, long waitTime) throws InterruptedException {
        if (t == null) {
            return false;
        }
        int len = t.length;
        if (len <= 0) {
            return false;
        }
        if (waitTime < 0L || waitTime > this.maxWaitTime) {
            waitTime = 86400000L;
        }
        boolean threadsRunning = true;
        InterruptedException iex = null;
        long finalTime = System.currentTimeMillis() + waitTime;
        while (threadsRunning && System.currentTimeMillis() < finalTime && iex == null) {
            threadsRunning = false;
            boolean enteredLoop = false;
            for (int i = 0; i < len && System.currentTimeMillis() < finalTime; ++i) {
                enteredLoop = true;
                if (t[i] == null) continue;
                try {
                    t[i].join(10L);
                }
                catch (InterruptedException ex) {
                    iex = ex;
                }
                if (!t[i].isAlive()) {
                    t[i] = null;
                    continue;
                }
                threadsRunning = true;
            }
            threadsRunning = threadsRunning || !enteredLoop;
        }
        if (iex != null) {
            throw iex;
        }
        return threadsRunning;
    }

    private int killThreads(Thread[] t) {
        int killCount = 0;
        for (int i = 0; i < t.length; ++i) {
            int count;
            if (t[i] == null || !t[i].isAlive()) continue;
            ++killCount;
            if (!this.performKills) continue;
            boolean isAlive = t[i].isAlive();
            for (count = 0; isAlive && count < 10; ++count) {
                t[i].stop(new TestDeathException("Thread " + i + " did not die on its own"));
                Thread.yield();
                isAlive = t[i].isAlive();
                if (!isAlive) continue;
                t[i].interrupt();
            }
            if (count >= 10) {
                // empty if block
            }
            t[i] = null;
        }
        return killCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeoutError(long maxTime) {
        Throwable t = this.createTimeoutError(maxTime);
        Object object = this.synch;
        synchronized (object) {
            if (this.exception == null) {
                this.exception = t;
            }
        }
    }

    private Throwable createTimeoutError(long maxTime) {
        Throwable ret = null;
        try {
            Assert.fail((String)("Threads did not finish within " + maxTime + " milliseconds."));
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.fillInStackTrace();
            ret = t;
        }
        return ret;
    }

    public static final class TestDeathException
    extends RuntimeException {
        protected TestDeathException(String msg) {
            super(msg);
        }
    }
}

