/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import jta.JtaBB;
import jta.JtaPrms;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class JtaCacheTestUtil {
    private static final int PUT_OPERATION = 1;
    private static final int GET_OPERATION = 2;
    private static final int UPDATE_OPERATION = 3;

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (CacheHelper.getCache() == null) {
            TransactionWriter txWriter;
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            TransactionListener txListener = JtaPrms.getTxListener();
            if (txListener != null) {
                c.getCacheTransactionManager().setListener(txListener);
                Log.getLogWriter().info("Installed TransactionListener " + txListener);
            }
            if ((txWriter = JtaPrms.getTxWriter()) != null) {
                c.getCacheTransactionManager().setWriter(txWriter);
                Log.getLogWriter().info("Installed TransactionWriter " + txWriter);
            }
            RegionHelper.createRegion(ConfigPrms.getRegionConfig());
            JtaCacheTestUtil.createRootRegions();
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        }
    }

    public static int getRandomOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("put")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 3;
        } else if (operation.equals("get")) {
            op = 2;
        }
        return op;
    }

    public static Region getRandomRegion(Cache cache) {
        return (Region)cache.rootRegions().iterator().next();
    }

    public void doRandomOperation(Region region, int total) {
        block5: for (int count = 0; count < total; ++count) {
            int whichOp = JtaCacheTestUtil.getRandomOperation(JtaPrms.entryOperations);
            switch (whichOp) {
                case 1: {
                    this.doPutOperation(region);
                    continue block5;
                }
                case 2: {
                    JtaCacheTestUtil.doGetOperation(region);
                    continue block5;
                }
                case 3: {
                    this.doUpdateOperation(region);
                    continue block5;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
    }

    private void doUpdateOperation(Region region) {
        Set aSet = region.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = iter.next();
        try {
            Object anObj = region.get(name);
            Integer newObj = this.getRandomInteger();
            region.put(name, (Object)newObj);
            Log.getLogWriter().info("Updated region = " + region + "   key  " + name + "  old value " + anObj + "   new value " + newObj);
        }
        catch (Exception e) {
            throw new TestException("Exception in Update Operation" + TestHelper.getStackTrace(e));
        }
        JtaBB.incrementCounter("DoUpdateOperation", JtaBB.NUM_UPDATE);
    }

    private Integer getRandomInteger() {
        return new Integer(new Random().nextInt(100));
    }

    private static void doGetOperation(Region region) {
        Set aSet = region.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("doGetOperation: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("doGetOperation: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("doGetOperation: getting name " + name);
        try {
            Object anObj = region.get((Object)name);
            Log.getLogWriter().info("doGetOperation: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException("Exception in doGetOperation " + TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException("Exception in doGetOperation " + TestHelper.getStackTrace(e));
        }
        JtaBB.incrementCounter("DoGetOperation", JtaBB.NUM_GET);
    }

    public void doPutOperation(Region region) {
        String name = NameFactory.getNextPositiveObjectName();
        Integer anObj = this.getRandomInteger();
        try {
            region.put((Object)name, (Object)anObj);
        }
        catch (Exception e) {
            throw new TestException("Exception in Put Operation" + TestHelper.getStackTrace(e));
        }
        JtaBB.incrementCounter("DoPutOperation", JtaBB.NUM_CREATE);
    }

    public static void createRootRegions() {
        Cache cache = CacheHelper.getCache();
        int numRegions = cache.rootRegions().toArray().length;
        if (numRegions == 1) {
            String regionConfig = ConfigPrms.getRegionConfig();
            Region aRegion = RegionHelper.createRegion(regionConfig);
            if (aRegion.getAttributes().getPoolName() != null) {
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + aRegion.getFullPath());
            }
            int noOfRootRgn = TestConfig.tab().intAt(JtaPrms.numberOfRandomRegions);
            for (int i = 0; i < noOfRootRgn; ++i) {
                String regionName = "root" + (i + 1);
                aRegion = RegionHelper.createRegion(regionName, regionConfig);
                if (aRegion.getAttributes().getPoolName() == null) continue;
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + aRegion.getFullPath());
            }
        }
    }
}

