/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.sql.Connection;
import java.util.List;
import jta.DBUtil;
import jta.GemFireTxCallback;
import jta.JtaBB;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class GemFireTxDBListener
extends AbstractListener
implements TransactionListener {
    static String tableName = null;

    public void afterCommit(TransactionEvent txEvent) {
        this.logTxEvent("afterCommit", txEvent);
        tableName = (String)JtaBB.getBB().getSharedMap().get(JtaBB.dbTableName);
        try {
            Connection conn = GemFireTxCallback.getDBConnection();
            List txEventList = txEvent.getEvents();
            for (EntryEvent event : txEventList) {
                Operation eventOp = event.getOperation();
                if (eventOp.isCreate()) {
                    this.afterCreate(event, conn);
                    continue;
                }
                if (eventOp.isUpdate()) {
                    this.afterUpdate(event, conn);
                    continue;
                }
                if (eventOp.isDestroy()) {
                    this.afterDestroy(event, conn);
                    continue;
                }
                if (!eventOp.isInvalidate()) continue;
                this.afterInvalidate(event, conn);
            }
            Log.getLogWriter().info("COMMITTING database tx ...");
            conn.commit();
            Log.getLogWriter().info("COMMITTED database tx.");
        }
        catch (Exception e) {
            this.throwException("afterCommit() caught " + e);
        }
    }

    public void afterCreate(EntryEvent event, Connection conn) throws CacheWriterException {
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
        try {
            String sql = "INSERT INTO " + tableName + " VALUES ('" + key + "','" + newValue + "')";
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows updated for create = " + i);
        }
        catch (Exception e) {
            Log.getLogWriter().info("GemFireTxDBListener.afterCreate() caught " + TestHelper.getStackTrace(e));
            throw new CacheWriterException("GemFireTxDBListener.afterCreate() caught " + TestHelper.getStackTrace(e));
        }
    }

    public void afterUpdate(EntryEvent event, Connection conn) throws CacheWriterException {
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
        try {
            String sql = "UPDATE " + tableName + " SET name = '" + newValue + "' WHERE id = ('" + key + "')";
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows updated = " + i);
        }
        catch (Exception e) {
            Log.getLogWriter().info("GemFireTxDBListener.afterUpdate() caught " + e);
            throw new CacheWriterException("GemFireTxDBListener.afterUpdate() caught " + e);
        }
    }

    public void afterDestroy(EntryEvent event, Connection conn) throws CacheWriterException {
        String key = (String)event.getKey();
        String sql = "DELETE FROM " + tableName + " WHERE id = ('" + key + "')";
        try {
            int i = DBUtil.executeUpdate(sql, conn);
            Log.getLogWriter().info("rows destroyed = " + i);
        }
        catch (Exception e) {
            Log.getLogWriter().info("GemFireTxDBListener.afterDestroy() caught " + TestHelper.getStackTrace(e));
            throw new CacheWriterException("GemFireTxDBListener.afterDestroy() caught " + TestHelper.getStackTrace(e));
        }
    }

    public void afterInvalidate(EntryEvent event, Connection conn) throws CacheWriterException {
        String key = (String)event.getKey();
        String newValue = (String)event.getNewValue();
    }

    public void afterRollback(TransactionEvent event) {
        this.logTxEvent("afterRollback", event);
    }

    public void afterFailedCommit(TransactionEvent event) {
        this.logTxEvent("afterFailedCommit", event);
    }

    public void close() {
        Log.getLogWriter().info("TxDBListener: close()");
    }

    protected void throwException(String errStr) {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in " + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        SharedMap aMap = JtaBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

