/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import javax.sql.DataSource;
import jta.JtaPrms;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;

public class DBUtil {
    public static DBUtil dbUtilInstance;
    private OracleDataSource cachedDS = this.createConnectionPool();

    DBUtil() {
    }

    private OracleDataSource createConnectionPool() {
        try {
            OracleDataSource ds = new OracleDataSource();
            ds.setConnectionCacheName("oraCache");
            ds.setConnectionCachingEnabled(true);
            ds.setURL(TestConfig.tab().stringAt(JtaPrms.jdbcUrl));
            ds.setUser(TestConfig.tab().stringAt(JtaPrms.rdbUser));
            ds.setPassword(TestConfig.tab().stringAt(JtaPrms.rdbPassword));
            Properties cacheProps = new Properties();
            cacheProps.setProperty("MinLimit", String.valueOf(TestConfig.tab().intAt(JtaPrms.poolMinLimit)));
            ds.setConnectionCacheProperties(cacheProps);
            return ds;
        }
        catch (Exception ex) {
            Log.getLogWriter().info("Unable to create connection pool: " + ex, (Throwable)ex);
            throw new HydraRuntimeException("Problem creating Oracle connection pool", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBUtil getDBUtil() {
        if (dbUtilInstance != null) return dbUtilInstance;
        Class<DBUtil> clazz = DBUtil.class;
        synchronized (DBUtil.class) {
            if (dbUtilInstance != null) return dbUtilInstance;
            dbUtilInstance = new DBUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbUtilInstance;
        }
    }

    public static Connection getSimpleDSConnection() throws Exception {
        Connection conn;
        if (JtaPrms.useGemFireTransactionManager()) {
            DBUtil dbUtil = DBUtil.getDBUtil();
            conn = dbUtil.cachedDS.getConnection();
        } else {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/SimpleDataSource");
            conn = ds.getConnection();
        }
        return conn;
    }

    public static Connection getXADSConnection() throws Exception {
        Connection conn;
        if (JtaPrms.useGemFireTransactionManager()) {
            DBUtil dbUtil = DBUtil.getDBUtil();
            conn = dbUtil.cachedDS.getConnection();
        } else {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            DataSource ds = (DataSource)ctx.lookup("java:/XAHydraPooledDataSource");
            conn = ds.getConnection();
        }
        conn.setAutoCommit(false);
        return conn;
    }

    public static void displayData(String tableName) throws Exception {
        Log.getLogWriter().info("display rows from " + tableName);
        Log.getLogWriter().info("DB state is " + DBUtil.getData(tableName));
    }

    public static Map getData(String tableName) throws Exception {
        Connection conn = DBUtil.getSimpleDSConnection();
        String sql = "SELECT * FROM " + tableName;
        ResultSet rs = DBUtil.executeResultSet(sql, conn);
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (rs.next()) {
            String key = rs.getString(1);
            String value = rs.getString(2);
            map.put(key, value);
        }
        if (rs != null) {
            rs.close();
        }
        if (conn != null) {
            conn.close();
        }
        return map;
    }

    public static String getDBValue(String tableName, String key) throws Exception {
        Connection conn = DBUtil.getXADSConnection();
        String sql = "SELECT name FROM " + tableName + " WHERE id = '" + key + "'";
        String value = "-1";
        try {
            Log.getLogWriter().info("Executing " + sql + " on connection " + conn.toString());
            ResultSet rs = DBUtil.executeResultSet(sql, conn);
            rs.next();
            value = rs.getString(1);
            if (value == null || value.equals("")) {
                throw new SQLException("Null ResultSet in getDBValue ");
            }
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            conn.close();
            Log.getLogWriter().info("DBUtil.getDBValue() caught exception " + e);
            throw e;
        }
        return value;
    }

    static void dropTable(String tableName) throws Exception {
        Connection conn = DBUtil.getSimpleDSConnection();
        Statement stm = conn.createStatement();
        String dropTableSql = "DROP TABLE " + tableName;
        Log.getLogWriter().info("Executing " + dropTableSql);
        stm.execute(dropTableSql);
        if (stm != null) {
            stm.close();
        }
    }

    static void createTable(String tableName) throws Exception {
        Connection conn = DBUtil.getSimpleDSConnection();
        Statement stm = conn.createStatement();
        String sql = "CREATE TABLE " + tableName + " (id varchar(5) NOT NULL, name varchar(50), PRIMARY KEY(id))";
        Log.getLogWriter().info("create table statement = " + sql);
        stm = conn.createStatement();
        stm.executeUpdate(sql);
        String key = null;
        for (int i = 1; i <= 4; ++i) {
            key = "key" + i;
            sql = "INSERT INTO " + tableName + " VALUES ('" + key + "','value0')";
            Log.getLogWriter().info("insert row = " + sql);
            stm.addBatch(sql);
        }
        stm.executeBatch();
        conn.commit();
        if (stm != null) {
            stm.close();
        }
        if (conn != null) {
            conn.close();
        }
        Log.getLogWriter().info("Created table " + tableName + " in database");
        DBUtil.displayData(tableName);
    }

    public static ResultSet executeResultSet(String sql, Connection conn) throws Exception {
        ResultSet rs = null;
        Statement stm = conn.createStatement();
        rs = stm.executeQuery(sql);
        return rs;
    }

    public static int executeUpdate(String sql, Connection conn) throws Exception {
        Statement stm = conn.createStatement();
        int count = stm.executeUpdate(sql);
        if (stm != null) {
            stm.close();
        }
        return count;
    }

    public static DataSource getOraclePooledDataSource() throws SQLException {
        OracleConnectionPoolDataSource ds = new OracleConnectionPoolDataSource();
        ds.setURL(TestConfig.tab().stringAt(JtaPrms.jdbcUrl));
        ds.setUser(TestConfig.tab().stringAt(JtaPrms.rdbUser));
        ds.setPassword(TestConfig.tab().stringAt(JtaPrms.rdbPassword));
        return ds;
    }
}

