/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.wan;

import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.internal.GemFireVersion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.GatewayHubHelper;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.RegionHelper;

public class WANClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createRegionTask() {
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
    }

    public static void reportGatewayAttributesTask() {
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub == null) {
            throw new HydraConfigException("Gateway not configured");
        }
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + ", the gateway hub and its gateways are " + GatewayHubHelper.gatewayHubToString(hub);
        Log.getLogWriter().info(s);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }
}

