/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.replication;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import hydra.DiskStoreHelper;
import hydra.HydraConfigException;

public class VersionHelper {
    protected static String getGatewayConflictResolver(Cache c) {
        GatewayConflictResolver gcr = c.getGatewayConflictResolver();
        return gcr == null ? null : c.toString();
    }

    protected static String getDiskAttributes(Region r) {
        String dsn = r.getAttributes().getDiskStoreName();
        if (dsn == null) {
            throw new HydraConfigException("Persistence is not configured");
        }
        DiskStore ds = DiskStoreHelper.getDiskStore(dsn);
        return "the DiskStore is" + ds + ", the allow force compaction is " + ds.getAllowForceCompaction() + ", the auto compact is " + ds.getAutoCompact() + ", the compaction threshold is " + ds.getCompactionThreshold() + ", the disk dir num is " + ds.getDiskDirs().length + ", the max oplog size is " + ds.getMaxOplogSize() + ", the queue size is " + ds.getQueueSize() + ", the synchronous (from the region) is " + r.getAttributes().isDiskSynchronous();
    }

    protected static String getResourceManager(Cache c) {
        return c.getResourceManager().toString();
    }

    protected static String getMaximum(EvictionAttributes ea) {
        return "undefined";
    }

    protected static String getInterval(EvictionAttributes ea) {
        return "undefined";
    }

    protected static String getObjectSizer(EvictionAttributes ea) {
        ObjectSizer o = ea.getObjectSizer();
        if (o == null) {
            return "none";
        }
        return o.getClass().getName();
    }
}

