/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.replication;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.GemFireVersion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.RegionHelper;
import hydratest.version.replication.VersionHelper;

public class ReplicationClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createRegionTask() {
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
    }

    public static void reportCacheTask() {
        Cache c = CacheHelper.getCache();
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + ", the Cache is " + c + ", the resource manager is " + VersionHelper.getResourceManager(c) + ", the gateway conflict resolver is " + VersionHelper.getGatewayConflictResolver(c);
        Log.getLogWriter().info(s);
    }

    public static void reportDiskAttributesTask() {
        Region r = RegionHelper.getRegion("DefaultRegion");
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + ", " + VersionHelper.getDiskAttributes(r);
        Log.getLogWriter().info(s);
    }

    public static void reportEvictionAttributesTask() {
        Region r = RegionHelper.getRegion("DefaultRegion");
        RegionAttributes ra = r.getAttributes();
        EvictionAttributes ea = ra.getEvictionAttributes();
        if (ea == null) {
            throw new HydraConfigException("Eviction is not configured");
        }
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + ", the EvictionAttributes are" + ea + ", the maximum is " + VersionHelper.getMaximum(ea) + ", the interval is " + VersionHelper.getInterval(ea) + ", the object sizer is " + VersionHelper.getObjectSizer(ea) + ", the eviction action is " + ea.getAction();
        Log.getLogWriter().info(s);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }
}

