/*
 * Decompiled with CFR 0.152.
 */
package hydratest.version.partition;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.internal.GemFireVersion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydratest.version.partition.VersionHelper;

public class PartitionClient {
    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createAsyncEventQueueTask() {
        String result = VersionHelper.createAsyncEventQueue(ConfigPrms.getAsyncEventQueueConfig());
        Log.getLogWriter().info("Task created async event queue: " + result);
    }

    public static void createRegionTask() {
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
    }

    public static void reportPartitionAttributesTask() {
        Region r = RegionHelper.getRegion("DefaultRegion");
        RegionAttributes ra = r.getAttributes();
        PartitionAttributes pa = ra.getPartitionAttributes();
        if (pa == null) {
            throw new HydraConfigException("Partitioning not configured");
        }
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + " GemFirePrms deltaPropagation is " + VersionHelper.getDeltaPropagation(DistributedSystemHelper.getDistributedSystem().getProperties()) + ", RegionAttributes cloningEnabled is " + VersionHelper.getCloningEnabled(ra) + ", the PartitionAttributes are " + pa + ", the partition resolver is " + VersionHelper.getPartitionResolver(pa) + ", the colocated with is " + VersionHelper.getColocatedWith(pa) + ", the recovery delay is " + VersionHelper.getRecoveryDelay(pa) + ", the startup recovery delay is " + VersionHelper.getStartupRecoveryDelay(pa);
        Log.getLogWriter().info(s);
    }

    public static void reportPoolConfigurationTask() {
        Region r = RegionHelper.getRegion("DefaultRegion");
        RegionAttributes ra = r.getAttributes();
        String poolName = ra.getPoolName();
        if (poolName == null) {
            throw new HydraConfigException("Pool not configured");
        }
        Pool pool = PoolHelper.getPool(poolName);
        String s = "In GemFire version " + GemFireVersion.getGemFireVersion() + ", the pool configuration is " + PoolHelper.poolToString(pool) + ", the multiuser authentication is " + VersionHelper.getMultiuserAuthentication(pool) + ", the PR single hop enabled is " + VersionHelper.getPRSingleHopEnabled(pool);
        Log.getLogWriter().info(s);
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }
}

