/*
 * Decompiled with CFR 0.152.
 */
package hydratest;

import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.blackboard.AnyCyclicBarrier;
import hydra.blackboard.SharedLock;
import hydratest.HydraTestBlackboard;
import hydratest.HydraTestPrms;
import hydratest.TaskAttributes;
import java.util.Vector;

public class TaskClient {
    public static void tryItOut() {
    }

    public static void tryItOut1() {
    }

    public static void tryItOut2() {
    }

    public static void tryItOut3() {
    }

    public static void tryItOut4() {
    }

    public static void tryItOut4WithHeapDump() {
        String clientName = RemoteTestModule.getMyClientName();
        HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
        ProcessMgr.dumpHeap(hd.getHostName(), RemoteTestModule.getMyPid(), hd.getUserDir(), TestConfig.tab().stringAt(Prms.jmapHeapDumpOptions, null));
        throw new StopSchedulingTaskOnClientOrder();
    }

    public static void tryItOut5() {
    }

    public static void tryItOut6() {
    }

    public static void tryItOutRobinG() {
        Log.getLogWriter().info("Got " + TestConfig.tab().intAt(HydraTestPrms.prm01));
    }

    public static void tryItOutStopSchedulingOrder() {
        throw new StopSchedulingOrder("arbitrary decision by client");
    }

    public static void tryItOutStopSchedulingTaskOnClientOrder() {
        String s = "this client is done with this task";
        throw new StopSchedulingTaskOnClientOrder(s);
    }

    public static void tryItOutAttributes() {
        String name = TestConfig.tasktab().stringAt(TaskAttributes.name, "nobody");
        Log.getLogWriter().info("Hi, my name is " + name);
    }

    public static void tryItOutAttributesOneOf() {
        String name = TestConfig.tasktab().stringAt(TaskAttributes.names, "nobody");
        Log.getLogWriter().info("Hi, my name is " + name);
    }

    public static void tryItOutException() {
        throw new HydraRuntimeException("yo");
    }

    public static void tryItOutHydraTimeoutException() {
        throw new HydraTimeoutException("yo");
    }

    public static void tryItOutAnotherException() {
        Vector<String> myVec = new Vector<String>();
        myVec.add("yo");
        myVec.elementAt(2);
    }

    public static void tryItOutSleep() {
        MasterController.sleepForMs(500000);
    }

    public static void tryItOutCompute() {
        Vector<Double> v = new Vector<Double>();
        double d = 542.9;
        for (int i = 0; i < 50000; ++i) {
            double a = d / (double)i;
            v.add(0, new Double(a));
        }
    }

    public static void tryItOutLock() {
        SharedLock lock = HydraTestBlackboard.getInstance().getSharedLock();
        lock.lock();
        Log.getLogWriter().info("Locked shared lock");
        MasterController.sleepForMs(250);
        Log.getLogWriter().info("Unlocking shared lock");
        lock.unlock();
    }

    public static void tryItOutLockStress() {
        SharedLock lock = HydraTestBlackboard.getInstance().getSharedLock();
        for (int i = 0; i < 100; ++i) {
            lock.lock();
            lock.unlock();
        }
    }

    public static void tryItOutLockBad1() {
        SharedLock lock = HydraTestBlackboard.getInstance().getSharedLock();
        lock.lock();
        lock.unlock();
        lock.unlock();
    }

    public static void tryItOutLockBad2() {
        SharedLock lock = HydraTestBlackboard.getInstance().getSharedLock();
        lock.lock();
        lock.lock();
        lock.unlock();
    }

    public static void tryItOutNever() {
        throw new HydraRuntimeException("Should not run");
    }

    public static void shutdownHook() {
        Log.getLogWriter().info("Shutdown hook invoked");
    }

    public static void shutdownHookError() {
        Log.getLogWriter().info("Shutdown hook invoked with error");
        throw new HydraRuntimeException("intentional");
    }

    public static void shutdownHookTimeout() {
        Log.getLogWriter().info("Shutdown hook invoked with timeout");
        MasterController.sleepForMs(10000000);
    }

    public static void checkExtraVMArgs() {
        String clientName = RemoteTestModule.getMyClientName();
        String vendor = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription().getJavaVendor();
        if (vendor.equals("Hitachi")) {
            TaskClient.checkArg(vendor, "generic", vendor);
            TaskClient.checkArg(vendor, "moregeneric", null);
            TaskClient.checkArg(vendor, "evenmoregeneric", null);
            TaskClient.checkArg(vendor, "specific", vendor);
            TaskClient.checkArg(vendor, "morespecific", vendor);
        } else if (vendor.equals("IBM")) {
            TaskClient.checkArg(vendor, "generic", vendor);
            TaskClient.checkArg(vendor, "moregeneric", vendor);
            TaskClient.checkArg(vendor, "evenmoregeneric", vendor);
            TaskClient.checkArg(vendor, "specific", vendor);
            TaskClient.checkArg(vendor, "morespecific", vendor);
        } else if (vendor.equals("JRockit")) {
            TaskClient.checkArg(vendor, "generic", vendor);
            TaskClient.checkArg(vendor, "moregeneric", null);
            TaskClient.checkArg(vendor, "evenmoregeneric", null);
            TaskClient.checkArg(vendor, "specific", vendor);
            TaskClient.checkArg(vendor, "morespecific", null);
        } else if (vendor.equals("Sun")) {
            TaskClient.checkArg(vendor, "generic", vendor);
            TaskClient.checkArg(vendor, "moregeneric", vendor);
            TaskClient.checkArg(vendor, "evenmoregeneric", null);
            TaskClient.checkArg(vendor, "specific", vendor + "override");
            TaskClient.checkArg(vendor, "morespecific", null);
        } else {
            String s = "Unknown java vendor: " + vendor;
            throw new HydraConfigException(s);
        }
    }

    private static void checkArg(String vendor, String arg, String expected) {
        String value = System.getProperty(arg);
        if (expected == null && value != null || expected != null && !expected.equals(value)) {
            String s = vendor + " got  wrong value for " + arg + ",  expected " + expected + ", got " + value;
            throw new HydraRuntimeException(s);
        }
    }

    public static void blackboardTest() {
        String bbname = String.valueOf(RemoteTestModule.getMyVmid());
        HydraTestBlackboard bb = HydraTestBlackboard.getInstance(bbname);
        try {
            bb.getSharedLock().lock();
            Integer counter = (Integer)bb.getSharedMap().get("mine");
            if (counter == null) {
                bb.getSharedMap().put("mine", 1);
            } else {
                bb.getSharedMap().put("mine", counter + 1);
            }
        }
        finally {
            bb.getSharedLock().unlock();
        }
    }

    public static void blackboardTestResult() {
        String bbname = String.valueOf(RemoteTestModule.getMyVmid());
        HydraTestBlackboard bb = HydraTestBlackboard.getInstance(bbname);
        Log.getLogWriter().info("BB " + bbname + "=" + bb.getSharedMap().get("mine"));
    }

    public static void barrierTask() {
        int n = TaskClient.numThreads();
        AnyCyclicBarrier barrier = AnyCyclicBarrier.lookup(n, "barrier");
        Log.getLogWriter().info("Waiting for " + n + " to meet at barrier");
        barrier.await();
        TaskClient.passedBarrier();
    }

    private static void passedBarrier() {
        Log.getLogWriter().info("Passed the barrier");
    }

    public static int numThreads() {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        int t = task.getTotalThreads();
        return t;
    }
}

