/*
 * Decompiled with CFR 0.152.
 */
package hydra.training;

import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import hydra.training.RBQPrms;

public class RBQBlackboard
extends Blackboard {
    static final String BB_NAME = "RBQBlackboard";
    static final String BB_TYPE = "RMI";
    public static int MinOfferTime;
    public static int MaxOfferTime;
    public static int MinPollTime;
    public static int MaxPollTime;
    public static int NumOffers;
    public static int NumPolls;
    public static int MyCounter;
    static final String CapacityKey = "capacity";
    public static RBQBlackboard bbInstance;

    public static synchronized RBQBlackboard getBB() {
        if (bbInstance == null) {
            bbInstance = new RBQBlackboard(BB_NAME, BB_TYPE);
        }
        return bbInstance;
    }

    public RBQBlackboard() {
    }

    private RBQBlackboard(String name, String type) {
        super(name, type, RBQBlackboard.class);
    }

    void initializeCapacity() {
        int capacity = RBQPrms.getQueueCapacity();
        SharedMap map = this.getSharedMap();
        map.put(CapacityKey, new Integer(capacity));
    }

    public int getQueueCapacity() {
        SharedMap map = this.getSharedMap();
        return (Integer)map.get(CapacityKey);
    }

    public long getMinOfferTime() {
        return this.getSharedCounters().read(MinOfferTime);
    }

    public long getMaxOfferTime() {
        return this.getSharedCounters().read(MaxOfferTime);
    }

    public long getNumOffers() {
        return this.getSharedCounters().read(NumOffers);
    }

    public long getMinPollTime() {
        return this.getSharedCounters().read(MinPollTime);
    }

    public long getMaxPollTime() {
        return this.getSharedCounters().read(MaxPollTime);
    }

    public long getNumPolls() {
        return this.getSharedCounters().read(NumPolls);
    }

    public long getMyCounter() {
        return this.getSharedCounters().read(MyCounter);
    }

    void noteOffer(long duration) {
        SharedCounters sc = this.getSharedCounters();
        sc.setIfLarger(MaxOfferTime, duration);
        sc.setIfSmaller(MinOfferTime, duration);
        sc.increment(NumOffers);
    }

    void notePoll(long duration) {
        SharedCounters sc = this.getSharedCounters();
        sc.setIfLarger(MaxPollTime, duration);
        sc.setIfSmaller(MinPollTime, duration);
        sc.increment(NumPolls);
        String threadName = "Polls for " + Thread.currentThread().getName();
        SharedMap map = this.getSharedMap();
        Long threadCount = (Long)map.get(threadName);
        if (threadCount == null) {
            threadCount = new Long(0L);
        }
        map.put(threadName, new Long(threadCount + 1L));
    }

    static {
        MyCounter = 11;
        bbInstance = null;
    }
}

