/*
 * Decompiled with CFR 0.152.
 */
package hydra.training;

import hydra.Log;
import hydra.training.Client;
import hydra.training.ServerPrms;
import java.io.IOException;

public class ClientTasks {
    private static boolean failedOver = false;

    public static void connect() throws IOException {
        Client client = new Client();
        client.connect(ServerPrms.getPort());
    }

    public static void connectAndFailover() throws IOException {
        Client client = new Client();
        try {
            client.connect(ServerPrms.getPort());
        }
        catch (IOException ex) {
            failedOver = true;
            if (ServerPrms.debug()) {
                Log.getLogWriter().info("Client failing over", (Throwable)ex);
            }
            client.connect(ServerPrms.getFailoverPort());
        }
    }

    public static void checkFailover() {
        if (!failedOver) {
            String s = "Client did not fail over";
            throw new IllegalStateException(s);
        }
    }
}

