/*
 * Decompiled with CFR 0.152.
 */
package hydra.timeserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class TimeResponse {
    private final byte packetId;
    private final long timeStamp;

    public TimeResponse(byte packetId, long timeStamp) {
        this.packetId = packetId;
        this.timeStamp = timeStamp;
    }

    public byte getPacketId() {
        return this.packetId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(ba);
        try {
            dataOut.writeByte(this.packetId);
            dataOut.writeLong(this.timeStamp);
            dataOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("ByteArrayOutputStream will not throw an IOException");
        }
        return ba.toByteArray();
    }

    public static TimeResponse fromByteArray(byte[] bytes) throws IOException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        DataInputStream dataIn = new DataInputStream(bi);
        byte packetId = dataIn.readByte();
        long timeStamp = dataIn.readLong();
        return new TimeResponse(packetId, timeStamp);
    }
}

