/*
 * Decompiled with CFR 0.152.
 */
package hydra.timeserver;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.timeserver.TimeRequest;
import hydra.timeserver.TimeResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class TimeProtocolHandler {
    private final String serverHost;
    private final int serverPort;
    private final boolean useNanoTime;
    private byte packetId = 0;
    private final DatagramSocket socket;
    private final InetAddress address;
    private final int socketTimeout;

    public TimeProtocolHandler(String serverHost, int serverPort, int socketTimeout, boolean useNanoTime) throws SocketException, UnknownHostException {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.socketTimeout = socketTimeout;
        this.useNanoTime = useNanoTime;
        this.address = InetAddress.getByName(this.serverHost);
        this.socket = new DatagramSocket();
        try {
            this.socket.setSoTimeout(socketTimeout);
            this.socket.setReceiveBufferSize(32);
            this.socket.setSendBufferSize(32);
        }
        catch (SocketException e) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public SkewData checkSkew() throws SocketTimeoutException, IOException {
        this.packetId = (byte)(this.packetId + 1);
        TimeRequest request = new TimeRequest(this.packetId, this.useNanoTime);
        byte[] buf = request.toByteArray();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, this.address, this.serverPort);
        long localStartTime = this.getLocalTime();
        if (SystemFailure.getFailure() != null) {
            DatagramSocket s = this.socket;
            if (s != null) {
                s.close();
            }
            SystemFailure.checkFailure();
        }
        this.socket.send(packet);
        buf = new byte[32];
        packet = new DatagramPacket(buf, buf.length);
        boolean receivedResponse = false;
        long endTime = System.currentTimeMillis() + (long)this.socketTimeout;
        long serverTime = -1L;
        while (!receivedResponse && System.currentTimeMillis() < endTime) {
            this.socket.receive(packet);
            TimeResponse serverData = TimeResponse.fromByteArray(packet.getData());
            receivedResponse = serverData.getPacketId() == this.packetId;
            serverTime = serverData.getTimeStamp();
        }
        if (!receivedResponse) {
            throw new SocketTimeoutException();
        }
        long localEndTime = this.getLocalTime();
        return new SkewData(localStartTime, localEndTime, serverTime);
    }

    private long getLocalTime() {
        if (this.useNanoTime) {
            return NanoTimer.getTime();
        }
        return System.currentTimeMillis();
    }

    public void close() {
        this.socket.close();
    }

    public static class SkewData {
        private final long localStartTime;
        private final long localEndTime;
        private final long serverTime;

        public SkewData(long localStartTime, long localEndTime, long serverTime) {
            this.localStartTime = localStartTime;
            this.localEndTime = localEndTime;
            this.serverTime = serverTime;
        }

        public long getLocalEndTime() {
            return this.localEndTime;
        }

        public long getLocalStartTime() {
            return this.localStartTime;
        }

        public long getServerTime() {
            return this.serverTime;
        }

        public long getSkew() {
            return this.localEndTime - this.serverTime - this.getLatency();
        }

        public long getLatency() {
            return (this.localEndTime - this.localStartTime) / 2L;
        }
    }
}

