/*
 * Decompiled with CFR 0.152.
 */
package hydra.log;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.org.jgroups.util.StringId;
import hydra.HydraRuntimeException;
import hydra.log.CircularOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Handler;

public class AnyLogWriter
implements LogWriter,
LogWriterI18n {
    private boolean FILE_LOGGING;
    private LogWriter file;

    public AnyLogWriter(String levelName) {
        this.FILE_LOGGING = true;
        int level = LogWriterImpl.levelNameToCode((String)levelName);
        this.file = new LocalLogWriter(level, System.out);
    }

    public AnyLogWriter(String filePrefix, String levelName, boolean append) {
        FileOutputStream fos;
        this.FILE_LOGGING = true;
        String fn = filePrefix + ".log";
        try {
            fos = new FileOutputStream(fn, append);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to open " + fn, e);
        }
        PrintStream ps = new PrintStream(fos, true);
        System.setOut(ps);
        System.setErr(ps);
        int level = LogWriterImpl.levelNameToCode((String)levelName);
        this.file = new LocalLogWriter(level, ps);
    }

    public AnyLogWriter(String filePrefix, String levelName, String dir, boolean append) {
        FileOutputStream fos;
        this.FILE_LOGGING = true;
        String fn = dir + File.separator + filePrefix + ".log";
        try {
            fos = new FileOutputStream(fn, append);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to open " + fn, e);
        }
        PrintStream ps = new PrintStream(fos, true);
        System.setOut(ps);
        System.setErr(ps);
        int level = LogWriterImpl.levelNameToCode((String)levelName);
        this.file = new LocalLogWriter(level, ps);
    }

    public AnyLogWriter(String filePrefix, boolean fileLogging, String fileLogLevelName, int fileMaxKBPerVM) {
        if (fileLogging) {
            CircularOutputStream cos;
            this.FILE_LOGGING = fileLogging;
            if (fileMaxKBPerVM < 0) {
                throw new IllegalArgumentException("Illegal (negative) file log length: " + fileMaxKBPerVM);
            }
            int maxBytes = fileMaxKBPerVM * 1024;
            String fn = filePrefix + ".log";
            try {
                cos = new CircularOutputStream(fn, maxBytes);
            }
            catch (IOException e) {
                throw new HydraRuntimeException("Unable to create " + fn, e);
            }
            int level = LogWriterImpl.levelNameToCode((String)fileLogLevelName);
            this.file = new LocalLogWriter(level, new PrintStream(cos));
        }
    }

    public int getLevel() {
        if (this.FILE_LOGGING) {
            return ((LocalLogWriter)this.file).getLevel();
        }
        return Integer.MAX_VALUE;
    }

    public void setLevel(int newLevel) {
        if (this.FILE_LOGGING) {
            ((LocalLogWriter)this.file).setLevel(newLevel);
        }
    }

    public boolean severeEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.severeEnabled();
        }
        return false;
    }

    public void severe(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.severe(msg, ex);
        }
    }

    public void severe(String msg) {
        if (this.FILE_LOGGING) {
            this.file.severe(msg);
        }
    }

    public void severe(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.severe(ex);
        }
    }

    public boolean errorEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.errorEnabled();
        }
        return false;
    }

    public void error(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.error(msg, ex);
        }
    }

    public void error(String msg) {
        if (this.FILE_LOGGING) {
            this.file.error(msg);
        }
    }

    public void error(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.error(ex);
        }
    }

    public boolean warningEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.warningEnabled();
        }
        return false;
    }

    public void warning(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.warning(msg, ex);
        }
    }

    public void warning(String msg) {
        if (this.FILE_LOGGING) {
            this.file.warning(msg);
        }
    }

    public void warning(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.warning(ex);
        }
    }

    public boolean infoEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.infoEnabled();
        }
        return false;
    }

    public void info(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.info(msg, ex);
        }
    }

    public void info(String msg) {
        if (this.FILE_LOGGING) {
            this.file.info(msg);
        }
    }

    public void info(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.info(ex);
        }
    }

    public boolean configEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.configEnabled();
        }
        return false;
    }

    public void config(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.config(msg, ex);
        }
    }

    public void config(String msg) {
        if (this.FILE_LOGGING) {
            this.file.config(msg);
        }
    }

    public void config(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.config(ex);
        }
    }

    public boolean fineEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.fineEnabled();
        }
        return false;
    }

    public void fine(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.fine(msg, ex);
        }
    }

    public void fine(String msg) {
        if (this.FILE_LOGGING) {
            this.file.fine(msg);
        }
    }

    public void fine(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.fine(ex);
        }
    }

    public boolean finerEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.finerEnabled();
        }
        return false;
    }

    public void finer(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.finer(msg, ex);
        }
    }

    public void finer(String msg) {
        if (this.FILE_LOGGING) {
            this.file.finer(msg);
        }
    }

    public void finer(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.finer(ex);
        }
    }

    public boolean finestEnabled() {
        if (this.FILE_LOGGING) {
            return this.file.finestEnabled();
        }
        return false;
    }

    public void finest(String msg, Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.finest(msg, ex);
        }
    }

    public void finest(String msg) {
        if (this.FILE_LOGGING) {
            this.file.finest(msg);
        }
    }

    public void finest(Throwable ex) {
        if (this.FILE_LOGGING) {
            this.file.finest(ex);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.FILE_LOGGING) {
            this.file.entering(sourceClass, sourceMethod);
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.FILE_LOGGING) {
            this.file.exiting(sourceClass, sourceMethod);
        }
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.FILE_LOGGING) {
            this.file.throwing(sourceClass, sourceMethod, thrown);
        }
    }

    public Handler getHandler() {
        return null;
    }

    public void config(StringId msgId, Object param, Throwable ex) {
        this.config(msgId.toLocalizedString(new Object[]{param}), ex);
    }

    public void config(StringId msgId, Object param) {
        this.config(msgId.toLocalizedString(new Object[]{param}));
    }

    public void config(StringId msgId, Object[] params, Throwable ex) {
        this.config(msgId.toLocalizedString(params), ex);
    }

    public void config(StringId msgId, Object[] params) {
        this.config(msgId.toLocalizedString(params));
    }

    public void config(StringId msgId, Throwable ex) {
        this.config(msgId.toLocalizedString(), ex);
    }

    public void config(StringId msgId) {
        this.config(msgId.toLocalizedString());
    }

    public void error(StringId msgId, Object param, Throwable ex) {
        this.error(msgId.toLocalizedString(new Object[]{param}), ex);
    }

    public void error(StringId msgId, Object param) {
        this.error(msgId.toLocalizedString(new Object[]{param}));
    }

    public void error(StringId msgId, Object[] params, Throwable ex) {
        this.error(msgId.toLocalizedString(params), ex);
    }

    public void error(StringId msgId, Object[] params) {
        this.error(msgId.toLocalizedString(params));
    }

    public void error(StringId msgId, Throwable ex) {
        this.error(msgId.toLocalizedString(), ex);
    }

    public void error(StringId msgId) {
        this.error(msgId.toLocalizedString());
    }

    public void info(StringId msgId, Object param, Throwable ex) {
        this.info(msgId.toLocalizedString(new Object[]{param}), ex);
    }

    public void info(StringId msgId, Object param) {
        this.info(msgId.toLocalizedString(new Object[]{param}));
    }

    public void info(StringId msgId, Object[] params, Throwable ex) {
        this.info(msgId.toLocalizedString(params), ex);
    }

    public void info(StringId msgId, Object[] params) {
        this.info(msgId.toLocalizedString(params));
    }

    public void info(StringId msgId, Throwable ex) {
        this.info(msgId.toLocalizedString(), ex);
    }

    public void info(StringId msgId) {
        this.info(msgId.toLocalizedString());
    }

    public void severe(StringId msgId, Object param, Throwable ex) {
        this.severe(msgId.toLocalizedString(new Object[]{param}), ex);
    }

    public void severe(StringId msgId, Object param) {
        this.severe(msgId.toLocalizedString(new Object[]{param}));
    }

    public void severe(StringId msgId, Object[] params, Throwable ex) {
        this.severe(msgId.toLocalizedString(params), ex);
    }

    public void severe(StringId msgId, Object[] params) {
        this.severe(msgId.toLocalizedString(params));
    }

    public void severe(StringId msgId, Throwable ex) {
        this.severe(msgId.toLocalizedString(), ex);
    }

    public void severe(StringId msgId) {
        this.severe(msgId.toLocalizedString());
    }

    public void warning(StringId msgId, Object param, Throwable ex) {
        this.warning(msgId.toLocalizedString(new Object[]{param}), ex);
    }

    public void warning(StringId msgId, Object param) {
        this.warning(msgId.toLocalizedString(new Object[]{param}));
    }

    public void warning(StringId msgId, Object[] params, Throwable ex) {
        this.warning(msgId.toLocalizedString(params), ex);
    }

    public void warning(StringId msgId, Object[] params) {
        this.warning(msgId.toLocalizedString(params));
    }

    public void warning(StringId msgId, Throwable ex) {
        this.warning(msgId.toLocalizedString(), ex);
    }

    public void warning(StringId msgId) {
        this.warning(msgId.toLocalizedString());
    }

    public LogWriter convertToLogWriter() {
        return this;
    }

    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }
}

