/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import hydra.blackboard.SharedCounters;

public class SharedCountersImpl
implements SharedCounters {
    private long[] counters;

    public SharedCountersImpl(long[] initialValues) {
        this.counters = initialValues;
    }

    @Override
    public long read(int index) {
        return this.counters[index];
    }

    @Override
    public long add(int index, long i) {
        int n = index;
        this.counters[n] = this.counters[n] + i;
        return this.counters[index];
    }

    @Override
    public long subtract(int index, long i) {
        int n = index;
        this.counters[n] = this.counters[n] - i;
        return this.counters[index];
    }

    @Override
    public void increment(int index) {
        int n = index;
        this.counters[n] = this.counters[n] + 1L;
    }

    @Override
    public void decrement(int index) {
        int n = index;
        this.counters[n] = this.counters[n] - 1L;
    }

    @Override
    public long incrementAndRead(int index) {
        int n = index;
        this.counters[n] = this.counters[n] + 1L;
        return this.counters[index];
    }

    @Override
    public long decrementAndRead(int index) {
        int n = index;
        this.counters[n] = this.counters[n] - 1L;
        return this.counters[index];
    }

    @Override
    public void zero(int index) {
        this.counters[index] = 0L;
    }

    @Override
    public void setIfLarger(int index, long i) {
        if (i > this.counters[index]) {
            this.counters[index] = i;
        }
    }

    @Override
    public void setIfSmaller(int index, long i) {
        if (i < this.counters[index]) {
            this.counters[index] = i;
        }
    }

    @Override
    public long[] getCounterValues() {
        return this.counters;
    }
}

