/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.blackboard.RmiSharedCounters;
import hydra.blackboard.RmiSharedCountersImpl;
import hydra.blackboard.SharedCounters;
import java.rmi.RemoteException;

public class AnySharedCountersImpl
implements SharedCounters {
    private String name;
    private int type = -1;
    private LogWriter log;
    private RmiSharedCounters rmicounters;

    public AnySharedCountersImpl(String name, int type) {
        this.name = name;
        this.type = type;
        this.log = Log.getLogWriter();
    }

    protected void setRmiCounters(RmiSharedCounters rmisc) {
        this.rmicounters = rmisc;
    }

    public static SharedCounters bind(String name, int type, long[] initialValues) {
        switch (type) {
            case 0: {
                try {
                    RmiSharedCountersImpl rmisc = new RmiSharedCountersImpl(initialValues);
                    RmiSharedCountersImpl.bind(name, rmisc);
                    AnySharedCountersImpl asci = new AnySharedCountersImpl(name, type);
                    asci.setRmiCounters(rmisc);
                    return asci;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to bind RMI counters: " + name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + type);
    }

    public static SharedCounters lookup(String name, int type) {
        switch (type) {
            case 0: {
                RmiSharedCounters rmisc = null;
                try {
                    rmisc = RmiSharedCountersImpl.lookup(name);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to look up RMI counters: " + name, e);
                }
                if (rmisc == null) {
                    return null;
                }
                AnySharedCountersImpl asci = new AnySharedCountersImpl(name, type);
                asci.setRmiCounters(rmisc);
                return asci;
            }
        }
        throw new HydraInternalException("Illegal transport type: " + type);
    }

    @Override
    public long read(int index) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.read(index);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public long add(int index, long i) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.add(index, i);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public long subtract(int index, long i) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.subtract(index, i);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public void increment(int index) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmicounters.increment(index);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name + " " + this.rmicounters, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public void decrement(int index) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmicounters.decrement(index);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public long incrementAndRead(int index) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.incrementAndRead(index);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public long decrementAndRead(int index) {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.decrementAndRead(index);
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }

    @Override
    public void zero(int index) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmicounters.zero(index);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public void setIfLarger(int index, long i) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmicounters.setIfLarger(index, i);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public void setIfSmaller(int index, long i) {
        switch (this.type) {
            case 0: {
                try {
                    this.rmicounters.setIfSmaller(index, i);
                    break;
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
            default: {
                throw new HydraInternalException("Illegal transport type: " + this.type);
            }
        }
    }

    @Override
    public long[] getCounterValues() {
        switch (this.type) {
            case 0: {
                try {
                    return this.rmicounters.getCounterValues();
                }
                catch (RemoteException e) {
                    throw new HydraRuntimeException("Unable to access RMI counters: " + this.name, e);
                }
            }
        }
        throw new HydraInternalException("Illegal transport type: " + this.type);
    }
}

