/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraVector;
import hydra.ProductVersionHelper;
import hydra.TestConfig;
import hydra.VersionPrms;
import hydra.VmDescription;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class VersionDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String gemfireHome;
    private String version;
    private Set<String> versions;
    private Map<String, String> mapping;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public String getGemFireHome() {
        return this.gemfireHome;
    }

    private void setGemFireHome(String str) {
        this.gemfireHome = str;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String str) {
        this.version = str;
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    private void setVersions(Set<String> str) {
        this.versions = str;
    }

    protected Map<String, String> getVersionMapping() {
        return this.mapping;
    }

    private void setVersionMapping(Map<String, String> map) {
        this.mapping = map;
    }

    protected String getGemFireHome(VmDescription vmd, String version) {
        if (version.equals("default")) {
            if (this.mapping.get(version) != "default") {
                String s = "Unexpected mismatch: version=" + version + " gemfireHome=" + this.mapping.get(version);
                throw new HydraInternalException(s);
            }
            return vmd.getHostDescription().getGemFireHome();
        }
        return this.mapping.get(version);
    }

    protected String getClassPath(VmDescription vmd, String version, String javaHome) {
        Vector extra;
        List<String> gemfirexdClassPaths;
        Vector<String> classpath = new Vector<String>();
        String gfh = this.getGemFireHome(vmd, version);
        HostDescription hd = vmd.getHostDescription().copy();
        hd.setGemFireHome(gfh);
        if (javaHome != null) {
            hd.setJavaHome(javaHome);
        }
        if ((gemfirexdClassPaths = vmd.getGemFireXDClassPaths()) != null) {
            for (String gemfirexdClassPath : gemfirexdClassPaths) {
                String path = gemfirexdClassPath.replace(vmd.getHostDescription().getGemFireHome(), gfh);
                classpath.add(path);
            }
        }
        if ((extra = vmd.getUnconvertedExtraClassPath()) != null && extra.size() > 0) {
            extra = EnvHelper.expandEnvVars(extra, hd);
            classpath.addAll(extra);
        }
        classpath.add(hd.getTestDir() + hd.getFileSep() + "junit.jar");
        if (version != null && version != "default") {
            classpath.add(hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "tests" + version + hd.getFileSep() + "classes");
        }
        classpath.add(hd.getTestDir());
        if (hd.getExtraTestDir() != null) {
            classpath.add(hd.getExtraTestDir());
        }
        classpath.add(hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "libs" + hd.getFileSep() + "snappydata-store-hydra-tests-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + "-all.jar");
        classpath.add(VmDescription.getSnappyJarPath(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep(), "snappydata-store-scala-tests*tests.jar"));
        classpath.add(gfh + hd.getFileSep() + "lib" + hd.getFileSep() + "snappydata-store-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + ".jar");
        return EnvHelper.asPath(classpath, hd);
    }

    protected String getLibPath(VmDescription vmd, String version, String javaHome) {
        Vector<String> libpath = new Vector<String>();
        String gfh = this.getGemFireHome(vmd, version);
        HostDescription hd = vmd.getHostDescription().copy();
        hd.setGemFireHome(gfh);
        if (javaHome != null) {
            hd.setJavaHome(javaHome);
        }
        libpath.add(gfh + hd.getFileSep() + "lib");
        libpath.add(gfh + hd.getFileSep() + ".." + hd.getFileSep() + "hidden" + hd.getFileSep() + "lib");
        Vector extra = vmd.getUnconvertedExtraLibPath();
        if (extra != null && extra.size() > 0) {
            extra = EnvHelper.expandEnvVars(extra, hd);
            libpath.addAll(extra);
        }
        return EnvHelper.asPath(libpath, hd);
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "gemfireHome", this.getGemFireHome());
        map.put(header + "version", this.getVersion());
        map.put(header + "versions", this.getVersions());
        map.put(header + "versionMapping", this.getVersionMapping());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(VersionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            VersionDescription vd = VersionDescription.createVersionDescription(name, config, i);
            if (vd == null) continue;
            config.addVersionDescription(vd);
        }
    }

    private static VersionDescription createVersionDescription(String name, TestConfig config, int index) {
        HydraVector strs;
        ConfigHashtable tab = config.getParameters();
        VersionDescription vd = new VersionDescription();
        vd.setName(name);
        Long key = VersionPrms.gemfireHome;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            vd.setGemFireHome(str);
        }
        if ((str = tab.getString(key = VersionPrms.version, tab.getWild(key, index, null))) != null) {
            vd.setVersion(VersionDescription.getVersion(str, key));
        }
        if ((strs = tab.vecAtWild(key = VersionPrms.versions, index, null)) != null && strs.size() > 0) {
            LinkedHashSet<String> tmp = new LinkedHashSet<String>();
            Iterator i = strs.iterator();
            while (i.hasNext()) {
                String str2 = tab.getString(key, i.next());
                if (str2 == null) {
                    tmp.add("default");
                    continue;
                }
                tmp.add(VersionDescription.getVersion(str2, key));
            }
            vd.setVersions(tmp);
            vd.setVersion(null);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (vd.getVersions() == null) {
            if (vd.getVersion() == null) {
                if (vd.getGemFireHome() == null) {
                    return null;
                }
                map.put("default", vd.getGemFireHome());
            } else if (vd.getGemFireHome() == null) {
                map.put(vd.getVersion(), VersionDescription.getGemFireHome(vd.getVersion()));
            } else {
                map.put(vd.getVersion(), vd.getGemFireHome());
            }
        } else {
            for (String ver : vd.getVersions()) {
                map.put(ver, VersionDescription.getGemFireHome(ver));
            }
        }
        vd.setVersionMapping(map);
        return vd;
    }

    private static String getVersion(String str, Long key) {
        for (int i = 0; i < VersionPrms.SUPPORTED_VERSIONS.length; ++i) {
            if (!str.equals(VersionPrms.SUPPORTED_VERSIONS[i])) continue;
            return str;
        }
        String s = BasePrms.nameForKey(key) + " is unsupported: " + str;
        throw new HydraConfigException(s);
    }

    public static String getGemFireHome(String version) {
        String gemfireHome = version.equals("default") ? "default" : (version.equals("100") ? System.getProperty("RELEASE_DIR", "/export/gcm/where/gemfireXD/releases") + "/GemFireXD" + VersionDescription.dotVersionFor(version) + "-all/product" : System.getProperty("RELEASE_DIR", "/export/gcm/where/gemfireXD/releases") + "/GemFireXD" + VersionDescription.dotVersionFor(version) + "-all/Linux/product");
        return gemfireHome;
    }

    public static String dotVersionFor(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version is null");
        }
        String dotVersion = "" + version.charAt(0);
        for (int i = 1; i < version.length(); ++i) {
            dotVersion = dotVersion + "." + version.charAt(i);
        }
        return dotVersion;
    }
}

