/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import java.util.Vector;

public class VecSorter {
    private static int doCompare(Object o1, Object o2) throws Exception {
        if (o1 instanceof String && o2 instanceof String) {
            String str1 = (String)o1;
            str1 = str1.toUpperCase();
            String str2 = (String)o2;
            str2 = str2.toUpperCase();
            return str1.compareTo(str2);
        }
        throw new Exception("VecSorter can only handle Strings");
    }

    private static void swap(Vector arr, int i, int j) {
        Object tmp = arr.elementAt(i);
        arr.setElementAt(arr.elementAt(j), i);
        arr.setElementAt(tmp, j);
    }

    public static void quickSort(Vector arr, int left, int right) {
        if (left >= right) {
            return;
        }
        VecSorter.swap(arr, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            try {
                if (VecSorter.doCompare(arr.elementAt(i), arr.elementAt(left)) >= 0) continue;
                VecSorter.swap(arr, ++last, i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        VecSorter.swap(arr, left, last);
        VecSorter.quickSort(arr, left, last - 1);
        VecSorter.quickSort(arr, last + 1, right);
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < 10000; ++i) {
            v.add(String.valueOf(i));
        }
        long begin = System.currentTimeMillis();
        VecSorter.quickSort(v, 0, v.size() - 1);
        long end = System.currentTimeMillis();
        System.out.println("Time for sort: " + (end - begin));
        for (int i = 0; i < 30; ++i) {
            System.out.println(v.elementAt(i));
        }
    }
}

