/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HostPrms;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Platform;
import java.io.File;
import java.io.IOException;

public class UnixPlatform
extends Platform {
    private static final String DEVNULL = "/dev/null";
    private static final String KILL = "/bin/kill";
    protected static final String SHELL = "/bin/bash";
    private static final String SOLARIS_CHMOD = "/opt/sfw/bin/gchmod";
    private static final String LINUX_CHMOD = "/bin/chmod";
    private static final String EXISTS = "0";
    private static final String SIGQUIT = "QUIT";
    private static final String SIGKILL = "KILL";
    private static final String SIGTERM = "TERM";
    private static final String SIGURG = "URG";

    @Override
    protected int bgexecInternal(String[] cmdarray, String workdir, String logfile) throws IOException {
        if (logfile == null || logfile.equals("")) {
            logfile = DEVNULL;
        }
        if (cmdarray.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < cmdarray.length; ++i) {
            if (cmdarray[i] != null) continue;
            throw new NullPointerException();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmdarray.length; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            sb.append("\"");
            sb.append(cmdarray[i]);
            sb.append("\"");
        }
        sb.append(" <");
        sb.append(DEVNULL);
        sb.append(" >");
        sb.append(logfile);
        sb.append(" 2>&1 & echo $!");
        String[] job = new String[]{SHELL, "--norc", "-c", sb.toString()};
        File cmd = new File(job[0]);
        if (!cmd.exists()) {
            throw new IOException("the executable \"" + cmd.getPath() + "\" does not exist");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExec(job[0]);
        }
        String[] buf = new String[1];
        int pid = -1;
        try {
            if (this.fgexec(job, buf, new File(workdir)) == 0) {
                pid = Integer.parseInt(buf[0].trim());
            }
        }
        catch (IOException ioe) {
            System.out.println("Exception: Failed to get PID: " + ioe.getMessage());
        }
        catch (NumberFormatException nfe) {
            System.out.println("Exception: Failed to get PID: " + nfe.getMessage());
        }
        if (logfile.indexOf("bgexec") != -1) {
            File f = new File(logfile);
            String fn = f.getName();
            fn = fn.substring(0, fn.lastIndexOf(".log"));
            String path = f.getParent();
            String newfn = path + File.separator + fn + "_" + pid + ".log";
            File newf = new File(newfn);
            if (pid != -1 && !f.renameTo(newf)) {
                Log.getLogWriter().warning("Failed to rename log file " + logfile);
            }
        }
        return pid;
    }

    private boolean sendSignal(String sig, int pid) throws IllegalArgumentException {
        String[] cmdarray = new String[]{KILL, "-" + sig, String.valueOf(pid)};
        try {
            String[] tmp = new String[1];
            return this.fgexec(cmdarray, tmp, null) == 0;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    protected boolean exists(int pid) {
        this.checkPid(pid);
        return this.sendSignal(EXISTS, pid);
    }

    @Override
    protected void shutdown(int pid) {
        this.checkPid(pid);
        this.sendSignal(SIGTERM, pid);
    }

    @Override
    protected void kill(int pid) {
        this.checkPid(pid);
        this.sendSignal(SIGKILL, pid);
    }

    @Override
    protected void printStacks(int pid) {
        this.checkPid(pid);
        this.sendSignal(SIGURG, pid);
        this.sendSignal(SIGQUIT, pid);
    }

    @Override
    protected void dumpHeap(int pid, String userDir, String options) {
        this.checkPid(pid);
        String[] cmd = this.getDumpHeapCommand(pid, userDir, options);
        if (cmd != null) {
            try {
                this.fgexec(cmd, new String[1], null);
            }
            catch (IOException e) {
                Log.getLogWriter().severe(this.getStackTrace(e));
            }
        }
    }

    @Override
    protected String getNetworkStatistics(int maxWaitSec) {
        String cmd = "/bin/netstat";
        if (FileUtil.exists(cmd)) {
            cmd = cmd + " -an";
            return this.fgexec(cmd, maxWaitSec);
        }
        String s = "Unable to access network statistics";
        throw new HydraRuntimeException(s);
    }

    @Override
    protected String getShutdownCommand(int pid) {
        return "/bin/kill -TERM " + pid;
    }

    @Override
    protected String getKillCommand(int pid) {
        return "/bin/kill -KILL " + pid;
    }

    @Override
    protected String getDumpLocksCommand(int pid) {
        return "/bin/kill -URG " + pid;
    }

    @Override
    protected String getPrintStacksCommand(int pid) {
        return "/bin/kill -QUIT " + pid;
    }

    @Override
    protected String[] getDumpHeapCommand(int pid, String userDir, String options) {
        this.checkPid(pid);
        String[] cmd = null;
        if (HostPrms.getJavaVendor().equals("Sun")) {
            cmd = new String[3];
            String dir = userDir == null ? System.getProperty("user.dir") : userDir;
            String fn = dir + "/java_" + HostHelper.getLocalHost() + "_" + pid + ".hprof";
            cmd[0] = System.getProperty("java.home") + "/../bin/jmap";
            cmd[1] = options == null ? "-dump:live,format=b" : options;
            cmd[1] = cmd[1] + ",file=" + fn;
            cmd[2] = String.valueOf(pid);
        }
        return cmd;
    }

    @Override
    protected String getNetcontrolCommand(String target, int op) {
        String script = "/export/localnew/scripts/netcontrol";
        if (!FileUtil.exists(script) && !FileUtil.exists(script = "/export/shared/sysadm/scripts/netcontrol")) {
            String s = "netcontrol script not found, please work with I.S. to install";
            throw new HydraRuntimeException(s);
        }
        String cmd = this.sudo() + " " + script;
        switch (op) {
            case 0: {
                return cmd + " -a -D -t -H " + target;
            }
            case 1: {
                return cmd + " -r -D -t -H " + target;
            }
            case 2: {
                return cmd + " -C";
            }
            case 3: {
                return cmd + " -S";
            }
        }
        String s = "Should not happen";
        throw new HydraInternalException(s);
    }

    @Override
    protected void restartNTP() {
        this.invokeNTP("restart");
    }

    private void invokeNTP(String op) {
        String sudo = this.sudo();
        if (sudo == null) {
            Log.getLogWriter().warning("Unable to find sudo to invoke NTP");
        } else {
            String ntp = this.ntp();
            if (ntp == null) {
                Log.getLogWriter().warning("Unable to find NTP executable");
            } else {
                String cmd = sudo + " " + ntp + " " + op;
                Log.getLogWriter().info("Executing NTP " + op + "...");
                String result = this.fgexec(cmd, 300);
                Log.getLogWriter().info("Executed NTP " + op + ":\n" + result);
            }
        }
    }

    private void resetNTPClock() {
        String sudo = this.sudo();
        if (sudo == null) {
            Log.getLogWriter().warning("Unable to find sudo to invoke NTP");
        } else {
            String ntpdate = this.ntpdate();
            if (ntpdate == null) {
                Log.getLogWriter().warning("Unable to find NTP date executable");
            } else {
                Log.getLogWriter().info("Resetting the clock");
                String cmd = sudo + " " + ntpdate + " gateway";
                String result = this.fgexec(cmd, 300);
                Log.getLogWriter().info("Reset the clock:\n" + result);
            }
        }
    }

    protected String sudo() {
        String sudo = "/usr/bin/sudo";
        if (!FileUtil.exists(sudo) && !FileUtil.exists(sudo = "/opt/sfw/bin/sudo")) {
            return null;
        }
        return sudo;
    }

    private String ntp() {
        String ntp = "/etc/init.d/ntpd";
        if (!(FileUtil.exists(ntp) || FileUtil.exists(ntp = "/etc/init.d/xntpd") || FileUtil.exists(ntp = "/etc/init.d/ntp") || FileUtil.exists(ntp = "/etc/init.d/xntpd"))) {
            return null;
        }
        return ntp;
    }

    private String ntpdate() {
        String ntpdate = "/usr/sbin/ntpdate";
        if (!FileUtil.exists(ntpdate)) {
            return null;
        }
        return ntpdate;
    }

    @Override
    protected String getFileExtension() {
        return ".sh";
    }

    @Override
    protected String getScriptHeader() {
        return "#!/bin/sh\n#\n";
    }

    @Override
    protected String getCommentPrefix() {
        return "# ";
    }

    @Override
    protected void setExecutePermission(String fn) {
        this.fgexec(this.getChmodCommand() + " u+rwx " + fn, 600);
    }

    @Override
    protected void setReadPermission(String dir) {
        this.fgexec(this.getChmodCommand() + " -R uog+r " + dir, 600);
    }

    private String getChmodCommand() {
        if (FileUtil.exists(SOLARIS_CHMOD)) {
            return SOLARIS_CHMOD;
        }
        if (FileUtil.exists(LINUX_CHMOD)) {
            return LINUX_CHMOD;
        }
        String s = "Unable to find chmod command";
        throw new HydraRuntimeException(s);
    }

    @Override
    protected String getProcessStatus(int maxWaitSec) {
        String cmd = "ps -e -o user,pid,pmem,stime,args";
        return this.fgexec(cmd, maxWaitSec);
    }

    @Override
    protected String getMemoryStatus(int maxWaitSec) {
        String cmd = "/usr/bin/free";
        if (FileUtil.exists(cmd)) {
            return this.fgexec(cmd, maxWaitSec);
        }
        cmd = "/usr/bin/vmstat";
        if (FileUtil.exists(cmd)) {
            return this.fgexec(cmd, maxWaitSec);
        }
        String s = "Unable to get memory status";
        throw new HydraRuntimeException(s);
    }
}

