/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import dunit.impl.DUnitBB;
import dunit.impl.HostImpl;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.TestTaskResult;
import java.rmi.RemoteException;
import java.util.Vector;
import swarm.Swarm;
import swarm.TestType;
import swarm.UnitTestObserver;

public class UnitTestController {
    public static final String NAME = "controller";
    private static boolean hasFailureOccured = false;
    private static final String GlobalUnitTestResult = "GlobalUnitTestResult";
    private static final UnitTestObserver observer = Swarm.getUnitTestObserver();

    public static void createAndStartLocator() {
        DistributedSystemHelper.createLocator();
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocator() {
        DistributedSystemHelper.stopLocator();
    }

    public static void scheduleUnitTests() {
        try {
            HostImpl.initialize();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("While initializing HostImpl...", e);
        }
        UnitTestController.setUnitTestResult(Boolean.TRUE, false);
        boolean UnitTestResult = true;
        Vector unitTests = TestConfig.getInstance().getUnitTests();
        observer.testTypeDetected(TestType.DUNIT);
        observer.totalTestCountDetected(unitTests.size());
        Log.getLogWriter().info("sssControllerUnitTestsCount:" + unitTests.size());
        for (TestTask unitTest : unitTests) {
            if (!UnitTestController.isTestAvailable(unitTest)) continue;
            UnitTestResult = UnitTestController.scheduleUnitTest(unitTest) && UnitTestResult;
            observer.incCurrentTestCount();
            Log.getLogWriter().info("sssCURRENT TEST COUNT:" + Swarm.getCurrentUnitTestCount() + "/" + Swarm.getTotalUnitTestCount());
        }
        if (!UnitTestResult && !hasFailureOccured) {
            hasFailureOccured = true;
            UnitTestController.setUnitTestResult(Boolean.FALSE, true);
        }
    }

    private static boolean isTestAvailable(TestTask unitTest) {
        try {
            DUnitBB.getBB().getSharedLock().lock();
            String unitTestAsString = unitTest.toString();
            if (DUnitBB.getBB().getSharedMap().containsKey(unitTestAsString)) {
                boolean bl = false;
                return bl;
            }
            DUnitBB.getBB().getSharedMap().put(unitTestAsString, Boolean.TRUE);
        }
        finally {
            DUnitBB.getBB().getSharedLock().unlock();
        }
        return true;
    }

    static void setUnitTestResult(Boolean status, boolean overwrite) {
        try {
            Boolean previous;
            DUnitBB.getBB().getSharedLock().lock();
            if (!overwrite && (previous = (Boolean)DUnitBB.getBB().getSharedMap().get(GlobalUnitTestResult)) != null) {
                return;
            }
            DUnitBB.getBB().getSharedMap().put(GlobalUnitTestResult, status);
        }
        finally {
            DUnitBB.getBB().getSharedLock().unlock();
        }
    }

    static Boolean getUnitTestResult() {
        Boolean result = Boolean.FALSE;
        try {
            DUnitBB.getBB().getSharedLock().lock();
            result = (Boolean)DUnitBB.getBB().getSharedMap().get(GlobalUnitTestResult);
        }
        finally {
            DUnitBB.getBB().getSharedLock().unlock();
        }
        return result;
    }

    private static boolean scheduleUnitTest(TestTask task) {
        String hostname = RemoteTestModule.getMyHost();
        String lhostname = RemoteTestModule.getMyLogicalHost();
        Log.getLogWriter().info(hostname + " aka " + lhostname + ": Running unit test: " + task.toShortString());
        TestTaskResult result = task.execute();
        task.addElapsedTime(result.getElapsedTime());
        task.logUnitTestResult(result);
        return !result.getErrorStatus();
    }

    public static void checkUnitTestResults() {
        boolean passed = UnitTestController.getUnitTestResult();
        if (!passed) {
            throw new UnitTestFailure();
        }
    }

    public static class UnitTestFailure
    extends RuntimeException {
        public UnitTestFailure() {
            super("One or more DUnit tests failed.  Please see the \"failures\" directory for further details.");
        }
    }
}

